DECLARE
    new_status_id number(19);
    done_status_id number(19);
BEGIN
    -- select simple task status ids
    select id into new_status_id from entity_status where status_name = 'NEW' and entity_type= 'SIMPLETASK';
    select id into done_status_id from entity_status where status_name = 'DONE' and entity_type= 'SIMPLETASK';

    -- remove old process configs
    delete from entity_process where start_entity_status_id in (new_status_id, done_status_id);

    -- add actual simple task process configs
    insert into entity_process (id, start_entity_status_id, process_definition, process_trigger, target_entity_status_id)
        values(entity_process_seq.nextval, new_status_id, 'statusChangeUserTask', 'AUTOMATIC', done_status_id);
    insert into entity_process (id, start_entity_status_id, process_definition, process_trigger, target_entity_status_id)
        values(entity_process_seq.nextval, done_status_id, 'directStatusChange', 'MANUAL', new_status_id);

END;
/
COMMIT;
