ALTER TABLE entity_status ADD searchable_status char(1) DEFAULT ('f') NOT NULL;
ALTER TABLE entity_status ADD archived_status char(1) DEFAULT ('f') NOT NULL;

-- insert current status for the old release process
INSERT INTO entity_status (id, status_name, entity_type,default_status, searchable_status,archived_status)
SELECT entity_status_seq.nextval, status_name, entity_type, default_status, searchable_status, archived_status from
(SELECT UNIQUE(e.entity_type) AS entity_type, 'DRAFT' AS status_name, 't' AS default_status, 'f' AS searchable_status, 'f' AS archived_status 
    FROM entity_version v INNER JOIN entity e ON v.entity_id=e.id);
    
INSERT INTO entity_status (id, status_name, entity_type,default_status, searchable_status,archived_status)
SELECT entity_status_seq.nextval, status_name, entity_type, default_status, searchable_status, archived_status from
(SELECT UNIQUE(e.entity_type) AS entity_type, 'IN_REVIEW' AS status_name, 'f' AS default_status, 'f' AS searchable_status, 'f' AS archived_status 
    FROM entity_version v INNER JOIN entity e ON v.entity_id=e.id);
    
INSERT INTO entity_status (id, status_name, entity_type,default_status, searchable_status,archived_status)
SELECT entity_status_seq.nextval, status_name, entity_type, default_status, searchable_status, archived_status from
(SELECT UNIQUE(e.entity_type) AS entity_type, 'DECLINED' AS status_name, 'f' AS default_status, 'f' AS searchable_status, 'f' AS archived_status 
    FROM entity_version v INNER JOIN entity e ON v.entity_id=e.id);
    
INSERT INTO entity_status (id, status_name, entity_type,default_status, searchable_status,archived_status)
SELECT entity_status_seq.nextval, status_name, entity_type, default_status, searchable_status, archived_status from
(SELECT UNIQUE(e.entity_type) AS entity_type, 'RELEASED' AS status_name, 'f' AS default_status, 'f' AS searchable_status, 'f' AS archived_status 
    FROM entity_version v INNER JOIN entity e ON v.entity_id=e.id);
    
INSERT INTO entity_status (id, status_name, entity_type,default_status, searchable_status,archived_status)
SELECT entity_status_seq.nextval, status_name, entity_type, default_status, searchable_status, archived_status from
(SELECT UNIQUE(e.entity_type) AS entity_type, 'PUBLISHED' AS status_name, 'f' AS default_status, 't' AS searchable_status, 'f' AS archived_status 
    FROM entity_version v INNER JOIN entity e ON v.entity_id=e.id);
    
INSERT INTO entity_status (id, status_name, entity_type,default_status, searchable_status,archived_status)
SELECT entity_status_seq.nextval, status_name, entity_type, default_status, searchable_status, archived_status from
(SELECT UNIQUE(e.entity_type) AS entity_type, 'ARCHIVED' AS status_name, 'f' AS default_status, 't' AS searchable_status, 't' AS archived_status 
    FROM entity_version v INNER JOIN entity e ON v.entity_id=e.id);


-- insert default status for all entities without entity-versions
INSERT INTO entity_status (id, status_name, entity_type,default_status, searchable_status,archived_status)
SELECT entity_status_seq.nextval, 'DEFAULT', name, 't','t','f' FROM entity_type_name WHERE name IN (
    SELECT e.name from entity_type_name e LEFT JOIN entity_status s on e.name = s.entity_type WHERE s.status_name IS NULL
);

-- create id-reference to entity_status
ALTER TABLE entity_version ADD entity_status_id number(19) NULL;
ALTER TABLE entity_version ADD CONSTRAINT entity_version_status_fk FOREIGN KEY (entity_status_id) REFERENCES entity_status(id);

-- set id for current versions
UPDATE entity_version v1 SET (entity_status_id) = (
    SELECT s.id as status_id FROM entity_version v 
    INNER JOIN entity_status s ON v.version_status = s.status_name 
    INNER JOIN entity e ON v.entity_id=e.id AND e.entity_type=s.entity_type
    WHERE v1.id = v.id
);


-- update entity_status_id to NOT NULL
ALTER TABLE entity_version MODIFY entity_status_id number(19) NOT NULL;

--shadow table
ALTER TABLE sh_entity_version ADD entity_status_id number(19) NULL;

COMMIT;
