INSERT INTO version (id, release, name, type, description, "date")
VALUES (00004, '8.0', '00004_#patch_create_table_notification', 'FEATURE', '#9779 - Basis für Notifications schaffen', systimestamp);

CREATE SEQUENCE notification_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE notification (
    id number(19) NOT NULL,
    notification_type varchar2(255 CHAR) NOT NULL,
    state varchar2(255) NOT NULL,
    originator_id number(19) NOT NULL,
    receiver_id number(19) NOT NULL,
    entity_id number(19),
    subject_id number(19),
    create_date timestamp DEFAULT systimestamp NOT NULL,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT noti_pk PRIMARY KEY (id),
    CONSTRAINT noti_org_fk FOREIGN KEY (originator_id) REFERENCES person(id),
    CONSTRAINT noti_rec_fk FOREIGN KEY (receiver_id) REFERENCES person(id)
);

CREATE INDEX idx_notification_key ON notification (receiver_id, state);

COMMIT;
