INSERT INTO version (id, release, name, type, description, "date")
VALUES (00007, '7.6', '00007_#patch_add_subject_id_to_workstream_entry.sql', 'BUGFIX', '#7819 Workstream: Nicht alle Aktivitäten werden auf die Startseite gestreamt.', now());

ALTER TABLE workstream_entry
ADD (
    subject_item_id NUMBER(19, 0),
    subject_item_type VARCHAR2(32 CHAR)
);

ALTER TABLE sh_workstream_entry
ADD (
    subject_item_id NUMBER(19, 0),
    subject_item_type VARCHAR2(32 CHAR)
);

-- migrate subject IDs from attributes
update workstream_entry we
set (we.subject_item_id, we.subject_item_type) =
(
    select to_number(substr(wea.value, instr(wea.value, ',') + 1, length(wea.value))), substr(wea.value, 0, instr(wea.value, ',') - 1)
    from workstream_entry_attribute wea
    where we.id = wea.entry_id
       and (
          we.type = 'NEWSBLOG_ARTICLE_CREATED' AND wea.key = 'newsblog_article_id'
       or we.type = 'NEWSBLOG_ARTICLE_UPDATED' AND wea.key = 'newsblog_article_id'
       or we.type = 'NEWSBLOG_ARTICLE_COMMENTED' AND wea.key = 'newsblog_article_id'
       or we.type = 'FORUM_ARTICLE_CREATED' AND wea.key = 'topic_id'
       or we.type = 'FORUM_TOPIC_CREATED' AND wea.key = 'topic_id'
       or we.type = 'ALBUM_IMAGE_CREATED' AND wea.key = 'image_id'
       or we.type = 'ALBUM_IMAGE_COMMENTED' AND wea.key = 'image_id'
       or we.type = 'DOCUMENT_ENTITY_NEW' AND wea.key = 'document_id'
       or we.type = 'DOCUMENT_BLOG_NEW' AND wea.key = 'article_id'
       or we.type = 'DOCUMENT_COMMENT' AND wea.key = 'document_id'
       or we.type = 'VIDEOLINK_CREATED' AND wea.key = 'video_id'
       or we.type = 'VIDEOLINK_COMMENTED' AND wea.key = 'video_id')
);

update sh_workstream_entry we
set (we.subject_item_id, we.subject_item_type) =
(
    select to_number(substr(wea.value, instr(wea.value, ',') + 1, length(wea.value))), substr(wea.value, 0, instr(wea.value, ',') - 1)
    from sh_workstream_entry_attribute wea
    where we.id = wea.entry_id
       and (
          we.type = 'NEWSBLOG_ARTICLE_CREATED' AND wea.key = 'newsblog_article_id'
       or we.type = 'NEWSBLOG_ARTICLE_UPDATED' AND wea.key = 'newsblog_article_id'
       or we.type = 'NEWSBLOG_ARTICLE_COMMENTED' AND wea.key = 'newsblog_article_id'
       or we.type = 'FORUM_ARTICLE_CREATED' AND wea.key = 'topic_id'
       or we.type = 'FORUM_TOPIC_CREATED' AND wea.key = 'topic_id'
       or we.type = 'ALBUM_IMAGE_CREATED' AND wea.key = 'image_id'
       or we.type = 'ALBUM_IMAGE_COMMENTED' AND wea.key = 'image_id'
       or we.type = 'DOCUMENT_ENTITY_NEW' AND wea.key = 'document_id'
       or we.type = 'DOCUMENT_BLOG_NEW' AND wea.key = 'article_id'
       or we.type = 'DOCUMENT_COMMENT' AND wea.key = 'document_id'
       or we.type = 'VIDEOLINK_CREATED' AND wea.key = 'video_id'
       or we.type = 'VIDEOLINK_COMMENTED' AND wea.key = 'video_id')
);

update workstream_entry we
set (we.subject_item_id, we.subject_item_type) =
(
    select to_number(wea.value), 'PROFILE'
    from workstream_entry_attribute wea
    where we.id = wea.entry_id AND wea.key = 'friend_id'
)
where we.type = 'PROFILE_NEW_CONTACT';

update sh_workstream_entry we
set (we.subject_item_id, we.subject_item_type) =
(
    select to_number(wea.value), 'PROFILE'
    from sh_workstream_entry_attribute wea
    where we.id = wea.entry_id AND wea.key = 'friend_id'
)
where we.type = 'PROFILE_NEW_CONTACT';
  
-- for microblog postings, the subject is the message id itself
update workstream_entry
set subject_item_id = id,
    subject_item_type = 'WORKSTREAM_MESSAGE'
where type = 'MICROBLOG_POSTING';

update sh_workstream_entry
set subject_item_id = id,
    subject_item_type = 'WORKSTREAM_MESSAGE'
where type = 'MICROBLOG_POSTING';

-- all other messages: subject ID = origin ID
update workstream_entry
set subject_item_id = origin_item_id,
    subject_item_type = origin_item_type
where subject_item_id IS NULL;

update sh_workstream_entry
set subject_item_id = origin_item_id,
    subject_item_type = origin_item_type
where subject_item_id IS NULL;

ALTER TABLE workstream_entry
MODIFY (
    subject_item_id NOT NULL,
    subject_item_type NOT NULL
);

create index we_subject_idx on workstream_entry(subject_item_id, subject_item_type, origin_item_id, origin_item_type, id);

drop index idx_like_sub__subscriber;
create index idx_like_sub__subscriber on like_subscribe(subscriber_id, item_id, item_type);

COMMIT;
