/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.dbmaintain.database.DatabaseException;
import org.dbmaintain.database.DatabaseInfo;
import thirdparty.org.apache.commons.logging.Log;
import thirdparty.org.apache.commons.logging.LogFactory;

public class SimpleDataSource {
    private static final Log logger = LogFactory.getLog(SimpleDataSource.class);

    public static DataSource createDataSource(DatabaseInfo databaseInfo) {
        String driverClassName = databaseInfo.getDriverClassName();
        String url = databaseInfo.getUrl();
        String userName = databaseInfo.getUserName();
        String password = databaseInfo.getPassword();
        logger.info("Creating data source. Driver: " + driverClassName + ", url: " + url + ", user: " + userName + ", password: <not shown>");
        return (DataSource)Proxy.newProxyInstance(SimpleDataSource.class.getClassLoader(), new Class[]{DataSource.class}, (InvocationHandler)new SimpleDataSourceInvocationHandler(driverClassName, url, userName, password));
    }

    protected static class SimpleDataSourceInvocationHandler
    implements InvocationHandler {
        private String driverClassName;
        private String url;
        private String userName;
        private String password;

        protected SimpleDataSourceInvocationHandler(String driverClassName, String url, String userName, String password) {
            this.driverClassName = driverClassName;
            this.url = url;
            this.userName = userName;
            this.password = password;
        }

        public Object invoke(Object dataSourceProxy, Method method, Object[] args) throws Throwable {
            if (this.isEqualsMethod(method)) {
                return dataSourceProxy == args[0];
            }
            if (this.isHashCodeMethod(method)) {
                return this.hashCode();
            }
            if (this.isParameterLessGetConnectionMethod(method)) {
                return this.getDatabaseConnection();
            }
            return null;
        }

        protected Connection getDatabaseConnection() {
            try {
                Class.forName(this.driverClassName);
            }
            catch (ClassNotFoundException e) {
                throw new DatabaseException("Unable to connect to database. Driver class not found: " + this.driverClassName, e);
            }
            try {
                return DriverManager.getConnection(this.url, this.userName, this.password);
            }
            catch (SQLException e) {
                throw new DatabaseException("Unable to connect to database. Could not create connection for database url: " + this.url + ", user name: " + this.userName + ", password: <not shown>", e);
            }
        }

        protected boolean isEqualsMethod(Method method) {
            return "equals".equals(method.getName()) && method.getParameterTypes().length == 1 && Object.class.equals(method.getParameterTypes()[0]);
        }

        protected boolean isHashCodeMethod(Method method) {
            return "hashCode".equals(method.getName()) && method.getParameterTypes().length == 0;
        }

        protected boolean isParameterLessGetConnectionMethod(Method method) {
            return "getConnection".equals(method.getName()) && method.getParameterTypes().length == 0;
        }
    }
}

