/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain;

import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dbmaintain.DbMaintainer;
import org.dbmaintain.database.SQLHandler;
import org.dbmaintain.script.ExecutedScript;
import org.dbmaintain.script.Script;
import org.dbmaintain.script.analyzer.ScriptUpdate;
import org.dbmaintain.script.analyzer.ScriptUpdateType;
import org.dbmaintain.script.analyzer.ScriptUpdates;
import org.dbmaintain.script.analyzer.ScriptUpdatesAnalyzer;
import org.dbmaintain.script.analyzer.ScriptUpdatesFormatter;
import org.dbmaintain.script.executedscriptinfo.ExecutedScriptInfoSource;
import org.dbmaintain.script.executedscriptinfo.ScriptIndexes;
import org.dbmaintain.script.repository.ScriptRepository;
import org.dbmaintain.script.runner.ScriptRunner;
import org.dbmaintain.structure.clean.DBCleaner;
import org.dbmaintain.structure.clear.DBClearer;
import org.dbmaintain.structure.constraint.ConstraintsDisabler;
import org.dbmaintain.structure.sequence.SequenceUpdater;
import org.dbmaintain.util.DbMaintainException;
import thirdparty.org.apache.commons.logging.Log;
import thirdparty.org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDbMaintainer
implements DbMaintainer {
    private static Log logger = LogFactory.getLog(DefaultDbMaintainer.class);
    protected ExecutedScriptInfoSource executedScriptInfoSource;
    protected ScriptRepository scriptRepository;
    protected ScriptRunner scriptRunner;
    protected DBClearer dbClearer;
    protected DBCleaner dbCleaner;
    protected ConstraintsDisabler constraintsDisabler;
    protected SequenceUpdater sequenceUpdater;
    protected SQLHandler sqlHandler;
    protected boolean cleanDb;
    protected boolean fromScratchEnabled;
    protected boolean useScriptFileLastModificationDates;
    protected boolean allowOutOfSequenceExecutionOfPatchScripts;
    protected boolean disableConstraints;
    protected boolean updateSequences;
    protected ScriptUpdatesFormatter scriptUpdatesFormatter;
    protected long maxNrOfCharsWhenLoggingScriptContent;
    protected ScriptIndexes baseLineRevision;

    public DefaultDbMaintainer(ScriptRunner scriptRunner, ScriptRepository scriptRepository, ExecutedScriptInfoSource executedScriptInfoSource, boolean fromScratchEnabled, boolean useScriptFileLastModificationDates, boolean allowOutOfSequenceExecutionOfPatchScripts, boolean cleanDb, boolean disableConstraints, boolean updateSequences, DBClearer dbClearer, DBCleaner dbCleaner, ConstraintsDisabler constraintsDisabler, SequenceUpdater sequenceUpdater, ScriptUpdatesFormatter scriptUpdatesFormatter, SQLHandler sqlHandler, long maxNrOfCharsWhenLoggingScriptContent, ScriptIndexes baseLineRevision) {
        this.scriptRunner = scriptRunner;
        this.scriptRepository = scriptRepository;
        this.executedScriptInfoSource = executedScriptInfoSource;
        this.fromScratchEnabled = fromScratchEnabled;
        this.useScriptFileLastModificationDates = useScriptFileLastModificationDates;
        this.allowOutOfSequenceExecutionOfPatchScripts = allowOutOfSequenceExecutionOfPatchScripts;
        this.cleanDb = cleanDb;
        this.disableConstraints = disableConstraints;
        this.updateSequences = updateSequences;
        this.dbClearer = dbClearer;
        this.dbCleaner = dbCleaner;
        this.constraintsDisabler = constraintsDisabler;
        this.sequenceUpdater = sequenceUpdater;
        this.scriptUpdatesFormatter = scriptUpdatesFormatter;
        this.sqlHandler = sqlHandler;
        this.maxNrOfCharsWhenLoggingScriptContent = maxNrOfCharsWhenLoggingScriptContent;
        this.baseLineRevision = baseLineRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateDatabase(boolean dryRun) {
        try {
            ScriptUpdates scriptUpdates = this.getScriptUpdates();
            if (!this.getIncrementalScriptsThatFailedDuringLastUpdate().isEmpty() && !scriptUpdates.hasIrregularScriptUpdates()) {
                ExecutedScript failedExecutedScriptScript = this.getIncrementalScriptsThatFailedDuringLastUpdate().first();
                throw new DbMaintainException("During the latest update, the execution of the following incremental script failed: " + failedExecutedScriptScript + ". \nThis problem must be fixed before any other " + "updates can be performed.\n" + this.getErrorScriptOptionsMessage(failedExecutedScriptScript.getScript()));
            }
            if (!this.getRepeatableScriptsThatFailedDuringLastUpdate().isEmpty() && !scriptUpdates.hasIrregularScriptUpdates()) {
                ExecutedScript failedScript = this.getRepeatableScriptsThatFailedDuringLastUpdate().first();
                if (!scriptUpdates.getRegularlyAddedOrModifiedScripts().contains(new ScriptUpdate(ScriptUpdateType.REPEATABLE_SCRIPT_UPDATED, failedScript.getScript())) && !scriptUpdates.getRegularlyDeletedRepeatableScripts().contains(new ScriptUpdate(ScriptUpdateType.REPEATABLE_SCRIPT_DELETED, failedScript.getScript()))) {
                    throw new DbMaintainException("During the latest update, the execution of following repeatable script failed: " + this.getRepeatableScriptsThatFailedDuringLastUpdate().first() + ". \nThis problem must be fixed " + "before any other updates can be performed.");
                }
            }
            if (scriptUpdates.isEmpty()) {
                logger.info("The database is up to date");
                boolean failedScript = false;
                return failedScript;
            }
            boolean recreateFromScratch = false;
            if (this.fromScratchEnabled && this.isInitialDatabaseUpdate()) {
                logger.info("The database is updated for the first time. The database is cleared to be sure that we start with a clean database");
                recreateFromScratch = true;
            }
            if (scriptUpdates.hasIrregularScriptUpdates()) {
                if (this.fromScratchEnabled) {
                    logger.info("The database is recreated from scratch, since following irregular script updates were detected:\n" + this.scriptUpdatesFormatter.formatScriptUpdates(scriptUpdates.getIrregularScriptUpdates()));
                    recreateFromScratch = true;
                } else {
                    throw new DbMaintainException("Following irregular script updates were detected:\n" + this.scriptUpdatesFormatter.formatScriptUpdates(scriptUpdates.getIrregularScriptUpdates()) + "\nBecause of this, dbmaintain can't perform the update. To solve this problem, you can do one of the following:\n" + "  1: Revert the irregular updates and use regular script updates instead\n" + "  2: Enable the fromScratch option so that the database is recreated from scratch (all data will be lost)\n" + "  3: Perform the updates manually on the database and invoke the markDatabaseAsUpToDate operation (error prone)\n");
                }
            }
            if (recreateFromScratch) {
                if (this.baseLineRevision != null) {
                    throw new DbMaintainException("Unable to recreate the database from scratch: a baseline revision is set.\nAfter clearing the database only scripts starting from the baseline revision would have been executed. The other scripts would have been ignored resulting in an inconsistent database state.\nPlease clear the baseline revision if you want to perform a from scratch update.\nAnother option is to explicitly clear the database using the clear task and then performing the update.");
                }
                logger.info("The database is cleared, and all database scripts are executed.");
                if (!dryRun) {
                    this.dbClearer.clearDatabase();
                    this.executedScriptInfoSource.resetCachedState();
                    this.executeScripts(this.scriptRepository.getAllUpdateScripts());
                }
            } else {
                logger.info("The database is updated incrementally, since following regular script updates were detected:\n" + this.scriptUpdatesFormatter.formatScriptUpdates(scriptUpdates.getRegularScriptUpdates()));
                if (!dryRun) {
                    if (this.disableConstraints) {
                        this.constraintsDisabler.disableConstraints();
                    }
                    if (this.cleanDb) {
                        this.dbCleaner.cleanDatabase();
                    }
                    this.executeScriptUpdates(scriptUpdates.getRegularlyAddedPatchScripts());
                    this.executeScriptUpdates(scriptUpdates.getRegularlyAddedOrModifiedScripts());
                    this.removeDeletedRepeatableScriptsFromExecutedScripts(scriptUpdates.getRegularlyDeletedRepeatableScripts());
                    this.performRegularScriptRenamesInExecutedScripts(scriptUpdates.getRegularlyRenamedScripts());
                }
            }
            if (scriptUpdates.noUpdatesOtherThanRepeatableScriptDeletionsOrRenames()) {
                logger.info("No script updates were detected, except for repeatable script deletions and script renames. Therefore, actions such as the execution of postprocessing scripts and disabling the constraints are skipped.");
                boolean bl = false;
                return bl;
            }
            if (!dryRun) {
                this.executePostprocessingScripts();
                if (this.disableConstraints) {
                    this.constraintsDisabler.disableConstraints();
                }
                if (this.cleanDb) {
                    this.dbCleaner.cleanDatabase();
                }
                if (this.updateSequences) {
                    this.sequenceUpdater.updateSequences();
                }
                logger.info("The database has been updated successfully.");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.sqlHandler.closeAllConnections();
        }
    }

    public ScriptUpdates getScriptUpdates() {
        return new ScriptUpdatesAnalyzer(this.scriptRepository, this.executedScriptInfoSource, this.useScriptFileLastModificationDates, this.allowOutOfSequenceExecutionOfPatchScripts).calculateScriptUpdates();
    }

    protected boolean isInitialDatabaseUpdate() {
        return this.executedScriptInfoSource.getExecutedScripts().size() == 0 && this.scriptRepository.areScriptsAvailable();
    }

    protected void executePostprocessingScripts() {
        this.executedScriptInfoSource.deleteAllExecutedPostprocessingScripts();
        this.executeScripts(this.scriptRepository.getPostProcessingScripts());
    }

    protected Map<Script, ExecutedScript> getAlreadyExecutedScripts() {
        HashMap<Script, ExecutedScript> alreadyExecutedScripts = new HashMap<Script, ExecutedScript>();
        for (ExecutedScript executedScript : this.executedScriptInfoSource.getExecutedScripts()) {
            alreadyExecutedScripts.put(executedScript.getScript(), executedScript);
        }
        return alreadyExecutedScripts;
    }

    protected void removeDeletedRepeatableScriptsFromExecutedScripts(SortedSet<ScriptUpdate> repeatableScriptDeletions) {
        for (ScriptUpdate deletedRepeatableScriptUpdate : repeatableScriptDeletions) {
            this.executedScriptInfoSource.deleteExecutedScript(this.getAlreadyExecutedScripts().get(deletedRepeatableScriptUpdate.getScript()));
        }
    }

    protected void performRegularScriptRenamesInExecutedScripts(SortedSet<ScriptUpdate> regularScriptRenames) {
        for (ScriptUpdate regularScriptRename : regularScriptRenames) {
            this.executedScriptInfoSource.renameExecutedScript(this.getAlreadyExecutedScripts().get(regularScriptRename.getScript()), regularScriptRename.getRenamedToScript());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markDatabaseAsUpToDate() {
        try {
            this.executedScriptInfoSource.clearAllExecutedScripts();
            SortedSet<Script> allScripts = this.scriptRepository.getAllScripts();
            for (Script script : allScripts) {
                this.executedScriptInfoSource.registerExecutedScript(new ExecutedScript(script, new Date(), true));
            }
            logger.info("The database has been marked as up-to-date");
        }
        finally {
            this.sqlHandler.closeAllConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeScriptUpdates(SortedSet<ScriptUpdate> scriptUpdates) {
        this.scriptRunner.initialize();
        try {
            for (ScriptUpdate scriptUpdate : scriptUpdates) {
                long startTimeMs = System.currentTimeMillis();
                this.executeScript(scriptUpdate.getScript());
                long durationMs = System.currentTimeMillis() - startTimeMs;
                logger.info("Executed " + this.scriptUpdatesFormatter.formatScriptUpdate(scriptUpdate) + " (" + durationMs + " ms)");
            }
        }
        finally {
            this.scriptRunner.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeScripts(SortedSet<Script> scripts) {
        this.scriptRunner.initialize();
        try {
            for (Script script : scripts) {
                logger.info("Executing script " + script.getFileName());
                this.executeScript(script);
            }
        }
        finally {
            this.scriptRunner.close();
        }
    }

    protected void executeScript(Script script) {
        try {
            ExecutedScript executedScript = new ExecutedScript(script, new Date(), false);
            this.executedScriptInfoSource.registerExecutedScript(executedScript);
            this.scriptRunner.execute(script);
            executedScript.setSuccessful(true);
            this.executedScriptInfoSource.updateExecutedScript(executedScript);
        }
        catch (DbMaintainException e) {
            String message = this.getErrorMessage(script, e);
            throw new DbMaintainException(message, e.getCause());
        }
    }

    protected String getErrorMessage(Script script, DbMaintainException e) {
        String exceptionMessage = e.getMessage();
        Throwable cause = e.getCause();
        if (cause != null) {
            exceptionMessage = exceptionMessage + "\n\nCaused by: " + cause.getMessage();
            if (cause instanceof SQLException) {
                SQLException sqlException = (SQLException)cause;
                if (!exceptionMessage.endsWith("\n")) {
                    exceptionMessage = exceptionMessage + "\n";
                }
                exceptionMessage = exceptionMessage + "Error code: " + sqlException.getErrorCode() + ", sql state: " + sqlException.getSQLState();
            }
        }
        String message = "\nError while executing script " + script.getFileName() + ": " + exceptionMessage + "\n\n";
        message = message + "A rollback was performed but there could still be changes that were committed in the database (for example a creation of a table).\n" + this.getErrorScriptOptionsMessage(script) + "\n\n";
        if (this.maxNrOfCharsWhenLoggingScriptContent > 0L) {
            String scriptContents = script.getScriptContentHandle().getScriptContentsAsString(this.maxNrOfCharsWhenLoggingScriptContent);
            message = message + "Full contents of failed script " + script.getFileName() + ":\n";
            message = message + "----------------------------------------------------\n";
            message = message + scriptContents + "\n";
            message = message + "----------------------------------------------------\n";
        }
        return message;
    }

    protected String getErrorScriptOptionsMessage(Script script) {
        if (script.isRepeatable() || script.isPostProcessingScript()) {
            return "Please verify the state of the database and fix the script.\nYou can then continue the update by re-running the updateDatabase task. The error script will then be executed again.";
        }
        return "There are 2 options:\n1: Fix the script, manually perform the changes of the script and call the markErrorScriptPerformed task.\n2: Fix the script, revert committed changes of the script (if any) and call the markErrorScriptReverted task.\n\nYou can then continue the update by re-running the updateDatabase task. The error script will only be executed again when option 2 was chosen.";
    }

    protected SortedSet<ExecutedScript> getIncrementalScriptsThatFailedDuringLastUpdate() {
        TreeSet<ExecutedScript> failedExecutedScripts = new TreeSet<ExecutedScript>();
        for (ExecutedScript script : this.executedScriptInfoSource.getExecutedScripts()) {
            if (script.isSuccessful().booleanValue() || !script.getScript().isIncremental()) continue;
            failedExecutedScripts.add(script);
        }
        return failedExecutedScripts;
    }

    protected SortedSet<ExecutedScript> getRepeatableScriptsThatFailedDuringLastUpdate() {
        TreeSet<ExecutedScript> failedExecutedScripts = new TreeSet<ExecutedScript>();
        for (ExecutedScript script : this.executedScriptInfoSource.getExecutedScripts()) {
            if (script.isSuccessful().booleanValue() || !script.getScript().isRepeatable()) continue;
            failedExecutedScripts.add(script);
        }
        return failedExecutedScripts;
    }
}

