UPDATE workstream_entry w
SET subject_item_id = (
    SELECT 'DRIVE_DOCUMENT,' || dbms_lob.substr( a.value, 255 )
    FROM workstream_entry_attribute a
    WHERE a.entry_id = w.id
    AND a.key = 'document_id'
)
WHERE w.type = 'DRIVE_DOCUMENT_NEW_VERSION'
AND EXISTS (
    SELECT 1
    FROM workstream_entry_attribute a
    WHERE a.entry_id = w.id
    AND a.key = 'document_id'
);

DELETE FROM workstream_entry_attribute a
WHERE a.key = 'document_id'
AND EXISTS (
    SELECT 1 FROM workstream_entry w
    WHERE w.id = a.entry_id
    AND w.type = 'DRIVE_DOCUMENT_NEW_VERSION'
);

COMMIT;
