-- insert entity_versions for currently unversioned entities due to failing patch 022_8.10/00007_#patch_add_version_for_every_entity.sql
INSERT INTO entity_version (id,entity_id, person_id,entity_status_id, version_status, major_version, minor_version, draft_version,version_type)
SELECT entity_version_seq.nextval, e.id, COALESCE(emr.person_id,-1), s.id, s.status_name, 0, 0, 1, 'MINOR'
    FROM entity e LEFT JOIN entity_version v ON e.id=v.entity_id 
    INNER JOIN entity_status s ON s.default_status='t' AND s.entity_type=e.entity_type
    LEFT JOIN (select min(person_id) as person_id, entity_id from entity_member_role where role = 'ADMIN' group by entity_id) emr ON e.id = emr.entity_id
    WHERE v.id IS NULL;

-- attach the newest multi-wiki-versions to the newly created entity_versions
INSERT INTO entity_version_components (multi_wiki_version_id, entity_version_id)
SELECT MAX(mwv.id) AS multi_wiki_version_id,MAX(ev.id) AS entity_version_id 
FROM multi_wiki_version mwv 
INNER JOIN multi_wiki mw ON mw.id=mwv.wiki_id
INNER JOIN entity_version ev ON mw.entity_id=ev.entity_id
LEFT JOIN entity_version_components evc ON evc.multi_wiki_version_id=mwv.id OR evc.entity_version_id=ev.id
WHERE evc.entity_version_id IS NULL
GROUP BY mw.entity_id;

COMMIT;

