
-- create data table for this fix
CREATE TABLE temp_fix_entity_version (
    entity_id number(19) NOT NULL,
    version_id number(19) NOT NULL,
    latest_version char(1) DEFAULT ('f') NOT NULL,
    expired_version char(1) NOT NULL,
    entity_type varchar2(255) NOT NULL
);

-- find versions to be fixed
INSERT INTO temp_fix_entity_version (entity_id, version_id, expired_version, entity_type)
SELECT  entity_id,
        v.id AS version_id,
        CASE WHEN expiration_date < now() THEN 't'
        ELSE 'f'
        END AS expired_version,
        s.entity_type
FROM entity_version v JOIN entity_status s on (v.entity_status_id = s.id)
WHERE s.status_name IN ('PUBLISHED', 'ARCHIVED')
AND entity_id IN (
    SELECT pub.entity_id
    FROM entity_version pub
    JOIN entity_version arch ON (pub.entity_id = arch.entity_id)
    WHERE pub.entity_status_id in (select id from entity_status where status_name = 'PUBLISHED')
    AND  arch.entity_status_id in (select id from entity_status where status_name = 'ARCHIVED')
    AND  pub.id < arch.id
);

-- find the latest version and remember it
UPDATE temp_fix_entity_version
SET latest_version = 't'
WHERE version_id IN (
    SELECT MAX(version_id)
    FROM temp_fix_entity_version
    GROUP BY entity_id
);

-- set all versions to archived which are not our latest or not expired yet
UPDATE entity_version v
 SET (version_status, entity_status_id) = 
(SELECT s.status_name, s.id new_status_id from temp_fix_entity_version fv, entity_status s
 WHERE fv.version_id = v.id AND s.entity_type = fv.entity_type and s.status_name='ARCHIVED')
 WHERE EXISTS (
    SELECT 1
      FROM temp_fix_entity_version fv
     WHERE v.id = fv.version_id AND (latest_version = 'f' OR (latest_version='t' AND expired_version = 't')));

-- set all latest versions to published which are not expired yet
UPDATE entity_version v
 SET (version_status, entity_status_id) = 
(SELECT s.status_name, s.id new_status_id from temp_fix_entity_version fv, entity_status s
 WHERE fv.version_id = v.id AND s.entity_type = fv.entity_type and s.status_name='PUBLISHED')
 WHERE EXISTS (
    SELECT 1
      FROM temp_fix_entity_version fv
     WHERE v.id = fv.version_id AND latest_version = 't'  AND expired_version = 'f');


-- remove temp table
DROP TABLE temp_fix_entity_version;

COMMIT;
