INSERT INTO version (id, release, name, type, description, "date")
VALUES (00005, '7.8', '00005_#patch_create_entity_recommendation_table', 'FEATURE', '#4748 - Creates a table to store recommendations of an entity by one person to another', now());

CREATE TABLE entity_recommendation (
    person_id number(19) NOT NULL,
    entity_id number(19) NOT NULL,
    recommender_id number(19) NOT NULL,
    recommend_message varchar2(4000 CHAR) NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT ent_rec_pk PRIMARY KEY (entity_id, person_id),
    CONSTRAINT ent_rec_entity_fk FOREIGN KEY (entity_id) REFERENCES entity(id),
    CONSTRAINT ent_rec_person_fk FOREIGN KEY (person_id) REFERENCES person(id),
    CONSTRAINT ent_rec_recommender_fk FOREIGN KEY (recommender_id) REFERENCES person(id)
);

CREATE TABLE SH_ENTITY_RECOMMENDATION (
    "PERSON_ID" number(19, 0),
    "ENTITY_ID" number(19, 0),
    "RECOMMENDER_ID" number(19, 0),
    "RECOMMEND_MESSAGE" varchar2(4000 CHAR) NOT NULL,
    "CREATE_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ENTITY_ID", "PERSON_ID")
);

INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY_RECOMMENDATION','SH_ENTITY_RECOMMENDATION','f');

COMMIT;
