CREATE SEQUENCE SEQ_base_property
    START WITH 3949
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE SEQUENCE SEQ_domain_property
    START WITH 3534
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE accepted_external_invitation (
    inviter_id numeric(10,0) NOT NULL,
    person_id numeric(10,0) NOT NULL,
    CONSTRAINT accepted_external_invitatio_pk PRIMARY KEY (person_id, inviter_id)
);

CREATE TABLE album (
    id number(8) NOT NULL,
    title varchar2(255 CHAR) NOT NULL,
    description clob,
    location varchar2(80 CHAR),
    "access" integer DEFAULT 0,
    create_date timestamp with time zone DEFAULT systimestamp NOT NULL,
    person_id number(8),
    group_id number(8),
    wiki_group_id number(8),
    network_id number(8),
    appointment_id number(8),
    CONSTRAINT album_pk PRIMARY KEY (id)
);

CREATE TABLE appointment_participant (
    person_id numeric(10,0) NOT NULL,
    appointment_id number(8) NOT NULL,
    status integer DEFAULT 0 NOT NULL,
    list integer,
    modify_date timestamp DEFAULT systimestamp NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    date_in_list timestamp DEFAULT systimestamp NOT NULL,
    participant_role integer DEFAULT 0 NOT NULL,
    last_notify_list integer,
    last_notify_date timestamp,
    inviter_id number(8),
    CONSTRAINT appointment_participant_pk PRIMARY KEY (person_id, appointment_id)
);

CREATE INDEX idx_appointment_par__date_in_l ON appointment_participant (date_in_list);
CREATE INDEX idx_appointment_par__l_n_date ON appointment_participant (last_notify_date);
CREATE INDEX idx_appointment_par__l_n_list ON appointment_participant (last_notify_list);
CREATE INDEX idx_appointment_par__list ON appointment_participant (list);
CREATE INDEX idx_appointment_par__part_role ON appointment_participant (participant_role);
CREATE INDEX idx_appointment_par__person ON appointment_participant (person_id);

CREATE TABLE appointment_widget_cfg (
    appointment_id number(8) NOT NULL,
    list_participant_visible char(1) DEFAULT ('Y') NOT NULL,
    list_wait_visible char(1) DEFAULT ('Y') NOT NULL,
    list_undecided_visible char(1) DEFAULT ('Y') NOT NULL,
    list_rejected_visible char(1) DEFAULT ('Y') NOT NULL,
    news_visible char(1) DEFAULT ('Y') NOT NULL,
    documents_visible char(1) DEFAULT ('Y') NOT NULL,
    album_visible char(1) DEFAULT ('Y') NOT NULL,
    video_visible char(1) DEFAULT ('Y') NOT NULL,
    forum_visible char(1) DEFAULT ('Y') NOT NULL,
    wall_visible char(1) DEFAULT ('Y') NOT NULL,
    admin_visible char(1) DEFAULT ('Y') NOT NULL,
    privacy_visible char(1) DEFAULT ('Y') NOT NULL,
    CONSTRAINT appointment_widget_cfg_pk PRIMARY KEY (appointment_id)
);

CREATE TABLE appointment (
    id number(8) NOT NULL,
    appointment_name varchar2(255 CHAR) NOT NULL,
    network_id number(8) NOT NULL,
    start_at timestamp NOT NULL,
    end_at timestamp NOT NULL,
    closing_date timestamp,
    timezone varchar2(100 CHAR) NOT NULL,
    participant_limited char(1) NOT NULL,
    participant_count integer,
    description clob NOT NULL,
    recent_news clob,
    location varchar2(255 CHAR),
    office varchar2(255 CHAR),
    contact_name varchar2(255 CHAR),
    website varchar2(255 CHAR),
    email varchar2(255 CHAR),
    phone varchar2(50 CHAR),
    fax varchar2(50 CHAR),
    street varchar2(255 CHAR),
    zipcode varchar2(10 CHAR),
    city varchar2(255 CHAR),
    state varchar2(255 CHAR),
    country_id number(8),
    keywords varchar2(255 CHAR),
    visible_for integer DEFAULT 0 NOT NULL,
    joining_rule integer DEFAULT 0 NOT NULL,
    inviting_rule integer DEFAULT 0 NOT NULL,
    CONSTRAINT appointment_pk PRIMARY KEY (id)
);

CREATE TABLE base_property (
    id number(8) NOT NULL,
    property_name varchar2(255 CHAR) NOT NULL,
    converter_class varchar2(255 CHAR),
    converter_config varchar2(255 CHAR),
    description varchar2(1000 CHAR) NOT NULL,
    default_value clob,
    inheritance_type varchar2(255 CHAR) NOT NULL,
    container_name varchar2(255 CHAR) NOT NULL,
    last_changed timestamp NOT NULL,
    change_user varchar2(255 CHAR),
    create_at timestamp DEFAULT systimestamp,
    CONSTRAINT base_property_pk PRIMARY KEY (id),
    CONSTRAINT base_property_name_containe_uk UNIQUE (property_name, container_name)
);

CREATE TABLE city (
    id number(8) NOT NULL,
    name varchar2(255 CHAR),
    region_id number(8) NOT NULL,
    CONSTRAINT citiy_pk PRIMARY KEY (id)
);

CREATE TABLE contact_data_basic (
    person_id number(8) NOT NULL,
    type smallint DEFAULT 0 NOT NULL,
    co varchar2(130 CHAR),
    street varchar2(255 CHAR),
    zipcode varchar2(10 CHAR),
    zipcode_successive char(1) DEFAULT ('N'),
    city varchar2(255 CHAR),
    country_id number(8),
    email varchar2(100 CHAR),
    phone varchar2(100 CHAR),
    fax varchar2(100 CHAR),
    mobile varchar2(100 CHAR),
    website varchar2(255 CHAR),
    created_at timestamp DEFAULT systimestamp,
    modified_at timestamp,
    CONSTRAINT contact_data_basic_pk PRIMARY KEY (type, person_id)
);

CREATE INDEX idx_contact_dat_bas__person ON contact_data_basic (person_id);

CREATE TABLE country (
    id number(8) NOT NULL,
    name varchar2(255 CHAR),
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT country_pk PRIMARY KEY (id)
);

CREATE TABLE customer_domain (
    customer_domain_name varchar2(255 CHAR) NOT NULL,
    CONSTRAINT customer_domain_pk PRIMARY KEY (customer_domain_name)
);

CREATE TABLE default_album (
    item_id number(8) NOT NULL,
    item_type varchar2(32 CHAR) NOT NULL,
    album_id number(8) NOT NULL,
    CONSTRAINT default_album_item_type_uk UNIQUE (item_id, item_type)
);

CREATE TABLE document_file (
    id number(8) NOT NULL,
    description varchar2(1024 CHAR),
    keywords clob,
    download_count number(8) DEFAULT 0 NOT NULL,
    checked_out_by number(8) DEFAULT (-1),
    checked_out_at timestamp,
    status integer DEFAULT 0 NOT NULL,
    status_changed_by number(8) DEFAULT (-1),
    status_changed_at timestamp,
    CONSTRAINT document_file_pk PRIMARY KEY (id),
    CONSTRAINT document_file_pos_dl_count CHECK ((download_count >= 0))
);

CREATE TABLE document_version (
    id number(8) NOT NULL,
    version integer DEFAULT 0 NOT NULL,
    filename varchar2(256 CHAR) NOT NULL,
    document_file_id number(8) NOT NULL,
    url varchar2(1024 CHAR) NOT NULL,
    uploaded_by number(8) DEFAULT (-1) NOT NULL,
    uploaded_at timestamp DEFAULT systimestamp NOT NULL,
    "size" number(8) NOT NULL,
    file_type_id number(8) NOT NULL,
    restored_from integer,
    CONSTRAINT document_version_pk PRIMARY KEY (id),
    CONSTRAINT document_version_file_versi_uk UNIQUE (version, document_file_id),
    CONSTRAINT document_version_pos_size CHECK (("size" > 0))
);

CREATE TABLE domain_property (
    id number(8) NOT NULL,
    base_property number(8) NOT NULL,
    "domain" varchar2(255 CHAR) NOT NULL,
    overridden_value clob,
    last_changed timestamp,
    change_user varchar2(255 CHAR),
    create_at timestamp DEFAULT systimestamp,
    CONSTRAINT domain_property_pk PRIMARY KEY (id),
    CONSTRAINT domain_property_prop_domain_uk UNIQUE (base_property, "domain")
);

CREATE TABLE dynamic_person_attribute (
    person_id number(8) NOT NULL,
    orderidx integer,
    tab varchar2(255 CHAR),
    section varchar2(255 CHAR),
    name varchar2(255 CHAR),
    value clob,
    section_clone integer
);

CREATE INDEX idx_dynamic_per_att__person ON dynamic_person_attribute (person_id);

CREATE TABLE email_notification_setting (
    person_id number(8) NOT NULL,
    subscribe_root_items char(1) DEFAULT ('Y') NOT NULL,
    subscribe_other_items char(1) DEFAULT ('Y') NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT email_notification_setting_pk PRIMARY KEY (person_id)
);

CREATE TABLE email_notification (
    person_id numeric(10,0) NOT NULL,
    CONSTRAINT email_notification_pk PRIMARY KEY (person_id)
);

CREATE TABLE email_user (
    user_id varchar2(128 CHAR) NOT NULL,
    "domain" varchar2(128 CHAR) NOT NULL,
    password varchar2(64 CHAR) NOT NULL,
    person_id number(8) NOT NULL,
    password_encrypted varchar2(64 CHAR) NOT NULL,
    created_at timestamp DEFAULT systimestamp,
    modified_at timestamp,
    CONSTRAINT email_user_person_uk UNIQUE (person_id),
    CONSTRAINT email_user_user_domain_uk UNIQUE (user_id, "domain")
);

CREATE INDEX idx_email_use__user_domain ON email_user (lower(user_id), lower("domain"));

CREATE TABLE employment (
    id numeric(10,0) NOT NULL,
    employer clob NOT NULL,
    "position" varchar2(50 CHAR),
    city varchar2(50 CHAR),
    start_at date NOT NULL,
    end_at date,
    person_id numeric(10,0) NOT NULL,
    website varchar2(256 CHAR),
    industry_id smallint,
    occupation_id smallint,
    job_status_id smallint,
    activities varchar2(1024 CHAR),
    "current" char(1),
    created_at timestamp DEFAULT systimestamp,
    modified_at timestamp,
    CONSTRAINT employment_pk PRIMARY KEY (id, person_id)
);

CREATE SEQUENCE entity_seq
    START WITH 1
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE entity (
    id number(8) NOT NULL,
    entity_type number(8) NOT NULL,
    name varchar2(255 CHAR) NOT NULL,
    start_at timestamp,
    end_at timestamp,
    closing_date timestamp,
    timezone varchar2(255 CHAR),
    participant_limited char(1) DEFAULT ('N') NOT NULL,
    participant_count integer,
    description clob,
    location varchar2(255 CHAR),
    tags clob,
    subdomain varchar2(255 CHAR),
    subdomain_deactivated char(1) DEFAULT ('N') NOT NULL,
    external_domain varchar2(255 CHAR),
    google_maps_api_key varchar2(255 CHAR),
    logo varchar2(255 CHAR),
    icon varchar2(255 CHAR),
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    widgets_show_sub_entities char(1) DEFAULT ('Y') NOT NULL,
    network_id number(8),
    group_id number(8),
    wiki_id number(8),
    appointment_id number(8),
    aggregate_workstream char(1) DEFAULT ('Y') NOT NULL,
    category varchar2(32 CHAR) DEFAULT ('$EMPTY$'),
    text_if_not_visible clob,
    public_visible char(1) DEFAULT ('Y') NOT NULL,
    stream_workstream_to_parents char(1) DEFAULT ('Y') NOT NULL,
    CONSTRAINT entity_pk PRIMARY KEY (id),
    CONSTRAINT entity_subdomain_uk UNIQUE (subdomain),
    CONSTRAINT entity_external_domain_uk UNIQUE (external_domain)
);

CREATE INDEX idx_entity__appointment ON entity (appointment_id);
CREATE INDEX idx_entity__entity_type ON entity (entity_type);
CREATE INDEX idx_entity__group ON entity (group_id);
CREATE INDEX idx_entity__name_entity_type ON entity (name, entity_type);
CREATE INDEX idx_entity__network ON entity (network_id);
CREATE INDEX idx_entity__wiki ON entity (wiki_id);


CREATE TABLE entity_category (
    entity_type number(8) NOT NULL,
    category varchar2(32 CHAR) NOT NULL,
    "order" integer NOT NULL,
    CONSTRAINT entity_category_pk PRIMARY KEY (entity_type, category)
);

CREATE TABLE entity_component (
    entity_id number(8) NOT NULL,
    component_type varchar2(32 CHAR) NOT NULL,
    "position" number(8) NOT NULL,
    "order" integer NOT NULL,
    visible char(1) DEFAULT ('Y') NOT NULL,
    "open" char(1) DEFAULT ('Y') NOT NULL,
    customized_title clob,
    CONSTRAINT entity_component_pk PRIMARY KEY (entity_id, component_type)
);

CREATE INDEX idx_entity_com__entity ON entity_component (entity_id);

CREATE TABLE entity_component_open_for (
    entity_id number(8) NOT NULL,
    component_type varchar2(100 CHAR) NOT NULL,
    authority_name varchar2(50 CHAR) NOT NULL,
    CONSTRAINT entity_component_open_for_pk PRIMARY KEY (entity_id, component_type, authority_name)
);

CREATE TABLE entity_contact_data (
    entity_id number(8) NOT NULL,
    office varchar2(255 CHAR),
    contact_name varchar2(255 CHAR),
    website varchar2(255 CHAR),
    email varchar2(255 CHAR),
    phone varchar2(100 CHAR),
    fax varchar2(100 CHAR),
    street varchar2(255 CHAR),
    zipcode varchar2(50 CHAR),
    city varchar2(255 CHAR),
    state varchar2(255 CHAR),
    country_id number(8),
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    lat double precision,
    lng double precision,
    not_resolvable char(1) DEFAULT ('N'),
    CONSTRAINT entity_contact_data_pk PRIMARY KEY (entity_id)
);

CREATE TABLE entity_design (
    entity_id number(8) NOT NULL,
    page_border_color char(7),
    nav_bg_color char(7),
    nav_quicklink_color char(7),
    nav_separator_bg_color char(7),
    nav_separator_txt_color char(7),
    header_bg_color char(7),
    header_border_color char(7),
    header_text_color char(7),
    header_link_color char(7),
    heading_box_bg_color char(7),
    heading_box_text_color char(7),
    heading_box_border_color char(7),
    subheading_box_bg_color char(7),
    subheading_box_text_color char(7),
    subheading_box_link_color char(7),
    subheading_box_border_color char(7),
    subheading_box_line_color char(7),
    inner_bg_color char(7),
    outer_bg_color char(7),
    text_color char(7),
    link_color char(7),
    line_color char(7),
    button_bg_color char(7),
    button_text_color char(7),
    box_top_border char(1),
    box_bottom_border char(1),
    box_left_border char(1),
    box_right_border char(1),
    horizontal_nav_bg_color char(7),
    horizontal_nav_link_color char(7),
    horizontal_nav varchar2(255 CHAR),
    nav_separator varchar2(255 CHAR),
    heading_box varchar2(255 CHAR),
    banner varchar2(255 CHAR),
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    bg_horizontal_repeat char(1) DEFAULT ('N') NOT NULL,
    bg_vertical_repeat char(1) DEFAULT ('N') NOT NULL,
    bg_image varchar2(255 CHAR),
    bg_scroll_fix char(1) DEFAULT ('N') NOT NULL,
    horizontal_nav_selected_link char(7),
    horizontal_nav_selected_bg char(7),
    horizontal_nav_sub_line char(7),
    horizontal_nav_selected_image varchar2(255 CHAR),
    CONSTRAINT entity_design_pk PRIMARY KEY (entity_id)
);

CREATE TABLE entity_link (
    entity_id number(8) NOT NULL,
    linked_entity_id number(8) NOT NULL,
    "order" integer NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT entity_link_pk PRIMARY KEY (entity_id, linked_entity_id)
);

CREATE TABLE entity_to_entity_type_privacy (
    entity_id number(8) NOT NULL,
    entity_type varchar2(100 CHAR) NOT NULL,
    authority_name varchar2(50 CHAR) NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT entity_to_entity_type_priva_pk PRIMARY KEY (entity_id, entity_type, authority_name)
);

CREATE TABLE entity_member (
    person_id number(8) NOT NULL,
    entity_id number(8) NOT NULL,
    member_status integer,
    member_role integer DEFAULT 0 NOT NULL,
    status_modify_date timestamp DEFAULT systimestamp NOT NULL,
    last_notify_status integer,
    last_notify_date timestamp,
    inviter_id number(8) DEFAULT (-1),
    invite_message clob,
    modify_date timestamp DEFAULT systimestamp NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT entity_member_pk PRIMARY KEY (person_id, entity_id)
);

CREATE INDEX idx_entity_mem__entity ON entity_member (entity_id);
CREATE INDEX idx_entity_mem__l_n_date ON entity_member (last_notify_date);
CREATE INDEX idx_entity_mem__l_n_status ON entity_member (last_notify_status);
CREATE INDEX idx_entity_mem__member_role ON entity_member (member_role);
CREATE INDEX idx_entity_mem__member_status ON entity_member (member_status);
CREATE INDEX idx_entity_mem__person ON entity_member (person_id);
CREATE INDEX idx_entity_mem__st_modify_date ON entity_member (status_modify_date);

CREATE SEQUENCE entity_nav_link_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE entity_nav_link (
    id number(8) NOT NULL,
    entity_id number(8) NOT NULL,
    text varchar2(63 CHAR) DEFAULT ('$EMPTY$'),
    target varchar2(255 CHAR) DEFAULT ('$EMPTY$'),
    list_index integer NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT entity_nav_link_pk PRIMARY KEY (id),
    CONSTRAINT entity_nav_link_index_uq UNIQUE (entity_id, list_index)
);

CREATE TABLE entity_nav_sublink (
    id number(8) NOT NULL,
    parent_id number(8) NOT NULL,
    text varchar2(63 CHAR) DEFAULT ('$EMPTY$'),
    target varchar2(255 CHAR) DEFAULT ('$EMPTY$'),
    list_index integer NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    edit_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT entity_nav_sublink_pk PRIMARY KEY (id)
);

CREATE TABLE entity_option (
    entity_id number(8) NOT NULL,
    option_name varchar2(100 CHAR) NOT NULL,
    option_value varchar2(100 CHAR) NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT entity_option_pk PRIMARY KEY (entity_id, option_name)
);

CREATE TABLE entity_privacy (
    entity_id number(8) NOT NULL,
    privacy_type varchar2(50 CHAR) NOT NULL,
    authority_name varchar2(50 CHAR) NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp
);

CREATE TABLE entity_type (
    id number(8) NOT NULL,
    subdomain char(1) NOT NULL,
    external_domain char(1) NOT NULL,
    design char(1) NOT NULL,
    duration_time char(1) NOT NULL,
    participant_limit char(1) NOT NULL,
    closing_date char(1) NOT NULL,
    freetext_location char(1) NOT NULL,
    horizontal_nav char(1) NOT NULL,
    linked_entity char(1) NOT NULL,
    visible_for_all char(1) NOT NULL,
    joining_for_all char(1) NOT NULL,
    sitemap char(1) NOT NULL,
    notify_member_on_loc_change char(1) NOT NULL,
    notify_member_on_dur_change char(1) NOT NULL,
    notfiy_member_on_delete char(1) NOT NULL,
    logo char(1) NOT NULL,
    icon char(1) NOT NULL,
    delete_by_admin char(1) NOT NULL,
    creating_allowed char(1) NOT NULL,
    join_request_allowed char(1) NOT NULL,
    entity_type char(1) NOT NULL,
    entity_left_nav_order integer NOT NULL,
    display_on_left_nav char(1) NOT NULL,
    display_as_list_on_left_nav char(1) NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    display_child_popup_on_entity char(1) NOT NULL,
    category_force char(1) DEFAULT ('N') NOT NULL,
    default_visible_for number(8) DEFAULT 1 NOT NULL,
    default_joining_rule number(8) DEFAULT 1 NOT NULL,
    default_inviting_rule number(8) DEFAULT 0 NOT NULL,
    option_aggregate_workstream char(1) DEFAULT ('Y') NOT NULL,
    default_aggregate_workstream char(1) DEFAULT ('Y') NOT NULL,
    option_subentities_in_widgets char(1) DEFAULT ('Y') NOT NULL,
    default_subentities_in_widgets char(1) DEFAULT ('Y') NOT NULL,
    toolbar_infowidget varchar2(2048 CHAR) DEFAULT '[["Templates","Maximize","-","Cut","Copy","Paste","PasteText","PasteFromWord","Image","Table","HorizontalRule","Source"],["Undo","Redo","Bold","Italic","Underline","Strike","-","NumberedList","BulletedList","Outdent","Indent","-","JustifyLeft","JustifyCenter","JustifyRight","JustifyBlock"],["Format","FontSize","TextColor","BGColor","RemoveFormat","-","Link","Unlink","Anchor"]]' NOT NULL,
    toolbar_newsblog varchar2(2048 CHAR) DEFAULT '[["Templates","Maximize","-","Cut","Copy","Paste","PasteText","PasteFromWord","Image","Table","HorizontalRule","Source"],["Undo","Redo","Bold","Italic","Underline","Strike","-","NumberedList","BulletedList","Outdent","Indent","-","JustifyLeft","JustifyCenter","JustifyRight","JustifyBlock"],["Format","FontSize","TextColor","BGColor","RemoveFormat","-","Link","Unlink","Anchor"]]' NOT NULL,
    toolbar_raweditor varchar2(2048 CHAR) DEFAULT '[["Templates","Maximize","-","Cut","Copy","Paste","PasteText","PasteFromWord","Image","Table","HorizontalRule","Source"],["Undo","Redo","Bold","Italic","Underline","Strike","-","NumberedList","BulletedList","Outdent","Indent","-","JustifyLeft","JustifyCenter","JustifyRight","JustifyBlock"],["Format","FontSize","TextColor","BGColor","RemoveFormat","-","Link","Unlink","Anchor"]]' NOT NULL,
    toolbar_wiki varchar2(2048 CHAR) DEFAULT '[["Templates","Maximize","-","Cut","Copy","Paste","PasteText","PasteFromWord","Image","Table","HorizontalRule","Source"],["Undo","Redo","Bold","Italic","Underline","Strike","-","NumberedList","BulletedList","Outdent","Indent","-","JustifyLeft","JustifyCenter","JustifyRight","JustifyBlock"],["Format","FontSize","TextColor","BGColor","RemoveFormat","-","Link","Unlink","Anchor"]]' NOT NULL,
    join_options_configurable char(1) DEFAULT ('Y'),
    invite_options_configurable char(1) DEFAULT ('Y'),
    leave_allowed char(1) DEFAULT ('Y'),
    invite_by_superadmin_only char(1) DEFAULT ('N'),
    join_by_invitation_only char(1) DEFAULT ('N'),
    default_newsletter_rule integer DEFAULT 0 NOT NULL,
    teaser_left varchar2(100 CHAR) DEFAULT 'ICON_WITH_TEASER_TEXT' NOT NULL,
    teaser_center varchar2(100 CHAR) DEFAULT 'ICON_WITH_TEASER_TEXT' NOT NULL,
    teaser_right varchar2(100 CHAR) DEFAULT 'ICON_WITH_ENTITY_NAME' NOT NULL,
    description_in_search_badge char(1) DEFAULT ('N') NOT NULL,
    CONSTRAINT entity_type_pk PRIMARY KEY (id)
);

CREATE TABLE entity_type_allowed_component (
    entity_type_id number(8) NOT NULL,
    component_type varchar2(100 CHAR) NOT NULL,
    "position" number(8) NOT NULL,
    default_order integer NOT NULL,
    default_visible char(1) NOT NULL,
    default_open char(1) NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT entity_type_allowed_compone_pk PRIMARY KEY (entity_type_id, component_type)
);

CREATE INDEX idx_entity_typ_all_com__e_type ON entity_type_allowed_component (entity_type_id);

CREATE TABLE entity_type_linked_entity_type (
    entity_type_id number(8) NOT NULL,
    linked_entity_type_id number(8) NOT NULL,
    min_count integer NOT NULL,
    max_count integer,
    display_as_listbox char(1) NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    default_privacy_status number(8) DEFAULT 0 NOT NULL,
    CONSTRAINT entity_type_linked_entity_t_pk PRIMARY KEY (entity_type_id, linked_entity_type_id)
);

CREATE INDEX idx_entity_ty_li_en_ty__en_ty ON entity_type_linked_entity_type (entity_type_id);

CREATE TABLE external_invitation (
    inviter_id numeric(10,0) NOT NULL,
    email varchar2(100 CHAR) NOT NULL,
    hash varchar2(100 CHAR) NOT NULL,
    entity_id number(8),
    CONSTRAINT external_invitation_pk PRIMARY KEY (hash),
    CONSTRAINT external_invitation_email_uk UNIQUE (email, entity_id)
);

CREATE INDEX idx_external_inv__entity ON external_invitation (entity_id);

CREATE TABLE facebook_user (
    id varchar2(4000 CHAR) NOT NULL,
    person_id number(8) NOT NULL,
    CONSTRAINT facebook_user_pk PRIMARY KEY (id),
    CONSTRAINT facebook_user_person_id_uk UNIQUE (person_id)
);

CREATE TABLE file_type (
    id number(8) NOT NULL,
    extension varchar2(32 CHAR),
    mime_type varchar2(64 CHAR) DEFAULT 'application/octet-stream' NOT NULL,
    description varchar2(1024 CHAR) NOT NULL,
    icon_url varchar2(1024 CHAR) NOT NULL,
    CONSTRAINT file_type_pk PRIMARY KEY (id),
    CONSTRAINT file_type_extension_uk UNIQUE (extension)
);

CREATE TABLE forum (
    forum_id number(8) NOT NULL,
    affiliation integer NOT NULL,
    id number(8) NOT NULL,
    description clob NOT NULL,
    CONSTRAINT forum_pk PRIMARY KEY (forum_id),
    CONSTRAINT forum_id_affiliation_uk UNIQUE (id, affiliation)
);

CREATE INDEX idx_forum__affiliation ON forum (affiliation);

CREATE TABLE forum_topic (
    id number(8) NOT NULL,
    forum_id number(8) NOT NULL,
    caption varchar2(255 CHAR) NOT NULL,
    "date" timestamp DEFAULT systimestamp,
    create_date timestamp DEFAULT systimestamp,
    author_id number(8) NOT NULL,
    last_replier_id number(8) NOT NULL,
    hits number(8),
    CONSTRAINT forum_topic_pk PRIMARY KEY (id)
);

CREATE INDEX idx_forum_topic_forum_id ON forum_topic (forum_id);

CREATE TABLE forum_topic_article (
    topic_id number(8) NOT NULL,
    caption varchar2(255 CHAR) NOT NULL,
    "date" timestamp DEFAULT systimestamp,
    author_id number(8) NOT NULL,
    article_text clob NOT NULL,
    id number(8) NOT NULL,
    editor_id number(8),
    edit_date timestamp,
    edit_reason varchar2(50 CHAR),
    CONSTRAINT forum_topic_article_pk PRIMARY KEY (id)
);

CREATE TABLE google_language_cache (
    source_hash number(8) NOT NULL,
    source_language varchar2(8 CHAR) NOT NULL,
    target_text clob NOT NULL,
    target_language varchar2(8 CHAR) NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT google_language_cache_pk PRIMARY KEY (source_hash, source_language, target_language)
);

CREATE TABLE greeting (
    sender_id numeric(10,0) NOT NULL,
    recipient_id numeric(10,0) NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT greeting_pk PRIMARY KEY (sender_id, recipient_id)
);

CREATE INDEX idx_greeting__recipient ON greeting (recipient_id);

CREATE TABLE group_table (
    id number(8) NOT NULL,
    group_name varchar2(255 CHAR) NOT NULL,
    network_id number(8) NOT NULL,
    description clob NOT NULL,
    recent_news clob,
    office varchar2(255 CHAR),
    website varchar2(255 CHAR),
    email varchar2(255 CHAR),
    contact_name varchar2(255 CHAR),
    street varchar2(255 CHAR),
    zipcode varchar2(10 CHAR),
    city varchar2(255 CHAR),
    state varchar2(255 CHAR),
    country_id number(8),
    closed char(1),
    image varchar2(255 CHAR),
    group_owner_person_id number(8) NOT NULL,
    keywords varchar2(255 CHAR),
    activated char(1) DEFAULT ('Y') NOT NULL,
    member_may_post_image char(1) DEFAULT ('Y') NOT NULL,
    member_may_post_video char(1) DEFAULT ('Y') NOT NULL,
    member_may_post_document char(1) DEFAULT ('Y') NOT NULL,
    invitable_for integer DEFAULT 5 NOT NULL,
    CONSTRAINT group_table_pk PRIMARY KEY (id)
);

CREATE INDEX idx_group_tab__country ON group_table (country_id);
CREATE INDEX idx_group_tab__network ON group_table (network_id);


CREATE TABLE group_member (
    group_id number(8) NOT NULL,
    person_id number(8) NOT NULL,
    status integer DEFAULT 0 NOT NULL,
    member_date timestamp with time zone DEFAULT systimestamp NOT NULL,
    inviter_id number(8),
    CONSTRAINT group_member_pk PRIMARY KEY (person_id, group_id)
);

CREATE INDEX idx_group_mem__status ON group_member (status);

CREATE TABLE ignore_list (
    person_id numeric(10,0) NOT NULL,
    ignored_id numeric(10,0) NOT NULL,
    CONSTRAINT ignorelist_pk PRIMARY KEY (person_id, ignored_id)
);

CREATE TABLE image (
    id number(8) NOT NULL,
    title varchar2(255 CHAR) NOT NULL,
    album_id number(8) NOT NULL,
    filename varchar2(255 CHAR) NOT NULL,
    owner_id number(8) NOT NULL,
    "order" integer NOT NULL,
    "date" timestamp DEFAULT systimestamp,
    CONSTRAINT image_pk PRIMARY KEY (id),
    CONSTRAINT image_album_order_uk UNIQUE (album_id, "order")
);

CREATE INDEX idx_image__order ON image ("order");

CREATE TABLE image_comment (
    id number(8) NOT NULL,
    "comment" clob NOT NULL,
    person_id number(8) NOT NULL,
    image_id number(8) NOT NULL,
    create_date timestamp with time zone DEFAULT systimestamp NOT NULL,
    CONSTRAINT image_comment_pk PRIMARY KEY (id)
);

CREATE TABLE image_person_link (
    person_id number(8) NOT NULL,
    image_id number(8) NOT NULL,
    CONSTRAINT image_person_link_pk PRIMARY KEY (person_id, image_id)
);

CREATE TABLE industry (
    id integer NOT NULL,
    language varchar2(5 CHAR) NOT NULL,
    name varchar2(100 CHAR),
    CONSTRAINT industry_pk PRIMARY KEY (id, language)
);

CREATE TABLE jabber_synced (
    person_id number(8) NOT NULL,
    in_progress char(1) NOT NULL,
    CONSTRAINT jabber_synced_pk PRIMARY KEY (person_id)
);

CREATE INDEX idx_jabber_syn__in_progress ON jabber_synced (in_progress);

CREATE TABLE jabber_temp_password (
    person_id number(8) NOT NULL,
    type varchar2(4000 CHAR) NOT NULL,
    password varchar2(4000 CHAR) NOT NULL,
    valid_until timestamp NOT NULL,
    CONSTRAINT jabber_temp_password_uk UNIQUE (person_id, type)
);

CREATE TABLE job_status (
    id integer NOT NULL,
    language varchar2(5 CHAR) NOT NULL,
    name varchar2(100 CHAR),
    CONSTRAINT job_status_pk PRIMARY KEY (id, language)
);

CREATE TABLE kadget (
    id number(8) NOT NULL,
    owner_id number(8) NOT NULL,
    name varchar2(50 CHAR) NOT NULL,
    description varchar2(512 CHAR) NOT NULL,
    url varchar2(128 CHAR) NOT NULL,
    published char(1) DEFAULT ('N') NOT NULL,
    external char(1) DEFAULT ('N'),
    CONSTRAINT kadget_pk PRIMARY KEY (id)
);

CREATE TABLE language (
    id char(2) NOT NULL,
    name varchar2(50 CHAR),
    translated char(1) DEFAULT ('N'),
    CONSTRAINT language_pk PRIMARY KEY (id)
);

CREATE TABLE like_table (
    liker_id number(8) NOT NULL,
    item_id number(8) NOT NULL,
    item_type varchar2(4000 CHAR) NOT NULL,
    created_at timestamp DEFAULT systimestamp,
    modified_at timestamp DEFAULT systimestamp,
    recent char(1) DEFAULT ('N') NOT NULL,
    CONSTRAINT like_table_pk PRIMARY KEY (item_id, item_type, liker_id)
);

CREATE INDEX idx_like_tab__it_id_it_ty_cr_a ON like_table (item_id, item_type, created_at);
CREATE INDEX idx_like_tab__liker ON like_table (liker_id);
CREATE INDEX idx_like_tab__it_id_it_ty_rec ON like_table (item_id, item_type, recent);

CREATE TABLE like_queue (
    item_id number(8) NOT NULL,
    item_type varchar2(32 CHAR) NOT NULL,
    in_progress char(1) DEFAULT ('N') NOT NULL,
    created_at timestamp DEFAULT systimestamp,
    modified_at timestamp DEFAULT systimestamp,
    parent_type varchar2(4000 CHAR),
    parent_id number(8),
    CONSTRAINT like_queue_pk PRIMARY KEY (item_id, item_type)
);

CREATE TABLE like_subscribe (
    subscriber_id number(8) NOT NULL,
    item_id number(8) NOT NULL,
    item_type varchar2(4000 CHAR) NOT NULL,
    created_at timestamp DEFAULT systimestamp,
    modified_at timestamp DEFAULT systimestamp,
    CONSTRAINT like_subscribe_pk PRIMARY KEY (item_id, item_type, subscriber_id)
);

CREATE INDEX idx_like_sub__subscriber ON like_subscribe (subscriber_id);

CREATE TABLE like_unsubscribe (
    unsubscriber_id number(8) NOT NULL,
    item_id number(8) NOT NULL,
    item_type varchar2(4000 CHAR) NOT NULL,
    created_at timestamp DEFAULT systimestamp,
    modified_at timestamp DEFAULT systimestamp,
    CONSTRAINT like_unsubscribe_pk PRIMARY KEY (item_id, item_type, unsubscriber_id)
);

CREATE TABLE map_document_file_appointment (
    id number(8) NOT NULL,
    document_file_id number(8) NOT NULL,
    appointment_id number(8) NOT NULL,
    CONSTRAINT map_document_file_appointme_pk PRIMARY KEY (id)
);

CREATE INDEX idx_map_doc_fil_app__doc_file ON map_document_file_appointment (document_file_id);
CREATE INDEX idx_map_doc_fil_app__appointmt ON map_document_file_appointment (appointment_id);

CREATE TABLE map_document_file_group (
    id number(8) NOT NULL,
    document_file_id number(8) NOT NULL,
    group_id number(8) NOT NULL,
    CONSTRAINT map_document_file_group_pk PRIMARY KEY (id)
);

CREATE INDEX idx_map_doc_fil_gro__doc_file ON map_document_file_group (document_file_id);
CREATE INDEX idx_map_doc_fil_gro__group_id ON map_document_file_group (group_id);


CREATE TABLE map_document_file_network (
    id number(8) NOT NULL,
    document_file_id number(8) NOT NULL,
    network_id number(8) NOT NULL,
    CONSTRAINT map_document_file_network_pk PRIMARY KEY (id)
);

CREATE INDEX idx_map_doc_fil_net__doc_file ON map_document_file_network (document_file_id);
CREATE INDEX idx_map_doc_fil_net__network ON map_document_file_network (network_id);

CREATE TABLE map_document_file_wiki_group (
    id number(8) NOT NULL,
    document_file_id number(8) NOT NULL,
    wiki_group_id number(8) NOT NULL,
    CONSTRAINT map_document_file_wiki_grou_pk PRIMARY KEY (id)
);

CREATE INDEX idx_map_doc_fil_wik_gro__d_fil ON map_document_file_wiki_group (document_file_id);
CREATE INDEX idx_map_doc_fil_wik_gro__wiki ON map_document_file_wiki_group (wiki_group_id);

CREATE TABLE map_kadget_network (
    id number(8) NOT NULL,
    kadget_id number(8) NOT NULL,
    network_id number(8) NOT NULL,
    "position" integer NOT NULL,
    CONSTRAINT map_kadget_network_pk PRIMARY KEY (id),
    CONSTRAINT map_kadget_network_ka_ne_po_uk UNIQUE (kadget_id, network_id, "position")
);

CREATE TABLE map_network_city (
    network_id number(8) NOT NULL,
    city_id number(8) NOT NULL,
    CONSTRAINT map_network_city_pk PRIMARY KEY (network_id, city_id)
);

CREATE TABLE map_person_network (
    person_id numeric(10,0) NOT NULL,
    network_id number(8) NOT NULL,
    join_date timestamp DEFAULT systimestamp NOT NULL,
    status integer DEFAULT 0 NOT NULL,
    inviter_id number(8) NOT NULL,
    CONSTRAINT map_person_network_pk PRIMARY KEY (network_id, person_id)
);

CREATE INDEX idx_map_per_net__join_date ON map_person_network (join_date);
CREATE INDEX idx_map_per_net__network ON map_person_network (network_id);

CREATE TABLE map_person_person (
    person_id numeric(10,0) NOT NULL,
    friend_id numeric(10,0) NOT NULL,
    CONSTRAINT map_person_person_pk PRIMARY KEY (person_id, friend_id)
);

CREATE TABLE map_person_person_invite (
    person_id numeric(10,0) NOT NULL,
    friend_id numeric(10,0) NOT NULL,
    message clob,
    CONSTRAINT map_person_person_invite_pk PRIMARY KEY (person_id, friend_id)
);

CREATE TABLE map_person_relationship_type (
    person_id numeric(10,0) NOT NULL,
    relationshiptype_id numeric(2,0) NOT NULL,
    CONSTRAINT map_person_relationshiptype_pk PRIMARY KEY (person_id, relationshiptype_id)
);

CREATE TABLE map_url_network (
    url varchar2(50 CHAR) NOT NULL,
    network_id number(8) NOT NULL,
    "current" char(1) NOT NULL,
    CONSTRAINT map_url_network_pk PRIMARY KEY (url)
);

CREATE SEQUENCE mdl_album_seq
    START WITH 1
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE mdl_album (
    id number(8) NOT NULL,
    parent_item_id number(8) NOT NULL,
    parent_item_type varchar2(32 CHAR) NOT NULL,
    module char(1) DEFAULT ('Y') NOT NULL,
    owner_id number(8) DEFAULT (-1),
    create_date timestamp DEFAULT systimestamp NOT NULL,
    edit_date timestamp DEFAULT systimestamp NOT NULL,
    title varchar2(255 CHAR) NOT NULL,
    description clob  DEFAULT ('$EMPTY$'),
    location varchar2(80 CHAR) DEFAULT ('$EMPTY$'),
    friends_only char(1) DEFAULT ('Y') NOT NULL,
    old_album_id number(8),
    CONSTRAINT mdl_album_pk PRIMARY KEY (id)
);

CREATE INDEX idx_mdl_alb__pa_it_pa_it_ty_md ON mdl_album (parent_item_id, parent_item_type, module);

CREATE SEQUENCE mdl_album_image_seq
    START WITH 1
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE mdl_album_image (
    id number(8) NOT NULL,
    title varchar2(255 CHAR) NOT NULL,
    album_id number(8) NOT NULL,
    filename varchar2(255 CHAR) NOT NULL,
    owner_id number(8) DEFAULT (-1) NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    edit_date timestamp DEFAULT systimestamp NOT NULL,
    old_album_image_id number(8),
    CONSTRAINT mdl_album_image_pk PRIMARY KEY (id)
);

CREATE SEQUENCE mdl_comment_seq
    START WITH 1
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE mdl_comment (
    id number(8) NOT NULL,
    author_id number(8) DEFAULT (-1),
    text varchar2(1000 CHAR) NOT NULL,
    posted_at timestamp DEFAULT systimestamp NOT NULL,
    parent_item_id number(8) NOT NULL,
    parent_item_type varchar2(32 CHAR) NOT NULL,
    custom_info varchar2(255 CHAR),
    CONSTRAINT mdl_comment_pk PRIMARY KEY (id)
);

CREATE INDEX idx_mdl_com__pa_it_pa_it_ty ON mdl_comment (parent_item_id, parent_item_type);

CREATE SEQUENCE mdl_document_version_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE mdl_document_version (
    id number(8) NOT NULL,
    version integer DEFAULT 0 NOT NULL,
    filename varchar2(256 CHAR) NOT NULL,
    document_id number(8) NOT NULL,
    url varchar2(1024 CHAR) NOT NULL,
    uploaded_by number(8) DEFAULT (-1) NOT NULL,
    uploaded_at timestamp DEFAULT systimestamp NOT NULL,
    "size" number(8) NOT NULL,
    file_type_id number(8) NOT NULL,
    restored_from integer,
    CONSTRAINT mdl_document_version_pk PRIMARY KEY (id),
    CONSTRAINT mdl_document_version_doc_ve_uk UNIQUE (version, document_id),
    CONSTRAINT mdl_document_version_pos_size CHECK (("size" > 0))
);

CREATE INDEX idx_mdl_doc_ver__document ON mdl_document_version (document_id);

CREATE SEQUENCE mdl_document_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE mdl_document (
    id number(8) NOT NULL,
    parent_item_id number(8) NOT NULL,
    parent_item_type varchar2(32 CHAR) NOT NULL,
    description varchar2(1024 CHAR),
    keywords clob,
    download_count number(8) DEFAULT 0 NOT NULL,
    checked_out_by number(8) DEFAULT (-1),
    checked_out_at timestamp,
    status integer DEFAULT 0 NOT NULL,
    status_changed_by number(8) DEFAULT (-1),
    status_changed_at timestamp,
    CONSTRAINT mdl_doc_files_pos_dl_count CHECK ((download_count >= 0)),
    CONSTRAINT mdl_document_file_pk PRIMARY KEY (id)
);

CREATE TABLE mdl_forum_migration (
    entity_id number(8),
    old_forum_id number(8)
);

CREATE SEQUENCE mdl_forum_topic_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE mdl_forum_topic (
    id number(8) NOT NULL,
    parent_item_id number(8) NOT NULL,
    parent_item_type varchar2(32 CHAR) NOT NULL,
    caption varchar2(255 CHAR) NOT NULL,
    edit_date timestamp DEFAULT systimestamp NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    author_id number(8) DEFAULT (-1) NOT NULL,
    hits number(8) DEFAULT 0 NOT NULL,
    old_topic_id number(8),
    CONSTRAINT mdl_forum_topic_pk PRIMARY KEY (id)
);

CREATE INDEX idx_mdl_for_top__pa_it_pa_it_t ON mdl_forum_topic (parent_item_id, parent_item_type);

CREATE SEQUENCE mdl_forum_topic_article_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE mdl_forum_topic_article (
    id number(8) NOT NULL,
    topic_id number(8) NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    author_id number(8) DEFAULT (-1) NOT NULL,
    article_text clob NOT NULL,
    editor_id number(8) DEFAULT (-1),
    edit_date timestamp DEFAULT systimestamp,
    edit_reason varchar2(50 CHAR),
    CONSTRAINT mdl_forum_topic_article_pk PRIMARY KEY (id)
);

CREATE SEQUENCE mdl_video_link_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE mdl_video_link (
    id number(8) NOT NULL,
    parent_item_id number(8) NOT NULL,
    parent_item_type varchar2(32 CHAR) NOT NULL,
    title varchar2(255 CHAR) NOT NULL,
    url varchar2(255 CHAR) NOT NULL,
    edit_date timestamp DEFAULT systimestamp NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    author_id number(8) DEFAULT (-1) NOT NULL,
    "public" char(1) DEFAULT ('Y') NOT NULL,
    video_file varchar2(256 CHAR),
    CONSTRAINT mdl_videolink_pk PRIMARY KEY (id)
);

CREATE INDEX idx_mdl_vid__pa_it_pa_it_ty ON mdl_video_link (parent_item_id, parent_item_type);

CREATE SEQUENCE message_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE message (
    id numeric(10,0) NOT NULL,
    sender_id numeric(10,0) NOT NULL,
    message clob NOT NULL,
    subject varchar2(255 CHAR) NOT NULL,
    "date" timestamp DEFAULT systimestamp,
    CONSTRAINT message_pk PRIMARY KEY (id)
);

CREATE INDEX idx_message__date ON message ("date");

CREATE TABLE message_inbox (
    owner_id numeric(10,0) NOT NULL,
    message_id numeric(10,0) NOT NULL,
    message_status numeric(1,0) NOT NULL,
    CONSTRAINT message_inbox_pk PRIMARY KEY (owner_id, message_id)
);

CREATE INDEX idx_message_inb__message ON message_inbox (message_id);
CREATE INDEX idx_message_inb__owner ON message_inbox (owner_id);

CREATE TABLE message_outbox (
    owner_id numeric(10,0) NOT NULL,
    message_id numeric(10,0) NOT NULL,
    message_status numeric(1,0) NOT NULL,
    CONSTRAINT message_outbox_pk PRIMARY KEY (owner_id, message_id)
);

CREATE INDEX idx_message_out__message ON message_outbox (message_id);
CREATE INDEX idx_message_out__owner ON message_outbox (owner_id);

CREATE TABLE message_recipient (
    message_id numeric(10,0) NOT NULL,
    recipient_id numeric(10,0) NOT NULL
);

CREATE INDEX idx_message_rec__message ON message_recipient (message_id);

CREATE TABLE native (
    id number(8) NOT NULL,
    native varchar2(255 CHAR),
    CONSTRAINT native_pk PRIMARY KEY (id)
);

CREATE TABLE network (
    id number(8) NOT NULL,
    name varchar2(255 CHAR),
    type smallint,
    description varchar2(512 CHAR),
    parent_id number(8),
    url varchar2(50 CHAR),
    additional_url varchar2(255 CHAR),
    subtitle varchar2(200 CHAR),
    keywords varchar2(100 CHAR),
    language char(2),
    logo varchar2(255 CHAR),
    banner varchar2(255 CHAR),
    icon varchar2(255 CHAR),
    homepage_url varchar2(255 CHAR),
    closed char(1) NOT NULL,
    additional_url_deactivated char(1) DEFAULT ('N') NOT NULL,
    visible_for integer,
    access_for integer,
    invitable_for integer,
    google_maps_api_key varchar2(255 CHAR),
    sort_priority integer,
    redirect_to_network_id number(8),
    horizontal_nav varchar2(255 CHAR),
    nav_separator varchar2(255 CHAR),
    heading_box varchar2(255 CHAR),
    widgets_show_sub_networks char(1) DEFAULT ('N') NOT NULL,
    CONSTRAINT network_pk PRIMARY KEY (id),
    CONSTRAINT network_url_uk UNIQUE (url),
    CONSTRAINT network_additional_url_uk UNIQUE (additional_url)
);

CREATE INDEX idx_network__type ON network (type);

CREATE TABLE network_design (
    network_id number(8) NOT NULL,
    page_border_color char(7),
    nav_bg_color char(7),
    nav_quicklink_color char(7),
    nav_separator_bg_color char(7),
    nav_separator_text_color char(7),
    header_bg_color char(7),
    header_border_color char(7),
    header_text_color char(7),
    header_link_color char(7),
    heading_box_bg_color char(7),
    heading_box_txt_color char(7),
    heading_box_border_color char(7),
    subheading_box_bg_color char(7),
    subheading_box_text_color char(7),
    subheading_box_link_color char(7),
    subheading_box_border_color char(7),
    subheading_box_line_color char(7),
    inner_bg_color char(7),
    outer_bg_color char(7),
    text_color char(7),
    link_color char(7),
    border_color char(7),
    button_bg_color char(7),
    button_text_color char(7),
    box_top_border char(1),
    box_bottom_border char(1),
    box_left_border char(1),
    box_right_border char(1),
    horizontal_nav_bg_color char(7),
    horizontal_nav_link_color char(7),
    CONSTRAINT network_design_pk PRIMARY KEY (network_id)
);

CREATE TABLE network_link (
    network_id1 number(8) NOT NULL,
    network_id2 number(8) NOT NULL,
    status integer NOT NULL,
    member_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT network_link_pk PRIMARY KEY (network_id1, network_id2),
    CONSTRAINT network_link_check CHECK ((network_id1 <> network_id2))
);

CREATE TABLE network_nav_link (
    id number(8) NOT NULL,
    network_id number(8) NOT NULL,
    text varchar2(63 CHAR),
    target varchar2(255 CHAR),
    list_index integer NOT NULL,
    CONSTRAINT network_navigation_link_pk PRIMARY KEY (id),
    CONSTRAINT network_nav_link_net_idx_uk UNIQUE (network_id, list_index)
);

CREATE TABLE network_news (
    id number(8) NOT NULL,
    network_id number(8) NOT NULL,
    person_id number(8) NOT NULL,
    heading varchar2(120 CHAR) NOT NULL,
    content varchar2(4000 CHAR) NOT NULL,
    link varchar2(255 CHAR),
    posted_on timestamp with time zone DEFAULT systimestamp NOT NULL,
    CONSTRAINT network_news_pk PRIMARY KEY (id)
);

CREATE TABLE network_type (
    id smallint NOT NULL,
    name varchar2(255 CHAR),
    CONSTRAINT network_type_pk PRIMARY KEY (id)
);

CREATE TABLE network_valid_child_type (
    parent_type smallint NOT NULL,
    child_type smallint NOT NULL,
    CONSTRAINT network_valid_child_type_pk PRIMARY KEY (parent_type, child_type)
);

CREATE TABLE network_widget_cfg (
    network_id number(8) NOT NULL,
    member_images_visible char(1) DEFAULT ('Y') NOT NULL,
    feed_visible char(1) DEFAULT ('Y') NOT NULL,
    news_visible char(1) DEFAULT ('Y') NOT NULL,
    events_visible char(1) DEFAULT ('Y') NOT NULL,
    member_videolinks_visible char(1) DEFAULT ('Y') NOT NULL,
    forum_visible char(1) DEFAULT ('Y') NOT NULL,
    wall_visible char(1) DEFAULT ('Y') NOT NULL,
    members_visible char(1) DEFAULT ('Y') NOT NULL,
    groups_visible char(1) DEFAULT ('Y') NOT NULL,
    images_visible char(1) DEFAULT ('Y') NOT NULL,
    videolinks_visible char(1) DEFAULT ('Y') NOT NULL,
    details_visible char(1) DEFAULT ('Y') NOT NULL,
    news_member_writable char(1) DEFAULT ('Y') NOT NULL,
    events_member_writable char(1) DEFAULT ('Y') NOT NULL,
    images_member_writable char(1) DEFAULT ('Y') NOT NULL,
    videolinks_member_writable char(1) DEFAULT ('Y') NOT NULL,
    kadgets_visible char(1) DEFAULT ('Y') NOT NULL,
    network_links_visible char(1),
    documents_visible char(1) DEFAULT ('Y') NOT NULL,
    documents_member_writable char(1) DEFAULT ('Y') NOT NULL,
    wikis_visible char(1) DEFAULT ('Y') NOT NULL,
    wiki_tag_cloud_visible char(1) DEFAULT ('Y') NOT NULL,
    google_map_visible char(1) DEFAULT ('Y') NOT NULL,
    member_images_position integer NOT NULL,
    feed_position integer NOT NULL,
    news_position integer NOT NULL,
    events_position integer NOT NULL,
    member_videolinks_position integer NOT NULL,
    forum_position integer NOT NULL,
    wall_position integer NOT NULL,
    members_position integer NOT NULL,
    groups_position integer NOT NULL,
    images_position integer NOT NULL,
    videolinks_position integer NOT NULL,
    details_position integer NOT NULL,
    kadgets_position integer DEFAULT 8 NOT NULL,
    network_links_position integer,
    documents_position integer DEFAULT 4 NOT NULL,
    wikis_position integer NOT NULL,
    wiki_tag_cloud_position integer NOT NULL,
    google_map_position integer NOT NULL,
    CONSTRAINT network_widget_cfg_pk PRIMARY KEY (network_id)
);

CREATE SEQUENCE news_blog_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE news_blog (
    id number(8) NOT NULL,
    parent_item_id number(8) NOT NULL,
    parent_item_type varchar2(32 CHAR) NOT NULL,
    headline varchar2(255 CHAR) NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    edit_date timestamp DEFAULT systimestamp NOT NULL,
    author_id number(8) DEFAULT (-1) NOT NULL,
    source_text varchar2(255 CHAR) DEFAULT ('$EMPTY$'),
    source_href varchar2(255 CHAR) DEFAULT ('$EMPTY$'),
    keywords varchar2(255 CHAR) DEFAULT ('$EMPTY$'),
    text clob NOT NULL,
    image_id number(8),
    draft char(1) DEFAULT ('N') NOT NULL,
    CONSTRAINT newsblog_pk PRIMARY KEY (id)
);

CREATE INDEX idx_newsblog__p_it_p_it_ty_a_d ON news_blog (parent_item_id, parent_item_type, author_id, draft);
CREATE INDEX idx_newsblog__p_it_p_it_ty_d ON news_blog (parent_item_id, parent_item_type, draft);

CREATE TABLE occupation (
    id integer NOT NULL,
    language varchar2(5 CHAR) NOT NULL,
    name varchar2(100 CHAR),
    CONSTRAINT occupation_pk PRIMARY KEY (id, language)
);

CREATE TABLE open_social_app_data (
    id numeric(10,0) NOT NULL,
    key varchar2(100 CHAR) NOT NULL,
    value clob NOT NULL,
    kadget_id number(8),
    person_id number(8) NOT NULL,
    CONSTRAINT open_social_app_data_pk PRIMARY KEY (id)
);

CREATE SEQUENCE person_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE person (
    id numeric(10,0) NOT NULL,
    last_login timestamp DEFAULT systimestamp NOT NULL,
    show_tempstartpage char(1) DEFAULT ('Y') NOT NULL,
    account_active char(1),
    title varchar2(255 CHAR),
    firstname varchar2(50 CHAR) NOT NULL,
    surname varchar2(100 CHAR) NOT NULL,
    email varchar2(100 CHAR),
    newmail varchar2(100 CHAR),
    activation_hash varchar2(100 CHAR),
    birthday date,
    password_hash char(28),
    keywords varchar2(255 CHAR),
    gender smallint DEFAULT 0 NOT NULL,
    zodiac_id numeric(2,0),
    relationshipstatus_id numeric(2,0),
    politview_id numeric(2,0),
    religview_id numeric(2,0),
    home_city varchar2(255 CHAR) DEFAULT ('$EMPTY$'),
    home_country varchar2(255 CHAR) DEFAULT ('$EMPTY$'),
    language_id char(2),
    current_city varchar2(255 CHAR) DEFAULT ('$EMPTY$'),
    current_country varchar2(255 CHAR) DEFAULT ('$EMPTY$'),
    password_question varchar2(255 CHAR),
    password_answer varchar2(255 CHAR),
    registerdate timestamp DEFAULT systimestamp,
    terms_accepted char(1),
    image varchar2(64 CHAR),
    allow_newsletter char(1) DEFAULT ('Y'),
    blocked char(1) DEFAULT ('N') NOT NULL,
    show_actions_in_networks char(1) DEFAULT ('Y') NOT NULL,
    default_timezone varchar2(100 CHAR),
    modified_at timestamp,
    created_at timestamp DEFAULT systimestamp,
    birthday_visibility varchar2(64 CHAR) DEFAULT 'FULL',
    status_id smallint,
    hashed_id varchar2(32 CHAR) NOT NULL,
    additional_title varchar2(255 CHAR),
    pseudonym varchar2(255 CHAR),
    pseudonym_enabled char(1),
    visible_for_restricted char(1),
    CONSTRAINT person_pk PRIMARY KEY (id),
    CONSTRAINT person_newmail_uk UNIQUE (newmail),
    CONSTRAINT person_email_uk UNIQUE (email),
    CONSTRAINT person_hashed_id_uk UNIQUE (hashed_id),
    CONSTRAINT person_pseudonym_uk UNIQUE (pseudonym)
);

CREATE UNIQUE INDEX idx_person__email ON person (lower(email));
CREATE INDEX idx_person__pseudonym ON person (lower(pseudonym));

CREATE TABLE person_nofriends_message (
    person_id number(8) NOT NULL,
    CONSTRAINT person_nofriends_message_pk PRIMARY KEY (person_id)
);

CREATE TABLE person_primary_network (
    person_id number(8),
    network_id number(8)
);

CREATE TABLE person_role (
    role_name varchar2(15 CHAR) NOT NULL,
    default_role char(1) DEFAULT ('N') NOT NULL,
    hidden_role char(1) DEFAULT ('N') NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT person_role_pk PRIMARY KEY (role_name)
);

CREATE TABLE person_to_role (
    person_id number(8) NOT NULL,
    role_name varchar2(15 CHAR) NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT person_to_role_pk PRIMARY KEY (person_id, role_name)
);

CREATE TABLE polit_view (
    id numeric(2,0) NOT NULL,
    name varchar2(50 CHAR) NOT NULL,
    CONSTRAINT politview_pk PRIMARY KEY (id),
    CONSTRAINT politview_name_uk UNIQUE (name)
);

CREATE TABLE profile_allowed_component (
    component_type varchar2(100 CHAR) NOT NULL,
    "position" number(8) NOT NULL,
    default_order integer NOT NULL,
    default_visibility integer NOT NULL,
    may_modify_visibility char(1) NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT profile_allowed_component_pk PRIMARY KEY (component_type)
);

CREATE TABLE profile_component (
    person_id number(8) NOT NULL,
    component_type varchar2(100 CHAR) NOT NULL,
    visibility integer,
    "position" number(8) NOT NULL,
    "order" integer NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT profile_component_pk PRIMARY KEY (person_id, component_type)
);

CREATE TABLE profile_component_visibility (
    person_id number(8) NOT NULL,
    component_type varchar2(100 CHAR) NOT NULL,
    authority_name varchar2(50 CHAR) NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT profile_component_visibilit_pk PRIMARY KEY (person_id, component_type, authority_name)
);

CREATE TABLE profile_visibility_for_role (
    person_id number(8) NOT NULL,
    role_name_may_see clob NOT NULL,
    modify_date timestamp DEFAULT systimestamp
);

CREATE TABLE properties_tmp (
    property_name varchar2(255 CHAR) NOT NULL
);

CREATE TABLE queue (
    id number(8) NOT NULL,
    type varchar2(32 CHAR) NOT NULL,
    created_at timestamp NOT NULL,
    state varchar2(32 CHAR) NOT NULL,
    data clob NOT NULL,
    CONSTRAINT queue_pk PRIMARY KEY (id)
);

CREATE INDEX idx_queue__created_at ON queue (created_at);

CREATE TABLE random_member_component_cfg (
    entity_id number(8) NOT NULL,
    role_name varchar2(15 CHAR) NOT NULL,
    "order" integer NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    modify_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT random_member_component_cfg_pk PRIMARY KEY (entity_id, role_name)
);

CREATE SEQUENCE raweditor_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE SEQUENCE raweditor_version_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE raweditor_version (
    id number(8) NOT NULL,
    raweditor_id number(8) NOT NULL,
    parent_item_id number(8) NOT NULL,
    parent_item_type varchar2(32 CHAR) NOT NULL,
    editor_type varchar2(32 CHAR) NOT NULL,
    version integer NOT NULL,
    text clob NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    author_id number(8) DEFAULT (-1) NOT NULL,
    CONSTRAINT raweditor_version_pk PRIMARY KEY (id),
    CONSTRAINT raweditor_version_uk UNIQUE (parent_item_id, parent_item_type, editor_type, version),
    CONSTRAINT raweditor_version_redit_ver_uk UNIQUE (raweditor_id, version)
);

CREATE TABLE relationship_status (
    id numeric(2,0) NOT NULL,
    name varchar2(50 CHAR) NOT NULL,
    CONSTRAINT relationshipstatus_pk PRIMARY KEY (id),
    CONSTRAINT relationshipstatus_name_uk UNIQUE (name)
);

CREATE TABLE relationship_type (
    id numeric(2,0) NOT NULL,
    name varchar2(50 CHAR) NOT NULL,
    CONSTRAINT relationshiptype_pk PRIMARY KEY (id),
    CONSTRAINT relationshiptype_name_uk UNIQUE (name)
);

CREATE TABLE relig_view (
    id numeric(2,0) NOT NULL,
    name varchar2(50 CHAR) NOT NULL,
    CONSTRAINT religview_pk PRIMARY KEY (id),
    CONSTRAINT religview_name_uk UNIQUE (name)
);

CREATE TABLE rights (
    person_id numeric(10,0) NOT NULL,
    admin char(1) DEFAULT ('N') NOT NULL,
    translator char(1) DEFAULT ('Y') NOT NULL,
    CONSTRAINT rights_pk PRIMARY KEY (person_id)
);

CREATE SEQUENCE school_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE school (
    id numeric(10,0) NOT NULL,
    name varchar2(50 CHAR) NOT NULL,
    gradyear numeric(4,0) NOT NULL,
    person_id numeric(10,0) NOT NULL,
    CONSTRAINT school_pk PRIMARY KEY (id)
);

CREATE TABLE school_type (
    id numeric(2,0) NOT NULL,
    name varchar2(50 CHAR) NOT NULL,
    CONSTRAINT schooltype_pk PRIMARY KEY (id),
    CONSTRAINT schooltype_name_uk UNIQUE (name)
);

CREATE TABLE start_page_profile (
    id number(8) NOT NULL,
    person_id number(8) NOT NULL,
    language char(2),
    activated char(1) DEFAULT ('N') NOT NULL,
    image varchar2(255 CHAR),
    deleted char(1) DEFAULT ('N') NOT NULL,
    CONSTRAINT start_page_profile_pk PRIMARY KEY (id)
);

CREATE TABLE status (
    id number(8) NOT NULL,
    default_short_status_name varchar2(255 CHAR) NOT NULL,
    default_long_status_name varchar2(1024 CHAR),
    CONSTRAINT status_pk PRIMARY KEY (id)
);

CREATE TABLE status_translation (
    id number(8) NOT NULL,
    status_id smallint NOT NULL,
    language char(2) NOT NULL,
    gender smallint,
    short_status_name varchar2(255 CHAR),
    long_status_name varchar2(1024 CHAR),
    CONSTRAINT status_translation_pk PRIMARY KEY (id),
    CONSTRAINT status_translation_st_la_ge_uk UNIQUE (status_id, language, gender)
);

CREATE TABLE subscription (
    id number(8) NOT NULL,
    subscriber_id number(8) NOT NULL,
    created_at timestamp DEFAULT systimestamp,
    modified_at timestamp DEFAULT systimestamp,
    subscription_type varchar2(32 CHAR) NOT NULL,
    item_id number(8),
    item_type varchar2(32 CHAR),
    entity_id number(8) NOT NULL,
    component_type varchar2(32 CHAR),
    CONSTRAINT subscription_pk PRIMARY KEY (id),
    CONSTRAINT subscription_uk UNIQUE (subscriber_id, item_id, item_type, component_type, entity_id)
);

CREATE UNIQUE INDEX idx_subscription__en_ssc_com ON subscription (entity_id, subscriber_id, component_type);
CREATE INDEX idx_subscription__entity_comp ON subscription (entity_id, component_type);
CREATE INDEX idx_subscription__i_id_item_ty ON subscription (item_id, item_type);
CREATE INDEX idx_subscription__e_id_subscri ON subscription (entity_id, subscriber_id);
CREATE UNIQUE INDEX idx_subscription__s_id_item_id ON subscription (subscriber_id, item_id, item_type);

CREATE TABLE subscription_notification (
    id number(8) NOT NULL,
    actor_id number(8) DEFAULT (-1) NOT NULL,
    created_at timestamp DEFAULT systimestamp,
    modified_at timestamp DEFAULT systimestamp,
    subscription_type varchar2(32 CHAR) NOT NULL,
    notification_type varchar2(32 CHAR) NOT NULL,
    item_id number(8),
    item_type varchar2(32 CHAR),
    entity_id number(8) NOT NULL,
    component_type varchar2(32 CHAR),
    in_progress char(1) DEFAULT ('N') NOT NULL,
    comment_id number(8),
    CONSTRAINT subscription_notification_pk PRIMARY KEY (id)
);

CREATE INDEX idx_subscription_not__a_id_ent ON subscription_notification (actor_id, entity_id, item_id, item_type, subscription_type, component_type, in_progress, created_at);

CREATE SEQUENCE survey_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE survey (
    id number(8) NOT NULL,
    parent_item_id number(8) NOT NULL,
    parent_item_type varchar2(32 CHAR) NOT NULL,
    title varchar2(255 CHAR) NOT NULL,
    expired_date timestamp,
    owner_id number(8) DEFAULT (-1) NOT NULL,
    result_visibilty integer NOT NULL,
    anonym char(1) NOT NULL,
    participant_may_modify char(1) NOT NULL,
    auto_delete_answers char(1) NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT survey_pk PRIMARY KEY (id)
);

CREATE INDEX idx_survey__p_item_id_parent_i ON survey (parent_item_id, parent_item_type);

CREATE TABLE survey_participant_answer (
    participant_id number(8) DEFAULT (-1),
    survey_question_id number(8) NOT NULL,
    survey_predefined_answer_id number(8),
    freetext_answer clob,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp
);

CREATE SEQUENCE survey_predefined_answer_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE survey_predefined_answer (
    id number(8) NOT NULL,
    survey_question_id number(8) NOT NULL,
    answer clob NOT NULL,
    "order" integer,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT survey_predefined_answer_pk PRIMARY KEY (id)
);

CREATE SEQUENCE survey_question_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE survey_question (
    id number(8) NOT NULL,
    survey_id number(8) NOT NULL,
    question clob NOT NULL,
    "order" integer,
    freetext_answer char(1) NOT NULL,
    min_answer integer,
    max_answer integer,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT survey_question_pk PRIMARY KEY (id)
);

CREATE TABLE systemmessage (
    id numeric(10,0) NOT NULL,
    action_code varchar2(50 CHAR) NOT NULL,
    "date" timestamp DEFAULT systimestamp,
    creator_id numeric(10,0) NOT NULL,
    receiver_id numeric(10,0),
    friendsfriend_id numeric(10,0),
    group_id number(8),
    wiki_group_id number(8),
    video_post_id number(8),
    topic_id number(8),
    foto_id number(8),
    network_id number(8),
    album_id number(8),
    appointment_id number(8),
    document_version_id number(8),
    document_file_id number(8),
    CONSTRAINT systemmessage_pk PRIMARY KEY (id)
);

CREATE INDEX idx_systemmessage__action_code ON systemmessage (action_code);
CREATE INDEX idx_systemmessage__creator_id ON systemmessage (creator_id);
CREATE INDEX idx_systemmessage__friendsfrie ON systemmessage (friendsfriend_id);
CREATE INDEX idx_systemmessage__group ON systemmessage (group_id);
CREATE INDEX idx_systemmessage__receiver ON systemmessage (receiver_id);
CREATE INDEX idx_systemmessage__subact_code ON systemmessage (substr((action_code), 1, 6));

CREATE TABLE translation (
    language_id char(2) NOT NULL,
    native_id number(8) NOT NULL,
    translation varchar2(255 CHAR),
    CONSTRAINT translation_pk PRIMARY KEY (language_id, native_id)
);

CREATE SEQUENCE university_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE university (
    id numeric(10,0) NOT NULL,
    name varchar2(50 CHAR) NOT NULL,
    degree varchar2(50 CHAR) NOT NULL,
    course varchar2(50 CHAR) NOT NULL,
    gradyear numeric(4,0) NOT NULL,
    person_id numeric(10,0) NOT NULL,
    university_department_id number(8),
    CONSTRAINT university_pk PRIMARY KEY (id)
);

CREATE TABLE university_department (
    id number(8) NOT NULL,
    language varchar2(5 CHAR) NOT NULL,
    name varchar2(255 CHAR) NOT NULL,
    CONSTRAINT university_department_pk PRIMARY KEY (id, language)
);

CREATE TABLE university_type (
    id numeric(2,0) NOT NULL,
    name varchar2(50 CHAR) NOT NULL,
    CONSTRAINT university_type_pk PRIMARY KEY (id),
    CONSTRAINT university_type_name_uk UNIQUE (name)
);

CREATE SEQUENCE user_setting_seq
    START WITH 1
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE user_setting (
    id number(8) NOT NULL,
    person_id numeric(10,0) NOT NULL,
    key varchar2(30 CHAR) NOT NULL,
    value varchar2(4000 CHAR) NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT user_settings_pk PRIMARY KEY (id)
);

CREATE UNIQUE INDEX idx_user_set__person_key ON user_setting (person_id, key);

CREATE TABLE version (
    id number(8) NOT NULL,
    release varchar2(255 CHAR),
    name varchar2(255 CHAR),
    type varchar2(255 CHAR),
    description clob,
    "date" timestamp,
    CONSTRAINT version_pk PRIMARY KEY (id)
);

CREATE TABLE video_link (
    id numeric(10,0) NOT NULL,
    url varchar2(70 CHAR) NOT NULL,
    description varchar2(1000 CHAR) NOT NULL,
    "date" timestamp DEFAULT systimestamp,
    owner_id number(8),
    network_id number(8),
    group_id number(8),
    "public" char(1) DEFAULT ('N') NOT NULL,
    CONSTRAINT videolink_pk PRIMARY KEY (id)
);

CREATE TABLE video_link_comment (
    id numeric(10,0) NOT NULL,
    message varchar2(1000 CHAR) NOT NULL,
    videolink_id numeric(10,0),
    author_id numeric(10,0) NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    CONSTRAINT videolink_comment_pk PRIMARY KEY (id)
);

CREATE SEQUENCE wiki_editor_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE wiki_editor (
    id number(8) NOT NULL,
    parent_item_id number(8) NOT NULL,
    parent_item_type varchar2(32 CHAR) NOT NULL,
    old_group_id number(8),
    CONSTRAINT wiki_editor_pk PRIMARY KEY (id),
    CONSTRAINT wiki_editor_parent_item_uk UNIQUE (parent_item_id, parent_item_type)
);

CREATE TABLE wiki_editor_backup (
    wiki_editor_id number(8) NOT NULL,
    headline varchar2(255 CHAR) NOT NULL,
    wiki_text clob NOT NULL,
    author_id number(8) NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT wiki_editor_backup_pk PRIMARY KEY (wiki_editor_id)
);

CREATE SEQUENCE wiki_editor_version_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE wiki_editor_version (
    id number(8) NOT NULL,
    wiki_editor_id number(8) NOT NULL,
    headline varchar2(255 CHAR) NOT NULL,
    wiki_text clob NOT NULL,
    version integer DEFAULT 0 NOT NULL,
    author_id number(8) DEFAULT (-1) NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    restored_from number(8),
    old_page_id number(8),
    CONSTRAINT wiki_editor_version_pk PRIMARY KEY (id),
    CONSTRAINT wiki_editor_version_uk UNIQUE (version, wiki_editor_id)
);

CREATE INDEX idx_wiki_edi_ver__wikieditor ON wiki_editor_version (wiki_editor_id);

CREATE TABLE wiki_group (
    id number(8) NOT NULL,
    network_id number(8) NOT NULL,
    image varchar2(255 CHAR),
    create_date timestamp DEFAULT systimestamp,
    name varchar2(255 CHAR) NOT NULL,
    zipcode varchar2(10 CHAR),
    institution varchar2(255 CHAR),
    contact_name varchar2(255 CHAR),
    state varchar2(255 CHAR),
    description clob,
    keywords clob,
    street varchar2(255 CHAR),
    city varchar2(255 CHAR),
    country_id number(8),
    accessible_for integer,
    visible_for integer,
    editable_for integer,
    invitable_for integer DEFAULT 5,
    CONSTRAINT wiki_group_pk PRIMARY KEY (id)
);

CREATE TABLE wiki_group_member (
    wiki_group_id number(8) NOT NULL,
    inviter_id number(8),
    person_id number(8) NOT NULL,
    status integer DEFAULT 0 NOT NULL,
    member_date timestamp with time zone DEFAULT systimestamp NOT NULL,
    CONSTRAINT wiki_group_member_pk PRIMARY KEY (person_id, wiki_group_id)
);

CREATE TABLE wiki_group_widget_cfg (
    wiki_group_id number(8) NOT NULL,
    member_images_visible char(1) DEFAULT ('Y') NOT NULL,
    members_visible char(1) DEFAULT ('Y') NOT NULL,
    forum_visible char(1) DEFAULT ('Y') NOT NULL,
    wall_visible char(1) DEFAULT ('Y') NOT NULL,
    documents_visible char(1) DEFAULT ('Y') NOT NULL,
    privacy_visible char(1) DEFAULT ('Y') NOT NULL,
    wikis_visible char(1) DEFAULT ('Y') NOT NULL,
    groups_visible char(1) DEFAULT ('Y') NOT NULL,
    admin_list_visible char(1) DEFAULT ('Y') NOT NULL,
    CONSTRAINT wiki_group_widget_cfg_pk PRIMARY KEY (wiki_group_id)
);

CREATE TABLE wiki_page (
    id number(8) NOT NULL,
    wiki_group_id number(8) NOT NULL,
    headline varchar2(255 CHAR) NOT NULL,
    summary clob,
    keywords clob,
    create_date timestamp DEFAULT systimestamp,
    locked_by number(8),
    CONSTRAINT wiki_page_pk PRIMARY KEY (id)
);

CREATE TABLE wiki_page_backup (
    id number(8) NOT NULL,
    wiki_page_id number(8) NOT NULL,
    person_id number(8) NOT NULL,
    headline varchar2(255 CHAR) NOT NULL,
    summary clob,
    wiki_text clob,
    keywords clob,
    edit_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT wiki_page_backup_pk PRIMARY KEY (id)
);

CREATE TABLE wiki_page_version (
    id number(8) NOT NULL,
    version integer DEFAULT 0 NOT NULL,
    wiki_text clob NOT NULL,
    wiki_page_id number(8) NOT NULL,
    author_id number(8) DEFAULT (-1) NOT NULL,
    edit_date timestamp DEFAULT systimestamp NOT NULL,
    restored_from number(8),
    CONSTRAINT wiki_page_version_pk PRIMARY KEY (id),
    CONSTRAINT wiki_page_version_uk UNIQUE (version, wiki_page_id)
);



CREATE TABLE workstream (
    entry_id number(8) NOT NULL,
    item_id number(8) NOT NULL,
    item_type varchar2(32 CHAR) NOT NULL,
    CONSTRAINT workstream_pk UNIQUE (entry_id, item_id, item_type)
);

CREATE INDEX idx_workstream__entry ON workstream (entry_id);
CREATE INDEX idx_workstream__item_item_type ON workstream (item_id, item_type);

CREATE TABLE workstream_attachment (
    entry_id number(8) NOT NULL,
    item_id number(8) NOT NULL,
    item_type varchar2(32 CHAR) NOT NULL,
    CONSTRAINT workstream_attachment_pk PRIMARY KEY (item_id, item_type)
);

CREATE SEQUENCE workstream_entry_seq
    START WITH 3
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE workstream_entry (
    id number(8) NOT NULL,
    type varchar2(32 CHAR) NOT NULL,
    origin_item_id number(8) NOT NULL,
    origin_item_type varchar2(32 CHAR) NOT NULL,
    author_id number(8) DEFAULT (-1) NOT NULL,
    created_at timestamp DEFAULT systimestamp NOT NULL,
    modified_at timestamp,
    CONSTRAINT workstream_entry_pk PRIMARY KEY (id)
);

CREATE TABLE workstream_entry_attribute (
    entry_id number(8) NOT NULL,
    key varchar2(24 CHAR) NOT NULL,
    value clob NOT NULL
);

CREATE INDEX idx_workstream_ent_att__entry ON workstream_entry_attribute (entry_id);

CREATE TABLE zodiac (
    id numeric(2,0) NOT NULL,
    name varchar2(50 CHAR) NOT NULL,
    CONSTRAINT zodiac_pk PRIMARY KEY (id),
    CONSTRAINT zodiac_name_uk UNIQUE (name)
);

ALTER TABLE accepted_external_invitation ADD CONSTRAINT a_e_i__per__inviter_fk FOREIGN KEY (inviter_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE accepted_external_invitation ADD CONSTRAINT a_e_i__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE appointment_participant ADD CONSTRAINT a_p__app__appointment_fk FOREIGN KEY (appointment_id) REFERENCES appointment (id) ON DELETE CASCADE;
ALTER TABLE appointment_participant ADD CONSTRAINT a_p__per__inviter_fk FOREIGN KEY (inviter_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE appointment_participant ADD CONSTRAINT a_p__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE appointment_widget_cfg ADD CONSTRAINT a_w_c__app__appointment_fk FOREIGN KEY (appointment_id) REFERENCES appointment (id) ON DELETE CASCADE;

ALTER TABLE album ADD CONSTRAINT alb__app__appointment_fk FOREIGN KEY (appointment_id) REFERENCES appointment (id) ON DELETE CASCADE;
ALTER TABLE album ADD CONSTRAINT alb__g_t__group_fk FOREIGN KEY (group_id) REFERENCES group_table (id);
ALTER TABLE album ADD CONSTRAINT alb__net__network_fk FOREIGN KEY (network_id) REFERENCES network (id) ON DELETE CASCADE;
ALTER TABLE album ADD CONSTRAINT alb__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE album ADD CONSTRAINT alb__w_g__wiki_group_fk FOREIGN KEY (wiki_group_id) REFERENCES wiki_group (id) ON DELETE CASCADE;

ALTER TABLE appointment ADD CONSTRAINT app__net__country_fk FOREIGN KEY (country_id) REFERENCES network (id);
ALTER TABLE appointment ADD CONSTRAINT app__net__network_fk FOREIGN KEY (network_id) REFERENCES network (id) ON DELETE CASCADE;

ALTER TABLE contact_data_basic ADD CONSTRAINT c_d_b__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE city ADD CONSTRAINT cit__net__region_fk FOREIGN KEY (region_id) REFERENCES network (id) ON DELETE CASCADE;

ALTER TABLE default_album ADD CONSTRAINT d_a__m_a__album_fk FOREIGN KEY (album_id) REFERENCES mdl_album (id) ON DELETE CASCADE;

ALTER TABLE document_file ADD CONSTRAINT d_f__per__checked_out_by_fk FOREIGN KEY (checked_out_by) REFERENCES person (id) ON DELETE SET NULL;
ALTER TABLE document_file ADD CONSTRAINT d_f__per__status_changed_by_fk FOREIGN KEY (status_changed_by) REFERENCES person (id) ON DELETE SET NULL;

ALTER TABLE domain_property ADD CONSTRAINT d_p__b_p__base_property_fk FOREIGN KEY (base_property) REFERENCES base_property (id);

ALTER TABLE dynamic_person_attribute ADD CONSTRAINT d_p_a__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE document_version ADD CONSTRAINT d_v__d_f__doc_file_fk FOREIGN KEY (document_file_id) REFERENCES document_file (id);
ALTER TABLE document_version ADD CONSTRAINT d_v__f_t__file_t_fk FOREIGN KEY (file_type_id) REFERENCES file_type (id);
ALTER TABLE document_version ADD CONSTRAINT d_v__per__uploaded_by_fk FOREIGN KEY (uploaded_by) REFERENCES person (id) ON DELETE SET NULL;

ALTER TABLE entity_contact_data ADD CONSTRAINT e_c_d__cou__country_fk FOREIGN KEY (country_id) REFERENCES country (id);
ALTER TABLE entity_contact_data ADD CONSTRAINT e_c_d__ent__entity_fk FOREIGN KEY (entity_id) REFERENCES entity (id) ON DELETE CASCADE;

ALTER TABLE entity_component_open_for ADD CONSTRAINT e_c_o_f__ent__entity_fk FOREIGN KEY (entity_id) REFERENCES entity (id) ON DELETE CASCADE;

ALTER TABLE entity_category ADD CONSTRAINT e_cat__e_t__entity_t_fk FOREIGN KEY (entity_type) REFERENCES entity_type (id) ON DELETE CASCADE;

ALTER TABLE entity_component ADD CONSTRAINT e_com__ent__entity_fk FOREIGN KEY (entity_id) REFERENCES entity (id) ON DELETE CASCADE;

ALTER TABLE entity_design ADD CONSTRAINT e_d__ent__entity_fk FOREIGN KEY (entity_id) REFERENCES entity (id) ON DELETE CASCADE DEFERRABLE;

ALTER TABLE external_invitation ADD CONSTRAINT e_i__ent__entity_fk FOREIGN KEY (entity_id) REFERENCES entity (id) ON DELETE CASCADE;
ALTER TABLE external_invitation ADD CONSTRAINT e_i__per__inviter_fk FOREIGN KEY (inviter_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE entity_link ADD CONSTRAINT e_l__ent__entity_fk FOREIGN KEY (entity_id) REFERENCES entity (id) ON DELETE CASCADE;
ALTER TABLE entity_link ADD CONSTRAINT e_l__ent__linked_entity_fk FOREIGN KEY (linked_entity_id) REFERENCES entity (id) ON DELETE CASCADE;

ALTER TABLE entity_member ADD CONSTRAINT e_m__ent__entity_fk FOREIGN KEY (entity_id) REFERENCES entity (id) ON DELETE CASCADE;
ALTER TABLE entity_member ADD CONSTRAINT e_m__per__inviter_fk FOREIGN KEY (inviter_id) REFERENCES person (id) ON DELETE SET NULL;
ALTER TABLE entity_member ADD CONSTRAINT e_m__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE email_notification ADD CONSTRAINT e_n__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE entity_nav_link ADD CONSTRAINT e_n_l__ent__entity_fk FOREIGN KEY (entity_id) REFERENCES entity (id) ON DELETE CASCADE;

ALTER TABLE entity_nav_sublink ADD CONSTRAINT e_n_s__e_n_l__parent_fk FOREIGN KEY (parent_id) REFERENCES entity_nav_link (id) ON DELETE CASCADE;

ALTER TABLE email_notification_setting ADD CONSTRAINT e_n_s__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE entity_option ADD CONSTRAINT e_o__ent__entity_fk FOREIGN KEY (entity_id) REFERENCES entity (id) ON DELETE CASCADE;

ALTER TABLE entity_privacy ADD CONSTRAINT e_p__ent__entity_fk FOREIGN KEY (entity_id) REFERENCES entity (id) ON DELETE CASCADE;

ALTER TABLE entity_to_entity_type_privacy ADD CONSTRAINT e_t_e_t_p__ent__entity_fk FOREIGN KEY (entity_id) REFERENCES entity (id) ON DELETE CASCADE;

ALTER TABLE entity_type_allowed_component ADD CONSTRAINT e_t_a_c__e_t__entity_t_fk FOREIGN KEY (entity_type_id) REFERENCES entity_type (id) ON DELETE CASCADE;

ALTER TABLE entity_type_linked_entity_type ADD CONSTRAINT e_t_l_e_t__e_t__entity_t_fk FOREIGN KEY (entity_type_id) REFERENCES entity_type (id) ON DELETE CASCADE;
ALTER TABLE entity_type_linked_entity_type ADD CONSTRAINT e_t_l_e_t__e_t__l_entity_t_fk FOREIGN KEY (linked_entity_type_id) REFERENCES entity_type (id) ON DELETE CASCADE;

ALTER TABLE email_user ADD CONSTRAINT e_u__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE employment ADD CONSTRAINT emp__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE entity ADD CONSTRAINT ent__e_t__entity_t_fk FOREIGN KEY (entity_type) REFERENCES entity_type (id);

ALTER TABLE forum_topic ADD CONSTRAINT f_t__for__forum_fk FOREIGN KEY (forum_id) REFERENCES forum (forum_id) ON DELETE CASCADE;
ALTER TABLE forum_topic ADD CONSTRAINT f_t__per__last_replier_fk FOREIGN KEY (last_replier_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE forum_topic_article ADD CONSTRAINT f_t_a__f_t__topic_fk FOREIGN KEY (topic_id) REFERENCES forum_topic (id) ON DELETE CASCADE;

ALTER TABLE facebook_user ADD CONSTRAINT f_u__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE group_member ADD CONSTRAINT g_m__g_t__group_fk FOREIGN KEY (group_id) REFERENCES group_table (id) ON DELETE CASCADE;
ALTER TABLE group_member ADD CONSTRAINT g_m__per__inviter_fk FOREIGN KEY (inviter_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE group_member ADD CONSTRAINT g_m__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE group_table ADD CONSTRAINT g_t__net__country_fk FOREIGN KEY (country_id) REFERENCES network (id);
ALTER TABLE group_table ADD CONSTRAINT g_t__net__network_fk FOREIGN KEY (network_id) REFERENCES network (id) ON DELETE CASCADE;

ALTER TABLE greeting ADD CONSTRAINT gre__per__recipient_fk FOREIGN KEY (recipient_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE greeting ADD CONSTRAINT gre__per__sender_fk FOREIGN KEY (sender_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE image_comment ADD CONSTRAINT i_c__img__image_fk FOREIGN KEY (image_id) REFERENCES image (id) ON DELETE CASCADE;
ALTER TABLE image_comment ADD CONSTRAINT i_c__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE ignore_list ADD CONSTRAINT i_l__per__ignored_fk FOREIGN KEY (ignored_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE ignore_list ADD CONSTRAINT i_l__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE image_person_link ADD CONSTRAINT i_p_l__img__image_fk FOREIGN KEY (image_id) REFERENCES image (id) ON DELETE CASCADE;
ALTER TABLE image_person_link ADD CONSTRAINT i_p_l__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE image ADD CONSTRAINT img__alb__album_fk FOREIGN KEY (album_id) REFERENCES album (id) ON DELETE CASCADE;
ALTER TABLE image ADD CONSTRAINT img__per__owner_fk FOREIGN KEY (owner_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE jabber_synced ADD CONSTRAINT j_s__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE jabber_temp_password ADD CONSTRAINT j_t_p__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE kadget ADD CONSTRAINT kad__per__owner_fk FOREIGN KEY (owner_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE like_subscribe ADD CONSTRAINT l_s__per__subscriber_fk FOREIGN KEY (subscriber_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE like_table ADD CONSTRAINT l_t__per__liker_fk FOREIGN KEY (liker_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE like_unsubscribe ADD CONSTRAINT l_u__per__unsubscriber_fk FOREIGN KEY (unsubscriber_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE mdl_album ADD CONSTRAINT m_a__per__owner_fk FOREIGN KEY (owner_id) REFERENCES person (id) ON DELETE SET NULL;

ALTER TABLE mdl_album_image ADD CONSTRAINT m_a_i__m_a__album_fk FOREIGN KEY (album_id) REFERENCES mdl_album (id) ON DELETE CASCADE;
ALTER TABLE mdl_album_image ADD CONSTRAINT m_a_i__per__owner_fk FOREIGN KEY (owner_id) REFERENCES person (id) ON DELETE SET NULL;

ALTER TABLE mdl_comment ADD CONSTRAINT m_c__per__author_fk FOREIGN KEY (author_id) REFERENCES person (id) ON DELETE SET NULL;

ALTER TABLE mdl_document ADD CONSTRAINT m_d__per__checked_out_by_fk FOREIGN KEY (checked_out_by) REFERENCES person (id) ON DELETE SET NULL;
ALTER TABLE mdl_document ADD CONSTRAINT m_d__per__status_changed_by_fk FOREIGN KEY (status_changed_by) REFERENCES person (id) ON DELETE SET NULL;

ALTER TABLE map_document_file_appointment ADD CONSTRAINT m_d_f_a__app__appointment_fk FOREIGN KEY (appointment_id) REFERENCES appointment (id);
ALTER TABLE map_document_file_appointment ADD CONSTRAINT m_d_f_a__d_f__doc_file_fk FOREIGN KEY (document_file_id) REFERENCES document_file (id) ON DELETE CASCADE;

ALTER TABLE map_document_file_group ADD CONSTRAINT m_d_f_g__d_f__doc_file_fk FOREIGN KEY (document_file_id) REFERENCES document_file (id) ON DELETE CASCADE;
ALTER TABLE map_document_file_group ADD CONSTRAINT m_d_f_g__g_t__group_fk FOREIGN KEY (group_id) REFERENCES group_table (id);

ALTER TABLE map_document_file_network ADD CONSTRAINT m_d_f_n__d_f__doc_file_fk FOREIGN KEY (document_file_id) REFERENCES document_file (id) ON DELETE CASCADE;
ALTER TABLE map_document_file_network ADD CONSTRAINT m_d_f_n__net__network_fk FOREIGN KEY (network_id) REFERENCES network (id);

ALTER TABLE map_document_file_wiki_group ADD CONSTRAINT m_d_f_w_g__d_f__doc_file_fk FOREIGN KEY (document_file_id) REFERENCES document_file (id) ON DELETE CASCADE;
ALTER TABLE map_document_file_wiki_group ADD CONSTRAINT m_d_f_w_g__w_g__wiki_group_fk FOREIGN KEY (wiki_group_id) REFERENCES wiki_group (id);

ALTER TABLE mdl_document_version ADD CONSTRAINT m_d_v__f_t__file_t_fk FOREIGN KEY (file_type_id) REFERENCES file_type (id);
ALTER TABLE mdl_document_version ADD CONSTRAINT m_d_v__m_d__document_fk FOREIGN KEY (document_id) REFERENCES mdl_document (id);
ALTER TABLE mdl_document_version ADD CONSTRAINT m_d_v__per__uploaded_by_fk FOREIGN KEY (uploaded_by) REFERENCES person (id) ON DELETE SET NULL;

ALTER TABLE mdl_forum_topic ADD CONSTRAINT m_f_t__per__author_fk FOREIGN KEY (author_id) REFERENCES person (id) ON DELETE SET NULL;

ALTER TABLE mdl_forum_topic_article ADD CONSTRAINT m_f_t_a__m_f_t__topic_fk FOREIGN KEY (topic_id) REFERENCES mdl_forum_topic (id) ON DELETE CASCADE;
ALTER TABLE mdl_forum_topic_article ADD CONSTRAINT m_f_t_a__per__author_fk FOREIGN KEY (author_id) REFERENCES person (id) ON DELETE SET NULL;
ALTER TABLE mdl_forum_topic_article ADD CONSTRAINT m_f_t_a__per__editor_fk FOREIGN KEY (editor_id) REFERENCES person (id) ON DELETE SET NULL;

ALTER TABLE message_inbox ADD CONSTRAINT m_i__msg__message_fk FOREIGN KEY (message_id) REFERENCES message (id) ON DELETE CASCADE;
ALTER TABLE message_inbox ADD CONSTRAINT m_i__per__owner_fk FOREIGN KEY (owner_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE map_kadget_network ADD CONSTRAINT m_k_n__kad__kadget_fk FOREIGN KEY (kadget_id) REFERENCES kadget (id) ON DELETE CASCADE;
ALTER TABLE map_kadget_network ADD CONSTRAINT m_k_n__net__network_fk FOREIGN KEY (network_id) REFERENCES network (id) ON DELETE CASCADE;

ALTER TABLE map_network_city ADD CONSTRAINT m_n_c__cit__city_fk FOREIGN KEY (city_id) REFERENCES city (id);
ALTER TABLE map_network_city ADD CONSTRAINT m_n_c__net__network_fk FOREIGN KEY (network_id) REFERENCES network (id) ON DELETE CASCADE;

ALTER TABLE message_outbox ADD CONSTRAINT m_o__msg__message_fk FOREIGN KEY (message_id) REFERENCES message (id) ON DELETE CASCADE;
ALTER TABLE message_outbox ADD CONSTRAINT m_o__per__owner_fk FOREIGN KEY (owner_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE map_person_network ADD CONSTRAINT m_p_n__net__network_fk FOREIGN KEY (network_id) REFERENCES network (id) ON DELETE CASCADE;
ALTER TABLE map_person_network ADD CONSTRAINT m_p_n__per__inviter_fk FOREIGN KEY (inviter_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE map_person_network ADD CONSTRAINT m_p_n__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE map_person_person ADD CONSTRAINT m_p_p__per__friend_fk FOREIGN KEY (friend_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE map_person_person ADD CONSTRAINT m_p_p__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE map_person_person_invite ADD CONSTRAINT m_p_p_i__per__friend_fk FOREIGN KEY (friend_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE map_person_person_invite ADD CONSTRAINT m_p_p_i__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE map_person_relationship_type ADD CONSTRAINT m_p_r_t__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE map_person_relationship_type ADD CONSTRAINT m_p_r_t__r_t__relationshipt_fk FOREIGN KEY (relationshiptype_id) REFERENCES relationship_type (id);

ALTER TABLE message_recipient ADD CONSTRAINT m_r__msg__message_fk FOREIGN KEY (message_id) REFERENCES message (id) ON DELETE CASCADE;
ALTER TABLE message_recipient ADD CONSTRAINT m_r__per__recipient_fk FOREIGN KEY (recipient_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE map_url_network ADD CONSTRAINT m_u_n__net__network_fk FOREIGN KEY (network_id) REFERENCES network (id) ON DELETE CASCADE;

ALTER TABLE mdl_video_link ADD CONSTRAINT m_v_l__per__author_fk FOREIGN KEY (author_id) REFERENCES person (id) ON DELETE SET NULL;

ALTER TABLE message ADD CONSTRAINT msg__per__sender_fk FOREIGN KEY (sender_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE network_design ADD CONSTRAINT n_d__net__network_fk FOREIGN KEY (network_id) REFERENCES network (id) ON DELETE CASCADE DEFERRABLE;

ALTER TABLE network_link ADD CONSTRAINT n_l__net__network1_fk FOREIGN KEY (network_id1) REFERENCES network (id) ON DELETE CASCADE;
ALTER TABLE network_link ADD CONSTRAINT n_l__net__network2_fk FOREIGN KEY (network_id2) REFERENCES network (id) ON DELETE CASCADE;

ALTER TABLE network_news ADD CONSTRAINT n_n__net__network_fk FOREIGN KEY (network_id) REFERENCES network (id) ON DELETE CASCADE DEFERRABLE;
ALTER TABLE network_news ADD CONSTRAINT n_n__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE DEFERRABLE;

ALTER TABLE network_nav_link ADD CONSTRAINT n_n_l__net__network_fk FOREIGN KEY (network_id) REFERENCES network (id) ON DELETE CASCADE;

ALTER TABLE network_widget_cfg ADD CONSTRAINT n_w_c__net__network_fk FOREIGN KEY (network_id) REFERENCES network (id);

ALTER TABLE news_blog ADD CONSTRAINT nbg__m_a_i__image_fk FOREIGN KEY (image_id) REFERENCES mdl_album_image (id) ON DELETE SET NULL;
ALTER TABLE news_blog ADD CONSTRAINT nbg__per__author_fk FOREIGN KEY (author_id) REFERENCES person (id) ON DELETE SET NULL;

ALTER TABLE network ADD CONSTRAINT net__lan__language_fk FOREIGN KEY (language) REFERENCES language (id);
ALTER TABLE network ADD CONSTRAINT net__n_t__type_fk FOREIGN KEY (type) REFERENCES network_type (id);
ALTER TABLE network ADD CONSTRAINT net__net__parent_fk FOREIGN KEY (parent_id) REFERENCES network (id);

ALTER TABLE open_social_app_data ADD CONSTRAINT o_s_a_d__m_k_n__kadget_fk FOREIGN KEY (kadget_id) REFERENCES map_kadget_network (id) ON DELETE CASCADE;
ALTER TABLE open_social_app_data ADD CONSTRAINT o_s_a_d__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE profile_component ADD CONSTRAINT p_c__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE profile_component_visibility ADD CONSTRAINT p_c_v__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE person_primary_network ADD CONSTRAINT p_p_n__ent__network_fk FOREIGN KEY (network_id) REFERENCES entity (id) ON DELETE CASCADE;
ALTER TABLE person_primary_network ADD CONSTRAINT p_p_n__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE person_to_role ADD CONSTRAINT p_t_r__p_r__role_name_fk FOREIGN KEY (role_name) REFERENCES person_role (role_name);
ALTER TABLE person_to_role ADD CONSTRAINT p_t_r__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE profile_visibility_for_role ADD CONSTRAINT p_v_f_r__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE person ADD CONSTRAINT per__lan__language_fk FOREIGN KEY (language_id) REFERENCES language (id);
ALTER TABLE person ADD CONSTRAINT per__p_v__politview_fk FOREIGN KEY (politview_id) REFERENCES polit_view (id);
ALTER TABLE person ADD CONSTRAINT per__r_s__relationshipstatu_fk FOREIGN KEY (relationshipstatus_id) REFERENCES relationship_status (id);
ALTER TABLE person ADD CONSTRAINT per__r_v__religview_fk FOREIGN KEY (religview_id) REFERENCES relig_view (id);
ALTER TABLE person ADD CONSTRAINT per__sta__status_fk FOREIGN KEY (status_id) REFERENCES status (id) ON DELETE SET NULL;
ALTER TABLE person ADD CONSTRAINT per__zod__zodiac_fk FOREIGN KEY (zodiac_id) REFERENCES zodiac (id);

ALTER TABLE random_member_component_cfg ADD CONSTRAINT r_m_c_c__ent__entity_fk FOREIGN KEY (entity_id) REFERENCES entity (id) ON DELETE CASCADE;
ALTER TABLE random_member_component_cfg ADD CONSTRAINT r_m_c_c__p_r__role_name_fk FOREIGN KEY (role_name) REFERENCES person_role (role_name) ON DELETE CASCADE;

ALTER TABLE raweditor_version ADD CONSTRAINT r_v__per__author_fk FOREIGN KEY (author_id) REFERENCES person (id) ON DELETE SET NULL;

ALTER TABLE rights ADD CONSTRAINT rig__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE subscription_notification ADD CONSTRAINT s_n__per__actor_fk FOREIGN KEY (actor_id) REFERENCES person (id) ON DELETE SET NULL;

ALTER TABLE start_page_profile ADD CONSTRAINT s_p_p__lan__language_fk FOREIGN KEY (language) REFERENCES language (id) ON DELETE CASCADE;
ALTER TABLE start_page_profile ADD CONSTRAINT s_p_p__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE survey_participant_answer ADD CONSTRAINT s_par_a__per__participant_fk FOREIGN KEY (participant_id) REFERENCES person (id) ON DELETE SET NULL;
ALTER TABLE survey_participant_answer ADD CONSTRAINT s_par_a__s_pre_a__pre_answ_fk FOREIGN KEY (survey_predefined_answer_id) REFERENCES survey_predefined_answer (id) ON DELETE CASCADE;
ALTER TABLE survey_participant_answer ADD CONSTRAINT s_par_a__s_q__question_fk FOREIGN KEY (survey_question_id) REFERENCES survey_question (id) ON DELETE CASCADE;

ALTER TABLE survey_predefined_answer ADD CONSTRAINT s_pre_a__s_q__question_fk FOREIGN KEY (survey_question_id) REFERENCES survey_question (id) ON DELETE CASCADE;

ALTER TABLE survey_question ADD CONSTRAINT s_q__sur__survey_fk FOREIGN KEY (survey_id) REFERENCES survey (id) ON DELETE CASCADE;

ALTER TABLE status_translation ADD CONSTRAINT s_t__lan__language_fk FOREIGN KEY (language) REFERENCES language (id) ON DELETE CASCADE;
ALTER TABLE status_translation ADD CONSTRAINT s_t__sta__status_fk FOREIGN KEY (status_id) REFERENCES status (id) ON DELETE CASCADE;

ALTER TABLE school ADD CONSTRAINT sch__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE subscription ADD CONSTRAINT sub__per__subscriber_fk FOREIGN KEY (subscriber_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE survey ADD CONSTRAINT sur__per__owner_fk FOREIGN KEY (owner_id) REFERENCES person (id) ON DELETE SET NULL;

ALTER TABLE systemmessage ADD CONSTRAINT sys__alb__album_fk FOREIGN KEY (album_id) REFERENCES album (id) ON DELETE CASCADE;
ALTER TABLE systemmessage ADD CONSTRAINT sys__app__appointment_fk FOREIGN KEY (appointment_id) REFERENCES appointment (id) ON DELETE CASCADE;
ALTER TABLE systemmessage ADD CONSTRAINT sys__d_f__doc_file_fk FOREIGN KEY (document_file_id) REFERENCES document_file (id) ON DELETE CASCADE;
ALTER TABLE systemmessage ADD CONSTRAINT sys__d_v__document_version_fk FOREIGN KEY (document_version_id) REFERENCES document_version (id) ON DELETE CASCADE;
ALTER TABLE systemmessage ADD CONSTRAINT sys__f_t__topic_fk FOREIGN KEY (topic_id) REFERENCES forum_topic (id) ON DELETE CASCADE;
ALTER TABLE systemmessage ADD CONSTRAINT sys__g_t__group_fk FOREIGN KEY (group_id) REFERENCES group_table (id) ON DELETE CASCADE;
ALTER TABLE systemmessage ADD CONSTRAINT sys__img__foto_fk FOREIGN KEY (foto_id) REFERENCES image (id) ON DELETE CASCADE;
ALTER TABLE systemmessage ADD CONSTRAINT sys__net__network_fk FOREIGN KEY (network_id) REFERENCES network (id) ON DELETE CASCADE;
ALTER TABLE systemmessage ADD CONSTRAINT sys__per__creator_fk FOREIGN KEY (creator_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE systemmessage ADD CONSTRAINT sys__per__friendsfriend_fk FOREIGN KEY (friendsfriend_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE systemmessage ADD CONSTRAINT sys__per__receiver_fk FOREIGN KEY (receiver_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE systemmessage ADD CONSTRAINT sys__v_l__video_post_fk FOREIGN KEY (video_post_id) REFERENCES video_link (id) ON DELETE CASCADE;
ALTER TABLE systemmessage ADD CONSTRAINT sys__w_g__wiki_group_fk FOREIGN KEY (wiki_group_id) REFERENCES wiki_group (id) ON DELETE CASCADE;

ALTER TABLE translation ADD CONSTRAINT tra__lan__language_fk FOREIGN KEY (language_id) REFERENCES language (id);
ALTER TABLE translation ADD CONSTRAINT tra__nat__native_fk FOREIGN KEY (native_id) REFERENCES native (id);

ALTER TABLE user_setting ADD CONSTRAINT u_s__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE university ADD CONSTRAINT uni__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE video_link ADD CONSTRAINT v_l__g_t__group_fk FOREIGN KEY (group_id) REFERENCES group_table (id) ON DELETE CASCADE;
ALTER TABLE video_link ADD CONSTRAINT v_l__net__network_fk FOREIGN KEY (network_id) REFERENCES network (id) ON DELETE CASCADE;
ALTER TABLE video_link ADD CONSTRAINT v_l__per__owner_fk FOREIGN KEY (owner_id) REFERENCES person (id) ON DELETE CASCADE;

ALTER TABLE video_link_comment ADD CONSTRAINT v_l_c__per__author_fk FOREIGN KEY (author_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE video_link_comment ADD CONSTRAINT v_l_c__v_l__videolink_fk FOREIGN KEY (videolink_id) REFERENCES video_link (id) ON DELETE CASCADE;

ALTER TABLE workstream_attachment ADD CONSTRAINT w_a__w_e__entry_fk FOREIGN KEY (entry_id) REFERENCES workstream_entry (id) ON DELETE CASCADE;

ALTER TABLE workstream_entry ADD CONSTRAINT w_e__per__author_fk FOREIGN KEY (author_id) REFERENCES person (id) ON DELETE SET NULL;

ALTER TABLE workstream_entry_attribute ADD CONSTRAINT w_e_a__w_e__entry_fk FOREIGN KEY (entry_id) REFERENCES workstream_entry (id) ON DELETE CASCADE;

ALTER TABLE wiki_editor_backup ADD CONSTRAINT w_e_b__per__author_fk FOREIGN KEY (author_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE wiki_editor_backup ADD CONSTRAINT w_e_b__w_e__wiki_editor_fk FOREIGN KEY (wiki_editor_id) REFERENCES wiki_editor (id) ON DELETE CASCADE;

ALTER TABLE wiki_editor_version ADD CONSTRAINT w_e_v__per__author_fk FOREIGN KEY (author_id) REFERENCES person (id) ON DELETE SET NULL;
ALTER TABLE wiki_editor_version ADD CONSTRAINT w_e_v__w_e__wiki_editor_fk FOREIGN KEY (wiki_editor_id) REFERENCES wiki_editor (id) ON DELETE CASCADE;
ALTER TABLE wiki_editor_version ADD CONSTRAINT w_e_v__w_e_v__restored_from_fk FOREIGN KEY (restored_from) REFERENCES wiki_editor_version (id) ON DELETE SET NULL;

ALTER TABLE wiki_group ADD CONSTRAINT w_g__net__network_fk FOREIGN KEY (network_id) REFERENCES network (id);

ALTER TABLE wiki_group_member ADD CONSTRAINT w_g_m__per__inviter_fk FOREIGN KEY (inviter_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE wiki_group_member ADD CONSTRAINT w_g_m__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE wiki_group_member ADD CONSTRAINT w_g_m__w_g__wiki_group_fk FOREIGN KEY (wiki_group_id) REFERENCES wiki_group (id) ON DELETE CASCADE;

ALTER TABLE wiki_group_widget_cfg ADD CONSTRAINT w_g_w_c__w_g__wiki_group_fk FOREIGN KEY (wiki_group_id) REFERENCES wiki_group (id) ON DELETE CASCADE;

ALTER TABLE wiki_page ADD CONSTRAINT w_p__per__locked_by_fk FOREIGN KEY (locked_by) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE wiki_page ADD CONSTRAINT w_p__w_g__wiki_group_fk FOREIGN KEY (wiki_group_id) REFERENCES wiki_group (id) ON DELETE CASCADE;

ALTER TABLE wiki_page_backup ADD CONSTRAINT w_p_b__per__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE;
ALTER TABLE wiki_page_backup ADD CONSTRAINT w_p_b__w_p__wiki_page_fk FOREIGN KEY (wiki_page_id) REFERENCES wiki_page (id) ON DELETE CASCADE;

ALTER TABLE wiki_page_version ADD CONSTRAINT w_p_v__per__author_fk FOREIGN KEY (author_id) REFERENCES person (id) ON DELETE SET NULL;
ALTER TABLE wiki_page_version ADD CONSTRAINT w_p_v__w_p__wiki_page_fk FOREIGN KEY (wiki_page_id) REFERENCES wiki_page (id) ON DELETE CASCADE;
ALTER TABLE wiki_page_version ADD CONSTRAINT w_p_v__w_p_v__restored_from_fk FOREIGN KEY (restored_from) REFERENCES wiki_page_version (id) ON DELETE SET NULL;

ALTER TABLE workstream ADD CONSTRAINT wor__w_e__entry_fk FOREIGN KEY (entry_id) REFERENCES workstream_entry (id) ON DELETE CASCADE;