#!/bin/sh


usage() {
cat << EOF
Usage: $0 properties_file

properties_file Path to dbmaintain.properties file
                e.g. ~/justconnect_conf/dbmaintain.properties
EOF
}

if [ $# -ne 1 ] ; then
    usage
    exit
fi

PROPERTIES_FILE=$1
. $PROPERTIES_FILE

# migrate from version to dbmaintain
if [ "$DBTYPE" = "postgresql" ]; then
    $NATIVE_SCRIPT_RUNNER -h $HOSTNAME -d $DBNAME -U $USERNAME -f initial-version-to-dbmaintain.sql
    $NATIVE_SCRIPT_RUNNER -h $HOSTNAME -d $DBNAME -U $USERNAME -f update-folder-naming-convention.sql
elif [ "$DBTYPE" = "oracle" ]; then
    cat update-folder-naming-convention.sql | $NATIVE_SCRIPT_RUNNER -S $USERNAME/$DBPASSWORD@$TNS_NAME
    cat disable_shadow_triggers.sql | $NATIVE_SCRIPT_RUNNER -S $USERNAME/$DBPASSWORD@$TNS_NAME
fi

# call dbmaintain
./dbmaintain.sh updateDatabase migration/enx -config $PROPERTIES_FILE
