/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.repository.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dbmaintain.script.Script;
import org.dbmaintain.script.ScriptContentHandle;
import org.dbmaintain.script.executedscriptinfo.ScriptIndexes;
import org.dbmaintain.script.qualifier.Qualifier;
import org.dbmaintain.script.repository.ScriptLocation;
import org.dbmaintain.util.DbMaintainException;
import org.dbmaintain.util.FileUtils;
import thirdparty.org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemScriptLocation
extends ScriptLocation {
    public FileSystemScriptLocation(File scriptLocation, String defaultScriptEncoding, String defaultPostProcessingScriptDirName, Set<Qualifier> defaultRegisteredQualifiers, Set<Qualifier> defaultPatchQualifiers, String defaultScriptIndexRegexp, String defaultQualifierRegexp, String defaultTargetDatabaseRegexp, Set<String> defaultScriptFileExtensions, ScriptIndexes baseLineRevision, boolean ignoreCarriageReturnsWhenCalculatingCheckSum) {
        super(scriptLocation, defaultScriptEncoding, defaultPostProcessingScriptDirName, defaultRegisteredQualifiers, defaultPatchQualifiers, defaultScriptIndexRegexp, defaultQualifierRegexp, defaultTargetDatabaseRegexp, defaultScriptFileExtensions, baseLineRevision, ignoreCarriageReturnsWhenCalculatingCheckSum);
    }

    @Override
    protected void assertValidScriptLocation(File scriptLocation) {
        if (scriptLocation == null || !scriptLocation.exists()) {
            throw new DbMaintainException("Script location " + scriptLocation + " does not exist.");
        }
    }

    @Override
    protected Properties getCustomProperties(File scriptLocation) {
        Properties properties;
        File customPropertiesFileLocation = new File(scriptLocation + "/" + "META-INF/dbmaintain.properties");
        if (!customPropertiesFileLocation.exists()) {
            return null;
        }
        FileInputStream propertiesInputStream = null;
        try {
            Properties properties2 = new Properties();
            propertiesInputStream = new FileInputStream(customPropertiesFileLocation);
            properties2.load(propertiesInputStream);
            properties = properties2;
        }
        catch (IOException e) {
            try {
                throw new DbMaintainException("Error while reading configuration file " + customPropertiesFileLocation, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(propertiesInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(propertiesInputStream);
        return properties;
    }

    @Override
    protected SortedSet<Script> loadScripts(File scriptLocation) {
        TreeSet<Script> scripts = new TreeSet<Script>();
        this.getScriptsAt(scripts, scriptLocation.getAbsolutePath(), "");
        return scripts;
    }

    protected void getScriptsAt(SortedSet<Script> scripts, String scriptRoot, String relativeLocation) {
        File currentLocation = new File(scriptRoot + "/" + relativeLocation);
        if (currentLocation.isFile() && this.isScriptFileName(currentLocation.getName())) {
            Script script = this.createScript(currentLocation, relativeLocation);
            scripts.add(script);
            return;
        }
        if (currentLocation.isDirectory()) {
            for (File subLocation : currentLocation.listFiles()) {
                this.getScriptsAt(scripts, scriptRoot, "".equals(relativeLocation) ? subLocation.getName() : relativeLocation + '/' + subLocation.getName());
            }
        }
    }

    protected Script createScript(File scriptFile, String relativeScriptFileName) {
        Long fileLastModifiedAt = scriptFile.lastModified();
        ScriptContentHandle.UrlScriptContentHandle scriptContentHandle = new ScriptContentHandle.UrlScriptContentHandle(FileUtils.getUrl(scriptFile), this.scriptEncoding, this.ignoreCarriageReturnsWhenCalculatingCheckSum);
        return this.scriptFactory.createScriptWithContent(relativeScriptFileName, fileLastModifiedAt, scriptContentHandle);
    }
}

