/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.database.impl;

import java.util.Set;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.DatabaseConnection;
import org.dbmaintain.database.IdentifierProcessor;
import org.dbmaintain.database.SQLHandler;
import org.dbmaintain.database.StoredIdentifierCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlDatabase
extends Database {
    public MySqlDatabase(DatabaseConnection databaseConnection, IdentifierProcessor identifierProcessor) {
        super(databaseConnection, identifierProcessor);
    }

    @Override
    public String getSupportedDatabaseDialect() {
        return "mysql";
    }

    @Override
    public Set<String> getTableNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select table_name from information_schema.tables where table_schema = '" + schemaName + "' and table_type = 'BASE TABLE'", this.getDataSource());
    }

    @Override
    public Set<String> getColumnNames(String schemaName, String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select column_name from information_schema.columns where table_name = '" + tableName + "' and table_schema = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getViewNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select table_name from information_schema.tables where table_schema = '" + schemaName + "' and table_type = 'VIEW'", this.getDataSource());
    }

    @Override
    public Set<String> getTriggerNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select trigger_name from information_schema.triggers where trigger_schema = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public void disableReferentialConstraints(String schemaName) {
        Set<String> tableNames = this.getTableNames(schemaName);
        for (String tableName : tableNames) {
            this.disableReferentialConstraints(schemaName, tableName);
        }
    }

    protected void disableReferentialConstraints(String schemaName, String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> constraintNames = sqlHandler.getItemsAsStringSet("select constraint_name from information_schema.table_constraints where constraint_type = 'FOREIGN KEY' AND table_name = '" + tableName + "' and constraint_schema = '" + schemaName + "'", this.getDataSource());
        for (String constraintName : constraintNames) {
            sqlHandler.execute("alter table " + this.qualified(schemaName, tableName) + " drop foreign key " + this.quoted(constraintName), this.getDataSource());
        }
    }

    @Override
    public void disableValueConstraints(String schemaName) {
        Set<String> tableNames = this.getTableNames(schemaName);
        for (String tableName : tableNames) {
            this.disableValueConstraints(schemaName, tableName);
        }
    }

    protected void disableValueConstraints(String schemaName, String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> constraintNames = sqlHandler.getItemsAsStringSet("select constraint_name from information_schema.table_constraints where constraint_type in ('UNIQUE') AND table_name = '" + tableName + "' and constraint_schema = '" + schemaName + "'", this.getDataSource());
        for (String constraintName : constraintNames) {
            sqlHandler.execute("alter table " + this.qualified(schemaName, tableName) + " drop key " + this.quoted(constraintName), this.getDataSource());
        }
        Set<String> notNullColumnNames = sqlHandler.getItemsAsStringSet("select column_name from information_schema.columns where is_nullable = 'NO' and column_key <> 'PRI' and table_name = '" + tableName + "' and table_schema = '" + schemaName + "'", this.getDataSource());
        for (String notNullColumnName : notNullColumnNames) {
            String columnType = sqlHandler.getItemAsString("select column_type from information_schema.columns where table_schema = '" + schemaName + "' and table_name = '" + tableName + "' and column_name = '" + notNullColumnName + "'", this.getDataSource());
            sqlHandler.execute("alter table " + this.qualified(schemaName, tableName) + " change column " + this.quoted(notNullColumnName) + " " + this.quoted(notNullColumnName) + " " + columnType + " NULL ", this.getDataSource());
        }
    }

    @Override
    public Set<String> getIdentityColumnNames(String schemaName, String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select column_name from information_schema.columns where table_name = '" + tableName + "' and column_key = 'PRI' and table_schema = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public void incrementIdentityColumnToValue(String schemaName, String tableName, String primaryKeyColumnName, long identityValue) {
        this.getSQLHandler().execute("alter table " + this.qualified(schemaName, tableName) + " AUTO_INCREMENT = " + identityValue, this.getDataSource());
    }

    @Override
    public String toCorrectCaseIdentifier(String identifier) {
        StoredIdentifierCase storedIdentifierCase;
        String identifierQuoteString;
        if ((identifier = identifier.trim()).startsWith(identifierQuoteString = this.identifierProcessor.getIdentifierQuoteString()) && identifier.endsWith(identifierQuoteString)) {
            identifier = identifier.substring(1, identifier.length() - 1);
        }
        if ((storedIdentifierCase = this.identifierProcessor.getStoredIdentifierCase()) == StoredIdentifierCase.UPPER_CASE) {
            return identifier.toUpperCase();
        }
        if (storedIdentifierCase == StoredIdentifierCase.LOWER_CASE) {
            return identifier.toLowerCase();
        }
        return identifier;
    }

    @Override
    public void setDatabaseDefaultSchema() {
        this.getSQLHandler().execute("use " + this.getDefaultSchemaName(), this.getDataSource());
    }

    @Override
    public void setSettingIdentityColumnValueEnabled(String schemaName, String tableName, boolean enabled) {
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsIdentityColumns() {
        return true;
    }

    @Override
    public boolean supportsCascade() {
        return true;
    }

    @Override
    public boolean supportsSetDatabaseDefaultSchema() {
        return true;
    }
}

