/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.database;

import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.dbmaintain.database.DatabaseConnection;
import org.dbmaintain.database.DatabaseInfo;
import org.dbmaintain.database.IdentifierProcessor;
import org.dbmaintain.database.SQLHandler;
import org.dbmaintain.database.StoredIdentifierCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Database {
    protected DatabaseConnection databaseConnection;
    protected Set<String> schemaNames;
    protected IdentifierProcessor identifierProcessor;

    protected Database(DatabaseConnection databaseConnection, IdentifierProcessor identifierProcessor) {
        this.databaseConnection = databaseConnection;
        this.identifierProcessor = identifierProcessor;
        this.schemaNames = new HashSet<String>();
        for (String schemaName : this.getDatabaseInfo().getSchemaNames()) {
            this.schemaNames.add(this.toCorrectCaseIdentifier(schemaName));
        }
        if (this.supportsSetDatabaseDefaultSchema()) {
            this.setDatabaseDefaultSchema();
        }
    }

    public abstract String getSupportedDatabaseDialect();

    public StoredIdentifierCase getStoredIdentifierCase() {
        return this.identifierProcessor.getStoredIdentifierCase();
    }

    public String getIdentifierQuoteString() {
        return this.identifierProcessor.getIdentifierQuoteString();
    }

    public DatabaseInfo getDatabaseInfo() {
        return this.databaseConnection.getDatabaseInfo();
    }

    public String getDatabaseName() {
        return this.getDatabaseInfo().getName();
    }

    public DataSource getDataSource() {
        return this.databaseConnection.getDataSource();
    }

    public SQLHandler getSQLHandler() {
        return this.databaseConnection.getSqlHandler();
    }

    public String getDefaultSchemaName() {
        return this.identifierProcessor.getDefaultSchemaName();
    }

    public Set<String> getSchemaNames() {
        return this.schemaNames;
    }

    public Set<String> getTableNames() {
        return this.getTableNames(this.getDefaultSchemaName());
    }

    public abstract Set<String> getTableNames(String var1);

    public Set<String> getColumnNames(String tableName) {
        return this.getColumnNames(this.getDefaultSchemaName(), tableName);
    }

    public abstract Set<String> getColumnNames(String var1, String var2);

    public Set<String> getViewNames() {
        return this.getViewNames(this.getDefaultSchemaName());
    }

    public abstract Set<String> getViewNames(String var1);

    public Set<String> getMaterializedViewNames() {
        return this.getMaterializedViewNames(this.getDefaultSchemaName());
    }

    public Set<String> getMaterializedViewNames(String schemaName) {
        throw new UnsupportedOperationException("Materialized views not supported for " + this.getSupportedDatabaseDialect());
    }

    public Set<String> getSynonymNames() {
        return this.getSynonymNames(this.getDefaultSchemaName());
    }

    public Set<String> getSynonymNames(String schemaName) {
        throw new UnsupportedOperationException("Synonyms not supported for " + this.getSupportedDatabaseDialect());
    }

    public Set<String> getSequenceNames() {
        return this.getSequenceNames(this.getDefaultSchemaName());
    }

    public Set<String> getSequenceNames(String schemaName) {
        throw new UnsupportedOperationException("Sequences not supported for " + this.getSupportedDatabaseDialect());
    }

    public Set<String> getTriggerNames() {
        return this.getTriggerNames(this.getDefaultSchemaName());
    }

    public Set<String> getTriggerNames(String schemaName) {
        throw new UnsupportedOperationException("Triggers not supported for " + this.getSupportedDatabaseDialect());
    }

    public Set<String> getStoredProcedureNames() {
        return this.getStoredProcedureNames(this.getDefaultSchemaName());
    }

    public Set<String> getStoredProcedureNames(String schemaName) {
        throw new UnsupportedOperationException("Stored procedures not supported for " + this.getSupportedDatabaseDialect());
    }

    public Set<String> getTypeNames() {
        return this.getTypeNames(this.getDefaultSchemaName());
    }

    public Set<String> getTypeNames(String schemaName) {
        throw new UnsupportedOperationException("Types are not supported for " + this.getSupportedDatabaseDialect());
    }

    public Set<String> getRuleNames(String schemaName) {
        throw new UnsupportedOperationException("Rules are not supported for " + this.getSupportedDatabaseDialect());
    }

    public void dropTable(String tableName) {
        this.dropTable(this.getDefaultSchemaName(), tableName);
    }

    public void dropTable(String schemaName, String tableName) {
        this.getSQLHandler().execute("drop table " + this.qualified(schemaName, tableName) + (this.supportsCascade() ? " cascade" : ""), this.getDataSource());
    }

    public void dropView(String viewName) {
        this.dropView(this.getDefaultSchemaName(), viewName);
    }

    public void dropView(String schemaName, String viewName) {
        this.getSQLHandler().execute("drop view " + this.qualified(schemaName, viewName) + (this.supportsCascade() ? " cascade" : ""), this.getDataSource());
    }

    public void dropMaterializedView(String viewName) {
        this.dropMaterializedView(this.getDefaultSchemaName(), viewName);
    }

    public void dropMaterializedView(String schemaName, String viewName) {
        throw new UnsupportedOperationException("Materialized views are not supported for " + this.getSupportedDatabaseDialect());
    }

    public void dropSynonym(String synonymName) {
        this.dropSynonym(this.getDefaultSchemaName(), synonymName);
    }

    public void dropSynonym(String schemaName, String synonymName) {
        this.getSQLHandler().execute("drop synonym " + this.qualified(schemaName, synonymName), this.getDataSource());
    }

    public void dropSequence(String sequenceName) {
        this.dropSequence(this.getDefaultSchemaName(), sequenceName);
    }

    public void dropSequence(String schemaName, String sequenceName) {
        this.getSQLHandler().execute("drop sequence " + this.qualified(schemaName, sequenceName), this.getDataSource());
    }

    public void dropTrigger(String triggerName) {
        this.dropTrigger(this.getDefaultSchemaName(), triggerName);
    }

    public void dropTrigger(String schemaName, String triggerName) {
        this.getSQLHandler().execute("drop trigger " + this.qualified(schemaName, triggerName), this.getDataSource());
    }

    public void dropStoredProcedure(String storedProcedureName) {
        this.dropStoredProcedure(this.getDefaultSchemaName(), storedProcedureName);
    }

    public void dropStoredProcedure(String schemaName, String storedProcedureName) {
        this.getSQLHandler().execute("drop procedure " + this.qualified(schemaName, storedProcedureName), this.getDataSource());
    }

    public void dropType(String typeName) {
        this.dropType(this.getDefaultSchemaName(), typeName);
    }

    public void dropType(String schemaName, String typeName) {
        this.getSQLHandler().execute("drop type " + this.qualified(schemaName, typeName) + (this.supportsCascade() ? " cascade" : ""), this.getDataSource());
    }

    public void dropRule(String schemaName, String ruleName) {
        this.getSQLHandler().execute("drop rule " + this.qualified(schemaName, ruleName) + (this.supportsCascade() ? " cascade" : ""), this.getDataSource());
    }

    public void disableReferentialConstraints() {
        this.disableReferentialConstraints(this.getDefaultSchemaName());
    }

    public abstract void disableReferentialConstraints(String var1);

    public void disableValueConstraints() {
        this.disableValueConstraints(this.getDefaultSchemaName());
    }

    public abstract void disableValueConstraints(String var1);

    public long getSequenceValue(String sequenceName) {
        return this.getSequenceValue(this.getDefaultSchemaName(), sequenceName);
    }

    public long getSequenceValue(String schemaName, String sequenceName) {
        throw new UnsupportedOperationException("Sequences not supported for " + this.getSupportedDatabaseDialect());
    }

    public void incrementSequenceToValue(String sequenceName, long newSequenceValue) {
        this.incrementSequenceToValue(this.getDefaultSchemaName(), sequenceName, newSequenceValue);
    }

    public void incrementSequenceToValue(String schemaName, String sequenceName, long newSequenceValue) {
        throw new UnsupportedOperationException("Sequences not supported for " + this.getSupportedDatabaseDialect());
    }

    public Set<String> getIdentityColumnNames(String tableName) {
        return this.getIdentityColumnNames(this.getDefaultSchemaName(), tableName);
    }

    public Set<String> getIdentityColumnNames(String schemaName, String tableName) {
        throw new UnsupportedOperationException("Identity columns not supported for " + this.getSupportedDatabaseDialect());
    }

    public void incrementIdentityColumnToValue(String tableName, String identityColumnName, long identityValue) {
        this.incrementIdentityColumnToValue(this.getDefaultSchemaName(), tableName, identityColumnName, identityValue);
    }

    public void incrementIdentityColumnToValue(String schemaName, String tableName, String identityColumnName, long identityValue) {
        throw new UnsupportedOperationException("Identity columns not supported for " + this.getSupportedDatabaseDialect());
    }

    public void setDatabaseDefaultSchema() {
        throw new UnsupportedOperationException("Setting the current schema is not supported for " + this.getSupportedDatabaseDialect());
    }

    public String getLongDataType() {
        return "BIGINT";
    }

    public String getTextDataType(int length) {
        return "VARCHAR(" + length + ")";
    }

    public String qualified(String databaseObjectName) {
        return this.identifierProcessor.qualified(databaseObjectName);
    }

    public String qualified(String schemaName, String databaseObjectName) {
        return this.identifierProcessor.qualified(schemaName, databaseObjectName);
    }

    public String quoted(String databaseObjectName) {
        return this.identifierProcessor.quoted(databaseObjectName);
    }

    public String toCorrectCaseIdentifier(String identifier) {
        return this.identifierProcessor.toCorrectCaseIdentifier(identifier);
    }

    public boolean isQuoted(String identifier) {
        return this.identifierProcessor.isQuoted(identifier);
    }

    public String removeIdentifierQuotes(String identifier) {
        return this.identifierProcessor.removeIdentifierQuotes(identifier);
    }

    public void setSettingIdentityColumnValueEnabled(String tableName, boolean enabled) {
        this.setSettingIdentityColumnValueEnabled(this.getDefaultSchemaName(), tableName, enabled);
    }

    public void setSettingIdentityColumnValueEnabled(String schemaName, String tableName, boolean enabled) {
        throw new UnsupportedOperationException("Enabling/disabling setting values for identity columns not supported for " + this.getSupportedDatabaseDialect());
    }

    public boolean supportsSynonyms() {
        return false;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsTriggers() {
        return false;
    }

    public boolean supportsStoredProcedures() {
        return false;
    }

    public boolean supportsTypes() {
        return false;
    }

    public boolean supportsRules() {
        return false;
    }

    public boolean supportsIdentityColumns() {
        return false;
    }

    public boolean supportsMaterializedViews() {
        return false;
    }

    public boolean supportsCascade() {
        return false;
    }

    public boolean supportsSetDatabaseDefaultSchema() {
        return false;
    }
}

