/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class ProduceResponse
extends AbstractRequestResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.PRODUCE.id);
    private static final String RESPONSES_KEY_NAME = "responses";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITION_RESPONSES_KEY_NAME = "partition_responses";
    private static final String THROTTLE_TIME_KEY_NAME = "throttle_time_ms";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    public static final long INVALID_OFFSET = -1L;
    private static final int DEFAULT_THROTTLE_TIME = 0;
    private static final String BASE_OFFSET_KEY_NAME = "base_offset";
    private final Map<TopicPartition, PartitionResponse> responses;
    private final int throttleTime;

    public ProduceResponse(Map<TopicPartition, PartitionResponse> responses) {
        super(new Struct(ProtoUtils.responseSchema(ApiKeys.PRODUCE.id, 0)));
        this.initCommonFields(responses);
        this.responses = responses;
        this.throttleTime = 0;
    }

    public ProduceResponse(Map<TopicPartition, PartitionResponse> responses, int throttleTime) {
        super(new Struct(CURRENT_SCHEMA));
        this.initCommonFields(responses);
        this.struct.set(THROTTLE_TIME_KEY_NAME, (Object)throttleTime);
        this.responses = responses;
        this.throttleTime = throttleTime;
    }

    public ProduceResponse(Struct struct) {
        super(struct);
        this.responses = new HashMap<TopicPartition, PartitionResponse>();
        for (Object topicResponse : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicRespStruct = (Struct)topicResponse;
            String topic = topicRespStruct.getString(TOPIC_KEY_NAME);
            for (Object partResponse : topicRespStruct.getArray(PARTITION_RESPONSES_KEY_NAME)) {
                Struct partRespStruct = (Struct)partResponse;
                int partition2 = partRespStruct.getInt(PARTITION_KEY_NAME);
                short errorCode = partRespStruct.getShort(ERROR_CODE_KEY_NAME);
                long offset = partRespStruct.getLong(BASE_OFFSET_KEY_NAME);
                TopicPartition tp = new TopicPartition(topic, partition2);
                this.responses.put(tp, new PartitionResponse(errorCode, offset));
            }
        }
        this.throttleTime = struct.getInt(THROTTLE_TIME_KEY_NAME);
    }

    private void initCommonFields(Map<TopicPartition, PartitionResponse> responses) {
        Map<String, Map<Integer, PartitionResponse>> responseByTopic = CollectionUtils.groupDataByTopic(responses);
        ArrayList<Struct> topicDatas = new ArrayList<Struct>(responseByTopic.size());
        for (Map.Entry<String, Map<Integer, PartitionResponse>> entry2 : responseByTopic.entrySet()) {
            Struct topicData = this.struct.instance(RESPONSES_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)entry2.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionResponse> partitionEntry : entry2.getValue().entrySet()) {
                PartitionResponse part = partitionEntry.getValue();
                Struct partStruct = topicData.instance(PARTITION_RESPONSES_KEY_NAME).set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey()).set(ERROR_CODE_KEY_NAME, (Object)part.errorCode).set(BASE_OFFSET_KEY_NAME, (Object)part.baseOffset);
                partitionArray.add(partStruct);
            }
            topicData.set(PARTITION_RESPONSES_KEY_NAME, (Object)partitionArray.toArray());
            topicDatas.add(topicData);
        }
        this.struct.set(RESPONSES_KEY_NAME, (Object)topicDatas.toArray());
    }

    public Map<TopicPartition, PartitionResponse> responses() {
        return this.responses;
    }

    public int getThrottleTime() {
        return this.throttleTime;
    }

    public static ProduceResponse parse(ByteBuffer buffer) {
        return new ProduceResponse((Struct)CURRENT_SCHEMA.read(buffer));
    }

    public static final class PartitionResponse {
        public short errorCode;
        public long baseOffset;

        public PartitionResponse(short errorCode, long baseOffset) {
            this.errorCode = errorCode;
            this.baseOffset = baseOffset;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append('{');
            b.append("error: ");
            b.append(this.errorCode);
            b.append(",offset: ");
            b.append(this.baseOffset);
            b.append('}');
            return b.toString();
        }
    }
}

