/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.application;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.saml.SAMLBootstrap;
import org.springframework.security.saml.log.SAMLDefaultLogger;
import org.springframework.security.saml.log.SAMLLogger;
import org.springframework.security.saml.metadata.CachingMetadataManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.MetadataGenerator;
import org.springframework.security.saml.metadata.MetadataManager;

@Configuration
@ParametersAreNonnullByDefault
public class SamlServiceConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlServiceConfiguration.class);

    @Nonnull
    @Bean(value={"samlBootstrap"})
    public static SAMLBootstrap samlBootstrap(ConfigurableApplicationContext ctx) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Nonnull
    @Bean(value={"metadataGenerator"})
    public MetadataGenerator metadataGenerator() {
        ExtendedMetadata extendedMetadata = new ExtendedMetadata();
        extendedMetadata.setSignMetadata(false);
        extendedMetadata.setIdpDiscoveryEnabled(false);
        MetadataGenerator metadataGenerator = new MetadataGenerator();
        metadataGenerator.setExtendedMetadata(extendedMetadata);
        return metadataGenerator;
    }

    @Nonnull
    @Bean(value={"metadataManager"})
    public MetadataManager metadataManager() throws MetadataProviderException {
        CachingMetadataManager metadataManager = new CachingMetadataManager((List)Lists.newArrayList());
        metadataManager.setRefreshCheckInterval(0L);
        return metadataManager;
    }

    @Nonnull
    @Bean(value={"samlLogger"})
    public SAMLLogger samlLogger() {
        return new SAMLDefaultLogger();
    }
}

