/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.service;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import de.justsoftware.authentication.model.kafka.KafkaPerson;
import de.justsoftware.authentication.service.JustSAMLUserDetailsService;
import de.justsoftware.authentication.service.JustUsernameNotFoundException;
import de.justsoftware.authentication.service.KafkaPersonService;
import de.justsoftware.onx.security.model.JustConnectUser;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.opensaml.saml2.core.NameID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service(value="justSAMLUserDetailsService")
public class JustSAMLUserDetailsService
implements SAMLUserDetailsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JustSAMLUserDetailsService.class);
    private final KafkaPersonService _kafkaClient;
    private final boolean _useEmailForUserLookup;

    @Autowired
    public JustSAMLUserDetailsService(KafkaPersonService kafkaClient, @Value(value="${sso.useEmailForUserLookup}") boolean useEmailForUserLookup) {
        this._kafkaClient = kafkaClient;
        this._useEmailForUserLookup = useEmailForUserLookup;
    }

    @PostConstruct
    public void logConfig() {
        LOGGER.info("Mapping users by {}", (Object)(this._useEmailForUserLookup ? "email" : "objectGUID"));
    }

    public Object loadUserBySAML(SAMLCredential credential) throws UsernameNotFoundException {
        NameID nameId = credential.getNameID();
        if (nameId == null) {
            throw new UsernameNotFoundException("SAMLCredential came without nameID, can't map user!");
        }
        String nameIdValue = credential.getNameID().getValue();
        if (Strings.isNullOrEmpty((String)nameIdValue)) {
            throw new UsernameNotFoundException("SAMLCredential came with empty nameID, can't map user!");
        }
        MappedKafkaPerson mappedKafkaPerson = this.getPersonByNameId(nameIdValue);
        KafkaPerson kafkaPerson = mappedKafkaPerson.getPerson();
        if (kafkaPerson == null) {
            throw new JustUsernameNotFoundException("SAMLCredential with NameID: " + nameIdValue + " and " + mappedKafkaPerson.keyDescription() + " didn't match to an imported just user.", mappedKafkaPerson.getMappingKey());
        }
        if (kafkaPerson.isDeleted()) {
            throw new JustUsernameNotFoundException("SAMLCredential with NameID: " + nameIdValue + " and " + mappedKafkaPerson.keyDescription() + " is mapped to a deleted just user with id " + kafkaPerson.getId(), mappedKafkaPerson.getMappingKey());
        }
        String email = kafkaPerson.getEmail();
        if (email == null) {
            throw new JustUsernameNotFoundException("SAMLCredential with NameID: " + nameIdValue + " and " + mappedKafkaPerson.keyDescription() + " is mapped to a non-deleted user with no email address, with id " + kafkaPerson.getId(), mappedKafkaPerson.getMappingKey());
        }
        return new JustConnectUser(Long.parseLong(kafkaPerson.getId()), email, "********", kafkaPerson.isActive(), !kafkaPerson.isBlocked(), !kafkaPerson.isDeleted(), kafkaPerson.isActive());
    }

    @Nonnull
    private MappedKafkaPerson getPersonByNameId(String nameId) {
        if (this._useEmailForUserLookup) {
            KafkaPerson person = this._kafkaClient.getKafkaPersonByEmail(nameId);
            return new MappedKafkaPerson(person, nameId, "email");
        }
        byte[] nameIdBytes = nameId.getBytes(Charsets.UTF_8);
        byte[] decodedNameIdBytes = Base64.isBase64((byte[])nameIdBytes) ? Base64.decode((byte[])nameIdBytes) : nameIdBytes;
        String objectGUID = this.decodeObjectGUID(decodedNameIdBytes);
        if (objectGUID == null) {
            throw new UsernameNotFoundException("SAMLCredential with nameID: " + nameId + " is no objectGUID, can't map user!");
        }
        KafkaPerson person = this._kafkaClient.getKafkaPersonByExternalId(objectGUID);
        return new MappedKafkaPerson(person, objectGUID, "objectGUID");
    }

    @CheckForNull
    private String decodeObjectGUID(byte[] objectGUID) {
        return objectGUID.length == 16 ? this.getMaskedHexString(objectGUID[3]) + this.getMaskedHexString(objectGUID[2]) + this.getMaskedHexString(objectGUID[1]) + this.getMaskedHexString(objectGUID[0]) + "-" + this.getMaskedHexString(objectGUID[5]) + this.getMaskedHexString(objectGUID[4]) + "-" + this.getMaskedHexString(objectGUID[7]) + this.getMaskedHexString(objectGUID[6]) + "-" + this.getMaskedHexString(objectGUID[8]) + this.getMaskedHexString(objectGUID[9]) + "-" + this.getMaskedHexString(objectGUID[10]) + this.getMaskedHexString(objectGUID[11]) + this.getMaskedHexString(objectGUID[12]) + this.getMaskedHexString(objectGUID[13]) + this.getMaskedHexString(objectGUID[14]) + this.getMaskedHexString(objectGUID[15]) : null;
    }

    @Nonnull
    private String getMaskedHexString(byte objectGUID) {
        int maskedValue = objectGUID & 0xFF;
        return maskedValue <= 15 ? "0" + Integer.toHexString(maskedValue) : Integer.toHexString(maskedValue);
    }
}

