/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.types;

import com.j256.simplemagic.endian.EndianType;
import com.j256.simplemagic.types.DoubleType;

public class FloatType
extends DoubleType {
    private static final int BYTES_PER_FLOAT = 4;

    public FloatType(EndianType endianType) {
        super(endianType);
    }

    @Override
    public Number decodeValueString(String valueStr) throws NumberFormatException {
        return Float.valueOf(Float.parseFloat(valueStr));
    }

    @Override
    public int compare(boolean unsignedType, Number extractedValue, Number testValue) {
        float testFloat;
        float extractedFloat = extractedValue.floatValue();
        if (extractedFloat > (testFloat = testValue.floatValue())) {
            return 1;
        }
        if (extractedFloat < testFloat) {
            return -1;
        }
        return 0;
    }

    @Override
    protected Object longToObject(Long value) {
        return Float.valueOf(Float.intBitsToFloat(value.intValue()));
    }

    @Override
    public int getBytesPerType() {
        return 4;
    }
}

