/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.NotThreadSafe;
import org.apache.lucene.index.QueryTimeout;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.util.ThreadCpuTimer;

@NotThreadSafe
public class CpuAllowedLimit
implements QueryTimeout {
    private final ThreadCpuTimer threadCpuTimer;
    private final long requestedTimeoutNs;

    public CpuAllowedLimit(SolrQueryRequest req) {
        if (!ThreadCpuTimer.isSupported()) {
            throw new IllegalArgumentException("Thread CPU time monitoring is not available.");
        }
        SolrRequestInfo solrRequestInfo = SolrRequestInfo.getRequestInfo();
        this.threadCpuTimer = solrRequestInfo != null ? solrRequestInfo.getThreadCpuTimer() : new ThreadCpuTimer();
        long reqCpuLimit = req.getParams().getLong("cpuAllowed", -1L);
        if (reqCpuLimit <= 0L) {
            throw new IllegalArgumentException("Check for limit with hasCpuLimit(req) before creating a CpuAllowedLimit");
        }
        this.requestedTimeoutNs = TimeUnit.NANOSECONDS.convert(reqCpuLimit, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    CpuAllowedLimit(long limitMs) {
        this.threadCpuTimer = new ThreadCpuTimer();
        this.requestedTimeoutNs = TimeUnit.NANOSECONDS.convert(limitMs, TimeUnit.MILLISECONDS);
    }

    static boolean hasCpuLimit(SolrQueryRequest req) {
        return req.getParams().getLong("cpuAllowed", -1L) > 0L;
    }

    public boolean shouldExit() {
        return this.threadCpuTimer.getElapsedCpuNs() > this.requestedTimeoutNs;
    }
}

