/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.scheduled;

import de.justsoftware.people.business.profile.BirthdayReminderService;
import de.justsoftware.people.business.usergroup.UserGroupService;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010\f\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/people/scheduled/ScheduledJobs;", "", "userGroupService", "Lde/justsoftware/people/business/usergroup/UserGroupService;", "notYetImportedOlderThan", "Ljava/time/Duration;", "birthdayReminderService", "Lde/justsoftware/people/business/profile/BirthdayReminderService;", "<init>", "(Lde/justsoftware/people/business/usergroup/UserGroupService;Ljava/time/Duration;Lde/justsoftware/people/business/profile/BirthdayReminderService;)V", "cleanupNotYetImportedGroups", "", "sendBirthdayNotifications", "people-api"})
public class ScheduledJobs {
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final Duration notYetImportedOlderThan;
    @NotNull
    private final BirthdayReminderService birthdayReminderService;

    public ScheduledJobs(@NotNull UserGroupService userGroupService, @Value(value="${just.people.scheduled.cleanup.notYetImported.olderThan:P7D}") @NotNull Duration notYetImportedOlderThan, @NotNull BirthdayReminderService birthdayReminderService) {
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)notYetImportedOlderThan, (String)"notYetImportedOlderThan");
        Intrinsics.checkNotNullParameter((Object)birthdayReminderService, (String)"birthdayReminderService");
        this.userGroupService = userGroupService;
        this.notYetImportedOlderThan = notYetImportedOlderThan;
        this.birthdayReminderService = birthdayReminderService;
    }

    @Scheduled(fixedRateString="${just.people.scheduled.cleanup.notYetImported.interval:P1D}")
    public void cleanupNotYetImportedGroups() {
        this.userGroupService.deleteOldNotYetImportedGroups(this.notYetImportedOlderThan);
    }

    @Scheduled(cron="0 30 0 * * ?")
    public void sendBirthdayNotifications() {
        this.birthdayReminderService.sendBirthdayNotifications();
    }
}

