/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.application;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.people.application.ProfileApplicationService;
import de.justsoftware.people.application.model.AbsenceInformation;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.business.profile.ProfileService;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.utils.CollectionUtilsKt;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.Role;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J \u0010\u0010\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J*\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/justsoftware/people/application/ProfileApplicationService;", "", "profileService", "Lde/justsoftware/people/business/profile/ProfileService;", "<init>", "(Lde/justsoftware/people/business/profile/ProfileService;)V", "saveBirthdayReminderForProfile", "", "authCtx", "Lde/justsoftware/people/authorization/AuthorizationContext;", "reminderProfileId", "Lde/justsoftware/people/model/ProfileId;", "deleteBirthdayReminderForProfile", "getAbsenceInformation", "Lde/justsoftware/people/application/model/AbsenceInformation;", "profileId", "changeAbsenceInformation", "absenceInformation", "", "profileIds", "", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nProfileApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileApplicationService.kt\nde/justsoftware/people/application/ProfileApplicationService\n+ 2 CollectionUtils.kt\nde/justsoftware/people/utils/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n17#2:74\n23#2:78\n1628#3,3:75\n1619#3:79\n1863#3:80\n1864#3:82\n1620#3:83\n1#4:81\n*S KotlinDebug\n*F\n+ 1 ProfileApplicationService.kt\nde/justsoftware/people/application/ProfileApplicationService\n*L\n54#1:74\n55#1:78\n54#1:75,3\n55#1:79\n55#1:80\n55#1:82\n55#1:83\n55#1:81\n*E\n"})
public class ProfileApplicationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfileService profileService;

    public ProfileApplicationService(@NotNull ProfileService profileService) {
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        this.profileService = profileService;
    }

    public void saveBirthdayReminderForProfile(@NotNull AuthorizationContext authCtx, @NotNull ProfileId reminderProfileId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)reminderProfileId, (String)"reminderProfileId");
        authCtx.check(Role.read((String)reminderProfileId.toString()));
        ProfileId profileId = authCtx.getProfileId();
        Intrinsics.checkNotNullExpressionValue((Object)profileId, (String)"getProfileId(...)");
        this.profileService.saveBirthdayReminder(profileId, reminderProfileId);
    }

    public void deleteBirthdayReminderForProfile(@NotNull AuthorizationContext authCtx, @NotNull ProfileId reminderProfileId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)reminderProfileId, (String)"reminderProfileId");
        authCtx.check(Role.read((String)reminderProfileId.toString()));
        ProfileId profileId = authCtx.getProfileId();
        Intrinsics.checkNotNullExpressionValue((Object)profileId, (String)"getProfileId(...)");
        this.profileService.deleteBirthdayReminder(profileId, reminderProfileId);
    }

    @NotNull
    public AbsenceInformation getAbsenceInformation(@NotNull AuthorizationContext authCtx, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        authCtx.check(Role.read((String)profileId.toString()));
        return this.profileService.getAbsenceInformation(profileId);
    }

    @NotNull
    public AbsenceInformation changeAbsenceInformation(@NotNull AuthorizationContext authCtx, @NotNull ProfileId profileId, @NotNull AbsenceInformation absenceInformation) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)absenceInformation, (String)"absenceInformation");
        if (!Intrinsics.areEqual((Object)profileId, (Object)authCtx.getProfileId())) {
            authCtx.check(Role.manage((String)profileId.toString()));
        }
        if (!(absenceInformation.getAbsenceNote() == null || absenceInformation.getAbsenceNote().length() <= 50)) {
            boolean bl = false;
            String string = "Absence information must be between 0 and 50 characters";
            throw new IllegalArgumentException(string.toString());
        }
        return this.profileService.changeAbsenceInformation(profileId, absenceInformation);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, AbsenceInformation> getAbsenceInformation(@NotNull AuthorizationContext authCtx, @NotNull Set<ProfileId> profileIds) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable iterable = profileIds;
        AuthorizationContext authorizationContext = authCtx;
        boolean $i$f$mapToSet = false;
        void var7_6 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void profileId;
            object = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.read((String)profileId.toString()));
        }
        ImmutableMap immutableMap = authorizationContext.has((Set)destination$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"has(...)");
        ImmutableMap authorizedProfileIds = immutableMap;
        Set set = authorizedProfileIds.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-entries>(...)");
        Iterable $this$mapNotNullToSet$iv = set;
        boolean $i$f$mapNotNullToSet = false;
        $this$mapTo$iv$iv = $this$mapNotNullToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            ProfileId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)entry);
            Role role = (Role)entry.getKey();
            AuthorizationResult result = (AuthorizationResult)entry.getValue();
            if ((result == AuthorizationResult.OK ? Companion.access$parseRole((Companion)Companion, (Role)role) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set filteredProfileIds = (Set)destination$iv$iv;
        return this.profileService.getAbsenceInformationForProfiles(filteredProfileIds);
    }
}

