/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.controller;

import de.justsoftware.notificationservice.business.MobilePushTokenService;
import de.justsoftware.notificationservice.model.MobilePlatform;
import de.justsoftware.notificationservice.model.MobilePushToken;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import de.justsoftware.notificationservice.util.ControllerUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.LocaleResolver;

@RestController
@RequestMapping(value={"/api/mobilepush"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0017J0\u0010\u000e\u001a\u00020\b2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0017J\u001c\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\nH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/notificationservice/controller/MobilePushController;", "", "mobilePushTokenService", "Lde/justsoftware/notificationservice/business/MobilePushTokenService;", "localeResolver", "Lorg/springframework/web/servlet/LocaleResolver;", "(Lde/justsoftware/notificationservice/business/MobilePushTokenService;Lorg/springframework/web/servlet/LocaleResolver;)V", "registerAndroid", "Lde/justsoftware/notificationservice/model/MobilePushToken;", "publicKey", "", "pushToken", "request", "Ljakarta/servlet/http/HttpServletRequest;", "registerIos", "silenceAlerts", "", "unregister", "", "platform", "notification-service"})
public class MobilePushController {
    @NotNull
    private final MobilePushTokenService mobilePushTokenService;
    @NotNull
    private final LocaleResolver localeResolver;

    public MobilePushController(@NotNull MobilePushTokenService mobilePushTokenService, @NotNull LocaleResolver localeResolver) {
        Intrinsics.checkNotNullParameter((Object)mobilePushTokenService, (String)"mobilePushTokenService");
        Intrinsics.checkNotNullParameter((Object)localeResolver, (String)"localeResolver");
        this.mobilePushTokenService = mobilePushTokenService;
        this.localeResolver = localeResolver;
    }

    @PostMapping(value={"/android"})
    @NotNull
    public MobilePushToken registerAndroid(@RequestParam(value="publicKey") @Nullable String publicKey, @RequestBody @NotNull String pushToken, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        char[] cArray = new char[]{'\"'};
        String string = StringsKt.trim((String)pushToken, (char[])cArray);
        ProfileId profileId = ControllerUtil.INSTANCE.getCurrentProfileId();
        Locale locale = this.localeResolver.resolveLocale(request);
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"resolveLocale(...)");
        return MobilePushTokenService.registerPushToken$default((MobilePushTokenService)this.mobilePushTokenService, (String)string, (MobilePlatform)MobilePlatform.ANDROID, (String)publicKey, (ProfileId)profileId, (Locale)locale, (boolean)false, (int)32, null);
    }

    @PostMapping(value={"/ios"})
    @NotNull
    public MobilePushToken registerIos(@RequestParam(value="publicKey") @Nullable String publicKey, @RequestParam(value="silenceAlerts", defaultValue="false") boolean silenceAlerts, @RequestBody @NotNull String pushToken, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        char[] cArray = new char[]{'\"'};
        String string = StringsKt.trim((String)pushToken, (char[])cArray);
        ProfileId profileId = ControllerUtil.INSTANCE.getCurrentProfileId();
        Locale locale = this.localeResolver.resolveLocale(request);
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"resolveLocale(...)");
        return this.mobilePushTokenService.registerPushToken(string, MobilePlatform.IOS, publicKey, profileId, locale, silenceAlerts);
    }

    @DeleteMapping(value={"/{platform:android|ios}/{pushToken}"})
    public void unregister(@PathVariable(value="platform") @NotNull String platform, @PathVariable(value="pushToken") @NotNull String pushToken) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        this.mobilePushTokenService.unregisterPushToken(pushToken, MobilePlatform.Companion.toMobilePlatform(platform), ControllerUtil.INSTANCE.getCurrentProfileId());
    }
}

