/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.search;

import de.justsoftware.permission.client.model.Role;
import de.justsoftware.search.shared.DefaultSolrIndexDataLoader;
import de.justsoftware.search.shared.LoaderContext;
import de.justsoftware.search.shared.SolrIndexQueue;
import de.justsoftware.search.shared.model.JustApp;
import de.justsoftware.search.shared.model.JustSocialFullUpdateSolrDocument;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.search.shared.model.SearchableId;
import de.justsoftware.search.shared.model.TenantId;
import de.justsoftware.wikiservice.application.model.ArticleDto;
import de.justsoftware.wikiservice.application.model.ChapterDto;
import de.justsoftware.wikiservice.application.model.WikiDto;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.exceptions.ArticleVersionNotFoundException;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.PermissionRepository;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.persistence.model.ArticleVersion;
import de.justsoftware.wikiservice.persistence.model.Permission;
import de.justsoftware.wikiservice.persistence.model.Wiki;
import de.justsoftware.wikiservice.search.WikiSolrIndexDataLoader;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 &2\u00020\u0001:\u0001&BK\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0001\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J,\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0017J \u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160$2\u0006\u0010%\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/justsoftware/wikiservice/search/WikiSolrIndexDataLoader;", "Lde/justsoftware/search/shared/DefaultSolrIndexDataLoader;", "justVersion", "", "solrIndexQueue", "Lde/justsoftware/search/shared/SolrIndexQueue;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "permissionRepository", "Lde/justsoftware/wikiservice/persistence/PermissionRepository;", "clock", "Ljava/time/Clock;", "maxEditingTokenDuration", "", "<init>", "(Ljava/lang/String;Lde/justsoftware/search/shared/SolrIndexQueue;Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/persistence/PermissionRepository;Ljava/time/Clock;J)V", "loadFullData", "", "Lde/justsoftware/search/shared/model/SearchableId;", "Lde/justsoftware/search/shared/model/JustSocialFullUpdateSolrDocument;", "ids", "", "context", "Lde/justsoftware/search/shared/LoaderContext;", "handleReindexForTypes", "", "types", "", "Lde/justsoftware/search/shared/model/SearchType;", "tenantId", "Lde/justsoftware/search/shared/model/TenantId;", "getAllSearchableIdForType", "Ljava/util/stream/Stream;", "type", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nWikiSolrIndexDataLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiSolrIndexDataLoader.kt\nde/justsoftware/wikiservice/search/WikiSolrIndexDataLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,151:1\n1557#2:152\n1628#2,3:153\n1246#2,4:158\n1246#2,4:164\n1246#2,4:170\n1246#2,4:176\n1246#2,2:182\n1557#2:184\n1628#2,3:185\n1249#2:188\n1557#2:189\n1628#2,3:190\n1557#2:193\n1628#2,3:194\n1557#2:197\n1628#2,3:198\n1202#2,2:201\n1230#2,4:203\n1279#2,2:207\n1293#2,4:209\n462#3:156\n412#3:157\n462#3:162\n412#3:163\n462#3:168\n412#3:169\n462#3:174\n412#3:175\n462#3:180\n412#3:181\n*S KotlinDebug\n*F\n+ 1 WikiSolrIndexDataLoader.kt\nde/justsoftware/wikiservice/search/WikiSolrIndexDataLoader\n*L\n50#1:152\n50#1:153,3\n61#1:158,4\n68#1:164,4\n70#1:170,4\n71#1:176,4\n76#1:182,2\n79#1:184\n79#1:185,3\n76#1:188\n84#1:189\n84#1:190,3\n85#1:193\n85#1:194,3\n86#1:197\n86#1:198,3\n87#1:201,2\n87#1:203,4\n89#1:207,2\n89#1:209,4\n61#1:156\n61#1:157\n68#1:162\n68#1:163\n70#1:168\n70#1:169\n71#1:174\n71#1:175\n76#1:180\n76#1:181\n*E\n"})
public class WikiSolrIndexDataLoader
extends DefaultSolrIndexDataLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String justVersion;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final PermissionRepository permissionRepository;
    @NotNull
    private final Clock clock;
    private final long maxEditingTokenDuration;

    public WikiSolrIndexDataLoader(@Value(value="${just.version}") @NotNull String justVersion, @NotNull SolrIndexQueue solrIndexQueue, @NotNull WikiService wikiService, @NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull PermissionRepository permissionRepository, @NotNull Clock clock, @Value(value="${service.maxArticleEditingTokenDurationSec:28800}") long maxEditingTokenDuration) {
        Intrinsics.checkNotNullParameter((Object)justVersion, (String)"justVersion");
        Intrinsics.checkNotNullParameter((Object)solrIndexQueue, (String)"solrIndexQueue");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)permissionRepository, (String)"permissionRepository");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        super(JustApp.WIKI, justVersion, solrIndexQueue);
        this.justVersion = justVersion;
        this.wikiService = wikiService;
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.permissionRepository = permissionRepository;
        this.clock = clock;
        this.maxEditingTokenDuration = maxEditingTokenDuration;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<SearchableId, JustSocialFullUpdateSolrDocument> loadFullData(@NotNull List<SearchableId> ids, @NotNull LoaderContext context) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Iterable $this$mapTo$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map.Entry it$iv$iv;
        Map $this$mapValuesTo$iv$iv2;
        Map $this$mapValues$iv;
        Map wikis;
        void $this$mapValuesTo$iv$iv3;
        void $this$mapValues$iv2;
        Object object;
        Object v;
        Object object2;
        Object object3;
        Map $this$mapValuesTo$iv$iv4;
        void $this$mapValues$iv3;
        void it;
        Object object4;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$map$iv = ids;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            SearchableId searchableId = (SearchableId)item$iv$iv;
            object4 = destination$iv$iv;
            boolean bl = false;
            object4.add(IdUtilsKt.toAbstractId((SearchableId)it));
        }
        List abstractIds = (List)destination$iv$iv;
        Set wikiIds = CollectionsKt.toSet((Iterable)CollectionsKt.filterIsInstance((Iterable)abstractIds, WikiId.class));
        Set chapterIds = CollectionsKt.toSet((Iterable)CollectionsKt.filterIsInstance((Iterable)abstractIds, ChapterId.class));
        Set articleIds = CollectionsKt.toSet((Iterable)CollectionsKt.filterIsInstance((Iterable)abstractIds, ArticleId.class));
        if (wikiIds.isEmpty() && chapterIds.isEmpty() && articleIds.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map articleVersions = this.articleService.getLatestArticleVersions(articleIds);
        Map map = this.articleService.readByIds(articleIds);
        boolean $i$f$mapValues = false;
        it = $this$mapValues$iv3;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv3.size()));
        boolean $i$f$mapValuesTo22 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv4.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            ArticleVersion version;
            Iterator it$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl = false;
            object3 = (Map.Entry)element$iv$iv$iv;
            object2 = it$iv$iv2.getKey();
            object4 = map2;
            boolean bl2 = false;
            v = (Article)object3.getValue();
            if ((ArticleVersion)articleVersions.get(v.getId()) == null) {
                throw new ArticleVersionNotFoundException(null, 1, null);
            }
            object = ArticleDto.Companion.toDto(v, version, this.clock, this.maxEditingTokenDuration);
            object4.put(object2, object);
        }
        Map articles = destination$iv$iv2;
        Map chapters = this.chapterService.readByIds(chapterIds);
        $this$mapValuesTo$iv$iv4 = this.wikiService.readByIds(wikiIds);
        boolean $i$f$mapValues22 = false;
        void $i$f$mapValuesTo22 = $this$mapValues$iv2;
        Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv3.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            void it2;
            void it$iv$iv3;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            object3 = destination$iv$iv3;
            boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = false;
            v = (Map.Entry)element$iv$iv$iv;
            object2 = it$iv$iv3.getKey();
            object4 = object3;
            boolean bl3 = false;
            object = WikiDto.Companion.toDto((Wiki)it2.getValue());
            object4.put(object2, object);
        }
        Map $i$f$mapValues22 = wikis = destination$iv$iv3;
        boolean $i$f$mapValues3 = false;
        destination$iv$iv3 = $this$mapValues$iv;
        Map destination$iv$iv4 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo3 = false;
        Iterable $this$associateByTo$iv$iv$iv3 = $this$mapValuesTo$iv$iv2.entrySet();
        boolean $i$f$associateByTo3 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv3) {
            void it3;
            object3 = (Map.Entry)element$iv$iv$iv;
            Map $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = destination$iv$iv4;
            boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv3 = false;
            Map.Entry bl3 = (Map.Entry)element$iv$iv$iv;
            object2 = it$iv$iv.getKey();
            object4 = $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2;
            boolean bl = false;
            object = new TenantId(((WikiDto)it3.getValue()).getTenantId().getId());
            object4.put(object2, object);
        }
        $this$mapValues$iv = destination$iv$iv4;
        $i$f$mapValues3 = false;
        $this$mapValuesTo$iv$iv2 = $this$mapValues$iv;
        destination$iv$iv4 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        $i$f$mapValuesTo3 = false;
        $this$associateByTo$iv$iv$iv3 = $this$mapValuesTo$iv$iv2.entrySet();
        $i$f$associateByTo3 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv3) {
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = destination$iv$iv4;
            boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv4 = false;
            Map.Entry it3 = (Map.Entry)element$iv$iv$iv;
            object2 = it$iv$iv.getKey();
            object4 = $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2;
            boolean bl = false;
            object = Role.manager((String)((TenantId)it3.getValue()).toCanonicalId());
            object4.put(object2, object);
        }
        Map wikiTenantManagers = destination$iv$iv4;
        Map wikiPermissions = this.permissionRepository.findAllByWikiIds(wikiIds);
        Map $this$mapValues$iv4 = wikis;
        boolean $i$f$mapValues4 = false;
        Map $i$f$mapValuesTo32 = $this$mapValues$iv4;
        Object destination$iv$iv5 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv4.size()));
        boolean $i$f$mapValuesTo4 = false;
        Iterable $this$associateByTo$iv$iv$iv4 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo4 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv4) {
            void $this$mapTo$iv$iv3;
            void $this$map$iv2;
            void entry;
            void it$iv$iv4;
            Map.Entry $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv4 = (Map.Entry)element$iv$iv$iv;
            Map it4 = destination$iv$iv5;
            boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv5 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object2 = it$iv$iv4.getKey();
            object4 = it4;
            boolean bl = false;
            Object[] objectArray = (Object[])wikiPermissions.getOrDefault(entry.getKey(), CollectionsKt.emptyList());
            boolean $i$f$map2 = false;
            void var30_86 = $this$map$iv2;
            Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void permission;
                Permission permission2 = (Permission)item$iv$iv;
                Collection collection = destination$iv$iv6;
                boolean bl4 = false;
                collection.add(permission.getGranteeId().toRole());
            }
            Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv6));
            objectArray = new Role[2];
            objectArray[0] = Role.SUPERADMIN;
            Intrinsics.checkNotNull(wikiTenantManagers.get(entry.getKey()));
            object = SetsKt.plus((Set)set, (Iterable)SetsKt.setOf((Object[])objectArray));
            object4.put(object2, object);
        }
        Map wikisVisibleFor = destination$iv$iv5;
        Iterable $this$map$iv3 = wikis.values();
        boolean $i$f$map3 = false;
        destination$iv$iv5 = $this$map$iv3;
        Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it5;
            WikiDto element$iv$iv$iv = (WikiDto)item$iv$iv;
            object4 = destination$iv$iv7;
            boolean bl = false;
            Object v2 = wikisVisibleFor.get(it5.getId());
            Intrinsics.checkNotNull(v2);
            object4.add(Companion.access$toSolrDocument((Companion)Companion, (WikiDto)it5, (Set)((Set)v2)));
        }
        $this$map$iv3 = chapters.values();
        object4 = (List)destination$iv$iv7;
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv3;
        destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChapterDto it5 = (ChapterDto)item$iv$iv;
            object2 = destination$iv$iv7;
            boolean bl = false;
            object2.add((JustSocialFullUpdateSolrDocument)Companion.access$toSolrDocument((Companion)Companion, (ChapterDto)it5));
        }
        $this$map$iv3 = articles.values();
        object4 = CollectionsKt.plus((Collection)object4, (Iterable)((List)destination$iv$iv7));
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv3;
        destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ArticleDto it6 = (ArticleDto)item$iv$iv;
            object2 = destination$iv$iv7;
            boolean bl = false;
            object2.add(Companion.access$toSolrDocument((Companion)Companion, (ArticleDto)it6));
        }
        $this$map$iv3 = CollectionsKt.plus((Collection)object4, (Iterable)((List)destination$iv$iv7));
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv7 = $this$associateBy$iv;
        Map destination$iv$iv8 = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            void it7;
            JustSocialFullUpdateSolrDocument bl = (JustSocialFullUpdateSolrDocument)element$iv$iv2;
            object4 = destination$iv$iv8;
            boolean bl5 = false;
            object4.put(it7.getId(), element$iv$iv2);
        }
        Map documents = destination$iv$iv8;
        Iterable $this$associateWith$iv = ids;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void id;
            SearchableId element$iv$iv2 = (SearchableId)element$iv$iv;
            object2 = element$iv$iv;
            object4 = result$iv;
            boolean bl = false;
            object = (JustSocialFullUpdateSolrDocument)documents.get(id);
            object4.put(object2, object);
        }
        return result$iv;
    }

    @Transactional(readOnly=true)
    public void handleReindexForTypes(@NotNull Set<? extends SearchType> types, @Nullable TenantId tenantId) {
        Intrinsics.checkNotNullParameter(types, (String)"types");
        super.handleReindexForTypes(types, tenantId);
    }

    @NotNull
    protected Stream<SearchableId> getAllSearchableIdForType(@NotNull SearchType type, @Nullable TenantId tenantId) {
        Stream<SearchableId> stream;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Stream<SearchableId> stream2 = this.wikiService.streamAllIds().map(arg_0 -> WikiSolrIndexDataLoader.getAllSearchableIdForType$lambda$13(WikiSolrIndexDataLoader::getAllSearchableIdForType$lambda$12, arg_0));
                stream = stream2;
                Intrinsics.checkNotNullExpressionValue(stream2, (String)"map(...)");
                break;
            }
            case 2: {
                Stream<SearchableId> stream3 = this.chapterService.streamAllIds().map(arg_0 -> WikiSolrIndexDataLoader.getAllSearchableIdForType$lambda$15(WikiSolrIndexDataLoader::getAllSearchableIdForType$lambda$14, arg_0));
                stream = stream3;
                Intrinsics.checkNotNullExpressionValue(stream3, (String)"map(...)");
                break;
            }
            case 3: {
                Stream<SearchableId> stream4 = this.articleService.streamAllIds().map(arg_0 -> WikiSolrIndexDataLoader.getAllSearchableIdForType$lambda$17(WikiSolrIndexDataLoader::getAllSearchableIdForType$lambda$16, arg_0));
                stream = stream4;
                Intrinsics.checkNotNullExpressionValue(stream4, (String)"map(...)");
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported searchType " + type + " for " + this.handlerTypes()).toString());
            }
        }
        return stream;
    }

    private static final SearchableId getAllSearchableIdForType$lambda$12(WikiId it) {
        Intrinsics.checkNotNull((Object)it);
        return IdUtilsKt.toSearchableId((AbstractId)((AbstractId)it));
    }

    private static final SearchableId getAllSearchableIdForType$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SearchableId)$tmp0.invoke(p0);
    }

    private static final SearchableId getAllSearchableIdForType$lambda$14(ChapterId it) {
        Intrinsics.checkNotNull((Object)it);
        return IdUtilsKt.toSearchableId((AbstractId)((AbstractId)it));
    }

    private static final SearchableId getAllSearchableIdForType$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SearchableId)$tmp0.invoke(p0);
    }

    private static final SearchableId getAllSearchableIdForType$lambda$16(ArticleId it) {
        Intrinsics.checkNotNull((Object)it);
        return IdUtilsKt.toSearchableId((AbstractId)((AbstractId)it));
    }

    private static final SearchableId getAllSearchableIdForType$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SearchableId)$tmp0.invoke(p0);
    }
}

