/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.search;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import de.justsoftware.wikiservice.application.model.ArticleDto;
import de.justsoftware.wikiservice.application.model.ChapterDto;
import de.justsoftware.wikiservice.application.model.WikiDto;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.exceptions.ArticleVersionNotFoundException;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.persistence.model.ArticleVersion;
import de.justsoftware.wikiservice.persistence.model.SolrArticleExport;
import de.justsoftware.wikiservice.persistence.model.Wiki;
import de.justsoftware.wikiservice.search.SolrService;
import de.justsoftware.wikiservice.search.update.UpdateSearchIndexProducer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.SolrParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 O2\u00020\u0001:\u0001OBg\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0001\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0001\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0001\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020,H\u0016J\b\u0010.\u001a\u00020,H\u0016J\b\u0010/\u001a\u00020,H\u0016J6\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u00103\u001a\u0002042\n\b\u0002\u00105\u001a\u0004\u0018\u0001062\b\b\u0002\u00107\u001a\u00020\u00132\b\b\u0002\u00108\u001a\u00020\u0013H\u0016J\u001e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0012J\u001e\u0010@\u001a\u00020:2\u0006\u0010A\u001a\u00020B2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0012J\u001e\u0010C\u001a\u00020:2\u0006\u0010D\u001a\u00020E2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0012J\u0016\u0010F\u001a\u00020,2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020:01H\u0012J\u0016\u0010H\u001a\u00020,2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020:01H\u0012J\u0016\u0010J\u001a\u00020,2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001f01H\u0012J\u0016\u0010L\u001a\u00020,2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001f01H\u0012J\u0016\u0010M\u001a\u00020,2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020N01H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0092D\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0092D\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001fX\u0092D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\"\u001a\u00020#8\u0010X\u0091\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u001c\u0010(\u001a\u00020#8\u0010X\u0091\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b)\u0010%\u001a\u0004\b*\u0010'\u00a8\u0006P"}, d2={"Lde/justsoftware/wikiservice/search/SolrService;", "", "solrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/PermissionRequestConnector;", "updateSearchIndexProducer", "Lde/justsoftware/wikiservice/search/update/UpdateSearchIndexProducer;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "useSoftCommit", "", "commitWithinInMs", "", "clock", "Ljava/time/Clock;", "maxEditingTokenDuration", "", "<init>", "(Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/permission/client/rest/PermissionRequestConnector;Lde/justsoftware/wikiservice/search/update/UpdateSearchIndexProducer;Lio/micrometer/core/instrument/MeterRegistry;ZILjava/time/Clock;J)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "wikiType", "", "chapterType", "articleType", "successfulIndexedDocumentCount", "Ljava/util/concurrent/atomic/AtomicLong;", "getSuccessfulIndexedDocumentCount$wiki_service$annotations", "()V", "getSuccessfulIndexedDocumentCount$wiki_service", "()Ljava/util/concurrent/atomic/AtomicLong;", "failedIndexedDocumentCount", "getFailedIndexedDocumentCount$wiki_service$annotations", "getFailedIndexedDocumentCount$wiki_service", "reindexAll", "", "reindexWikis", "reindexChapters", "reindexArticles", "exportArticles", "", "Lde/justsoftware/wikiservice/persistence/model/SolrArticleExport;", "userId", "Lde/justsoftware/wikiservice/model/ProfileId;", "modifiedAfter", "Ljava/time/Instant;", "offset", "limit", "createWikiSolrDocument", "Lorg/apache/solr/common/SolrInputDocument;", "wiki", "Lde/justsoftware/wikiservice/application/model/WikiDto;", "visibleForRoles", "", "Lde/justsoftware/permission/client/model/Role;", "createChapterSolrDocument", "chapter", "Lde/justsoftware/wikiservice/application/model/ChapterDto;", "createArticleSolrDocument", "article", "Lde/justsoftware/wikiservice/application/model/ArticleDto;", "addSolrDocuments", "inputDocuments", "addSolrDocumentsSingly", "solrDocuments", "deleteSolrDocuments", "ids", "deleteSolrDocumentsSingly", "index", "Lde/justsoftware/wikiservice/model/AbstractId;", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nSolrService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolrService.kt\nde/justsoftware/wikiservice/search/SolrService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 LoggerUtils.kt\nde/justsoftware/wikiservice/util/LoggerUtilsKt\n*L\n1#1,315:1\n1557#2:316\n1628#2,3:317\n1557#2:320\n1628#2,3:321\n1557#2:324\n1628#2,3:325\n1863#2,2:328\n1863#2,2:330\n808#2,11:332\n808#2,11:343\n808#2,11:354\n1246#2,4:367\n1557#2:371\n1628#2,3:372\n1557#2:375\n1628#2,3:376\n1246#2,4:381\n1557#2:385\n1628#2,3:386\n1557#2:389\n1628#2,3:390\n1557#2:393\n1628#2,3:394\n1557#2:397\n1628#2,3:398\n1557#2:401\n1628#2,3:402\n462#3:365\n412#3:366\n462#3:379\n412#3:380\n8#4:405\n7#4,3:406\n*S KotlinDebug\n*F\n+ 1 SolrService.kt\nde/justsoftware/wikiservice/search/SolrService\n*L\n151#1:316\n151#1:317,3\n164#1:320\n164#1:321,3\n179#1:324\n179#1:325,3\n207#1:328,2\n248#1:330,2\n266#1:332,11\n267#1:343,11\n268#1:354,11\n276#1:367,4\n285#1:371\n285#1:372,3\n286#1:375\n286#1:376,3\n288#1:381,4\n291#1:385\n291#1:386,3\n294#1:389\n294#1:390,3\n297#1:393\n297#1:394,3\n299#1:397\n299#1:398,3\n301#1:401\n301#1:402,3\n276#1:365\n276#1:366\n288#1:379\n288#1:380\n312#1:405\n312#1:406,3\n*E\n"})
public class SolrService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SolrClient solrClient;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final PermissionRequestConnector permissionRequestConnector;
    @NotNull
    private final UpdateSearchIndexProducer updateSearchIndexProducer;
    private final boolean useSoftCommit;
    private final int commitWithinInMs;
    @NotNull
    private final Clock clock;
    private final long maxEditingTokenDuration;
    private final Logger logger;
    @NotNull
    private final String wikiType;
    @NotNull
    private final String chapterType;
    @NotNull
    private final String articleType;
    @NotNull
    private final AtomicLong successfulIndexedDocumentCount;
    @NotNull
    private final AtomicLong failedIndexedDocumentCount;
    @NotNull
    private static final Logger LOG;

    @Autowired
    public SolrService(@NotNull SolrClient solrClient, @NotNull WikiService wikiService, @NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull PermissionRequestConnector permissionRequestConnector, @NotNull UpdateSearchIndexProducer updateSearchIndexProducer, @NotNull MeterRegistry meterRegistry, @Value(value="${just.search.useSoftCommit:true}") boolean useSoftCommit, @Value(value="${just.search.commitWithinInMs:1000}") int commitWithinInMs, @NotNull Clock clock, @Value(value="${service.maxArticleEditingTokenDurationSec:28800}") long maxEditingTokenDuration) {
        Intrinsics.checkNotNullParameter((Object)solrClient, (String)"solrClient");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        Intrinsics.checkNotNullParameter((Object)updateSearchIndexProducer, (String)"updateSearchIndexProducer");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.solrClient = solrClient;
        this.wikiService = wikiService;
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.permissionRequestConnector = permissionRequestConnector;
        this.updateSearchIndexProducer = updateSearchIndexProducer;
        this.useSoftCommit = useSoftCommit;
        this.commitWithinInMs = commitWithinInMs;
        this.clock = clock;
        this.maxEditingTokenDuration = maxEditingTokenDuration;
        this.logger = LoggerFactory.getLogger(SolrService.class);
        this.wikiType = "WIKI_WIKI";
        this.chapterType = "WIKI_CHAPTER";
        this.articleType = "WIKI_ARTICLE";
        this.successfulIndexedDocumentCount = new AtomicLong(0L);
        this.failedIndexedDocumentCount = new AtomicLong(0L);
        Gauge.builder((String)"wiki.search.index.successfulIndexedDocuments", () -> SolrService._init_$lambda$0(this)).description("Count of successfully indexed documents").baseUnit("Document").register(meterRegistry);
        Gauge.builder((String)"wiki.search.index.failedIndexedDocuments", () -> SolrService._init_$lambda$1(this)).description("Count of failed indexed documents").baseUnit("Document").register(meterRegistry);
    }

    @NotNull
    public AtomicLong getSuccessfulIndexedDocumentCount$wiki_service() {
        return this.successfulIndexedDocumentCount;
    }

    @VisibleForTesting
    public static /* synthetic */ void getSuccessfulIndexedDocumentCount$wiki_service$annotations() {
    }

    @NotNull
    public AtomicLong getFailedIndexedDocumentCount$wiki_service() {
        return this.failedIndexedDocumentCount;
    }

    @VisibleForTesting
    public static /* synthetic */ void getFailedIndexedDocumentCount$wiki_service$annotations() {
    }

    public void reindexAll() {
        this.solrClient.deleteByQuery("just_app_id:WIKI");
        this.reindexWikis();
        this.reindexChapters();
        this.reindexArticles();
    }

    public void reindexWikis() {
        this.solrClient.deleteByQuery("type:" + this.wikiType);
        this.updateSearchIndexProducer.reindex(this.wikiService.readAllIds());
    }

    public void reindexChapters() {
        this.solrClient.deleteByQuery("type:" + this.chapterType);
        this.updateSearchIndexProducer.reindex(this.chapterService.readAllIds());
    }

    public void reindexArticles() {
        this.solrClient.deleteByQuery("type:" + this.articleType);
        this.updateSearchIndexProducer.reindex(this.articleService.readAllIds());
    }

    @NotNull
    public List<SolrArticleExport> exportArticles(@NotNull ProfileId userId, @Nullable Instant modifiedAfter, int offset, int limit) {
        QueryResponse queryResponse;
        SolrQuery solrQuery;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        SolrQuery $this$exportArticles_u24lambda_u242 = solrQuery = new SolrQuery();
        boolean bl = false;
        String[] stringArray = new String[]{"modify_date ASC"};
        $this$exportArticles_u24lambda_u242.add("sort", stringArray);
        stringArray = new String[]{String.valueOf(offset)};
        $this$exportArticles_u24lambda_u242.set("start", stringArray);
        stringArray = new String[]{String.valueOf(limit)};
        $this$exportArticles_u24lambda_u242.set("rows", stringArray);
        stringArray = new String[]{"id name modify_date content parent_ids"};
        $this$exportArticles_u24lambda_u242.set("fl", stringArray);
        stringArray = new String[]{"type:WIKI_ARTICLE"};
        $this$exportArticles_u24lambda_u242.addFilterQuery(stringArray);
        if (modifiedAfter != null) {
            stringArray = new String[]{"modify_date:{" + modifiedAfter + " TO *]"};
            $this$exportArticles_u24lambda_u242.addFilterQuery(stringArray);
        }
        ImmutableSet immutableSet = this.permissionRequestConnector.searchRoles(userId.toRole());
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"searchRoles(...)");
        String searchRoles = CollectionsKt.joinToString$default((Iterable)((Iterable)immutableSet), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        String[] stringArray2 = new String[]{searchRoles};
        $this$exportArticles_u24lambda_u242.add("justRoles", stringArray2);
        stringArray2 = new String[]{"{!edismax q.op=OR qf=visible_for_roles mm=1 v=$justRoles}"};
        $this$exportArticles_u24lambda_u242.addFilterQuery(stringArray2);
        $this$exportArticles_u24lambda_u242.setRequestHandler("jucoSearch");
        SolrQuery query = solrQuery;
        try {
            queryResponse = this.solrClient.query((SolrParams)query, SolrRequest.METHOD.POST);
        }
        catch (Exception e) {
            LOG.error("Error occurred while executing query " + query, (Throwable)e);
            throw e;
        }
        QueryResponse response = queryResponse;
        List list = response.getBeans(SolrArticleExport.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBeans(...)");
        return list;
    }

    public static /* synthetic */ List exportArticles$default(SolrService solrService, ProfileId profileId, Instant instant, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exportArticles");
        }
        if ((n3 & 2) != 0) {
            instant = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 1000;
        }
        return solrService.exportArticles(profileId, instant, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private SolrInputDocument createWikiSolrDocument(WikiDto wiki, Set<Role> visibleForRoles) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SolrInputDocument solrInputDocument;
        SolrInputDocument $this$createWikiSolrDocument_u24lambda_u244 = solrInputDocument = new SolrInputDocument();
        boolean bl = false;
        $this$createWikiSolrDocument_u24lambda_u244.setField("id", (Object)wiki.getId().toString());
        $this$createWikiSolrDocument_u24lambda_u244.setField("name", (Object)wiki.getTitle());
        $this$createWikiSolrDocument_u24lambda_u244.setField("name_sort", (Object)wiki.getTitle());
        $this$createWikiSolrDocument_u24lambda_u244.setField("description", (Object)wiki.getDescription());
        $this$createWikiSolrDocument_u24lambda_u244.setField("type", (Object)this.wikiType);
        $this$createWikiSolrDocument_u24lambda_u244.setField("modify_date", (Object)new Date(wiki.getUpdatedAt().toInstant().toEpochMilli()));
        $this$createWikiSolrDocument_u24lambda_u244.setField("publication_date", (Object)new Date(wiki.getCreatedAt().toInstant().toEpochMilli()));
        $this$createWikiSolrDocument_u24lambda_u244.setField("just_app_id", (Object)"WIKI");
        Iterable iterable = visibleForRoles;
        String string = "visible_for_roles";
        SolrInputDocument solrInputDocument2 = $this$createWikiSolrDocument_u24lambda_u244;
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Role role = (Role)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.toString());
        }
        collection = (List)destination$iv$iv;
        solrInputDocument2.setField(string, (Object)collection);
        return solrInputDocument;
    }

    /*
     * WARNING - void declaration
     */
    private SolrInputDocument createChapterSolrDocument(ChapterDto chapter, Set<Role> visibleForRoles) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SolrInputDocument solrInputDocument;
        SolrInputDocument $this$createChapterSolrDocument_u24lambda_u246 = solrInputDocument = new SolrInputDocument();
        boolean bl = false;
        $this$createChapterSolrDocument_u24lambda_u246.setField("id", (Object)chapter.getId().toString());
        $this$createChapterSolrDocument_u24lambda_u246.setField("name", (Object)chapter.getTitle());
        $this$createChapterSolrDocument_u24lambda_u246.setField("name_sort", (Object)chapter.getTitle());
        $this$createChapterSolrDocument_u24lambda_u246.setField("type", (Object)this.chapterType);
        $this$createChapterSolrDocument_u24lambda_u246.setField("modify_date", (Object)new Date(chapter.getUpdatedAt().toInstant().toEpochMilli()));
        $this$createChapterSolrDocument_u24lambda_u246.setField("publication_date", (Object)new Date(chapter.getCreatedAt().toInstant().toEpochMilli()));
        $this$createChapterSolrDocument_u24lambda_u246.setField("just_app_id", (Object)"WIKI");
        Iterable iterable = visibleForRoles;
        String string = "visible_for_roles";
        SolrInputDocument solrInputDocument2 = $this$createChapterSolrDocument_u24lambda_u246;
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Role role = (Role)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.toString());
        }
        collection = (List)destination$iv$iv;
        solrInputDocument2.setField(string, (Object)collection);
        $this$createChapterSolrDocument_u24lambda_u246.setField("parent_ids", (Object)CollectionsKt.listOf((Object)chapter.getWikiId().toString()));
        return solrInputDocument;
    }

    /*
     * WARNING - void declaration
     */
    private SolrInputDocument createArticleSolrDocument(ArticleDto article, Set<Role> visibleForRoles) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SolrInputDocument solrInputDocument;
        SolrInputDocument $this$createArticleSolrDocument_u24lambda_u248 = solrInputDocument = new SolrInputDocument();
        boolean bl = false;
        $this$createArticleSolrDocument_u24lambda_u248.setField("id", (Object)article.getId().toString());
        $this$createArticleSolrDocument_u24lambda_u248.setField("name", (Object)article.getTitle());
        $this$createArticleSolrDocument_u24lambda_u248.setField("name_sort", (Object)article.getTitle());
        $this$createArticleSolrDocument_u24lambda_u248.setField("content", (Object)article.getTextContent());
        $this$createArticleSolrDocument_u24lambda_u248.setField("type", (Object)this.articleType);
        $this$createArticleSolrDocument_u24lambda_u248.setField("modify_date", (Object)new Date(article.getUpdatedAt().toInstant().toEpochMilli()));
        $this$createArticleSolrDocument_u24lambda_u248.setField("publication_date", (Object)new Date(article.getCreatedAt().toInstant().toEpochMilli()));
        $this$createArticleSolrDocument_u24lambda_u248.setField("just_app_id", (Object)"WIKI");
        Iterable iterable = visibleForRoles;
        String string = "visible_for_roles";
        SolrInputDocument solrInputDocument2 = $this$createArticleSolrDocument_u24lambda_u248;
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Role role = (Role)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.toString());
        }
        collection = (List)destination$iv$iv;
        solrInputDocument2.setField(string, (Object)collection);
        $this$createArticleSolrDocument_u24lambda_u248.setField("parent_ids", (Object)CollectionsKt.listOf((Object)article.getWikiId().toString()));
        return solrInputDocument;
    }

    private void addSolrDocuments(List<? extends SolrInputDocument> inputDocuments) {
        if (inputDocuments.isEmpty()) {
            return;
        }
        try {
            UpdateResponse updateResponse = this.useSoftCommit ? this.solrClient.add((Collection)inputDocuments, this.commitWithinInMs) : this.solrClient.add((Collection)inputDocuments);
            this.getSuccessfulIndexedDocumentCount$wiki_service().addAndGet(inputDocuments.size());
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            this.logger.warn("Batch adding of " + inputDocuments.size() + " documents failed. Try to add documents singly.", (Throwable)e);
            this.addSolrDocumentsSingly(inputDocuments);
        }
    }

    private void addSolrDocumentsSingly(List<? extends SolrInputDocument> solrDocuments) {
        Iterable $this$forEach$iv = solrDocuments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SolrInputDocument it = (SolrInputDocument)element$iv;
            boolean bl = false;
            try {
                UpdateResponse updateResponse = this.useSoftCommit ? this.solrClient.add(it, this.commitWithinInMs) : this.solrClient.add(it);
                this.getSuccessfulIndexedDocumentCount$wiki_service().incrementAndGet();
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                SolrInputField solrInputField = (SolrInputField)it.get((Object)"id");
                Object id = solrInputField != null ? solrInputField.getValue() : null;
                this.logger.error("Failed to index solr document for " + id, (Throwable)e);
                this.getFailedIndexedDocumentCount$wiki_service().incrementAndGet();
            }
        }
    }

    private void deleteSolrDocuments(List<String> ids) {
        if (ids.isEmpty()) {
            return;
        }
        try {
            UpdateResponse updateResponse = this.useSoftCommit ? this.solrClient.deleteById(ids, this.commitWithinInMs) : this.solrClient.deleteById(ids);
            this.getSuccessfulIndexedDocumentCount$wiki_service().addAndGet(ids.size());
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            this.logger.warn("Batch deletion of " + ids.size() + " documents failed. Try to delete documents singly.", (Throwable)e);
            this.deleteSolrDocumentsSingly(ids);
        }
    }

    private void deleteSolrDocumentsSingly(List<String> ids) {
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            try {
                UpdateResponse updateResponse = this.useSoftCommit ? this.solrClient.deleteById(it, this.commitWithinInMs) : this.solrClient.deleteById(it);
                this.getSuccessfulIndexedDocumentCount$wiki_service().incrementAndGet();
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                this.logger.error("Failed to delete solr document " + it, (Throwable)e);
                this.getFailedIndexedDocumentCount$wiki_service().incrementAndGet();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void index(@NotNull List<? extends AbstractId> ids) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        Iterable $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object it;
        Iterable $this$mapTo$iv$iv3;
        Object $this$map$iv2;
        Object object;
        Object v;
        Object object2;
        Collection<Object> collection;
        ArticleDto it$iv$iv;
        Object object3;
        Iterable $this$mapValuesTo$iv$iv2;
        void $this$mapValues$iv2;
        Map $this$filterIsInstanceTo$iv$iv;
        Object element$iv$iv3;
        void $this$filterIsInstanceTo$iv$iv2;
        void $this$filterIsInstanceTo$iv$iv3;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable $this$filterIsInstance$iv = ids;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv3) {
            if (!(element$iv$iv2 instanceof WikiId)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Set wikiIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$filterIsInstance$iv2 = ids;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv3 : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv3 instanceof ChapterId)) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        Set chapterIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $this$filterIsInstance$iv3 = ids;
        boolean $i$f$filterIsInstance3 = false;
        destination$iv$iv2 = $this$filterIsInstance$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo222 = false;
        element$iv$iv3 = $this$filterIsInstanceTo$iv$iv.iterator();
        while (element$iv$iv3.hasNext()) {
            Object element$iv$iv4 = element$iv$iv3.next();
            if (!(element$iv$iv4 instanceof ArticleId)) continue;
            destination$iv$iv3.add(element$iv$iv4);
        }
        Set articleIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        if (wikiIds.isEmpty() && chapterIds.isEmpty() && articleIds.isEmpty()) {
            return;
        }
        Map articleVersions = this.articleService.getLatestArticleVersions(articleIds);
        $this$filterIsInstanceTo$iv$iv = this.articleService.readByIds(articleIds);
        boolean $i$f$mapValues = false;
        void $i$f$filterIsInstanceTo222 = $this$mapValues$iv2;
        Map destination$iv$iv4 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
        boolean $i$f$mapValuesTo22 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            ArticleVersion version;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv4;
            boolean bl = false;
            object3 = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object2 = map;
            boolean bl2 = false;
            v = (Article)object3.getValue();
            if ((ArticleVersion)articleVersions.get(v.getId()) == null) {
                throw new ArticleVersionNotFoundException(null, 1, null);
            }
            object = ArticleDto.Companion.toDto(v, version, this.clock, this.maxEditingTokenDuration);
            object2.put(collection, object);
        }
        Map articles = destination$iv$iv4;
        Map chapters = this.chapterService.readByIds(chapterIds);
        $this$mapValuesTo$iv$iv2 = articles.values();
        collection = wikiIds;
        object2 = this.wikiService;
        boolean $i$f$map = false;
        void $i$f$mapValuesTo22 = $this$map$iv2;
        Object destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            it$iv$iv = (ArticleDto)item$iv$iv;
            object = destination$iv$iv5;
            boolean bl = false;
            object.add(it.getWikiId());
        }
        object = (List)destination$iv$iv5;
        $this$map$iv2 = chapters.values();
        collection = SetsKt.plus((Set)collection, (Iterable)((Iterable)object));
        $i$f$map = false;
        $this$mapTo$iv$iv3 = $this$map$iv2;
        destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            it = (ChapterDto)item$iv$iv;
            object = destination$iv$iv5;
            boolean bl = false;
            object.add(it.getWikiId());
        }
        object = (List)destination$iv$iv5;
        $this$map$iv2 = object2.readByIds(SetsKt.plus((Set)collection, (Iterable)((Iterable)object)));
        boolean $i$f$mapValues2 = false;
        $this$mapTo$iv$iv3 = $this$mapValues$iv;
        destination$iv$iv5 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo32 = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            void it2;
            void it$iv$iv2;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            object3 = destination$iv$iv5;
            boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = false;
            v = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv2.getKey();
            object2 = object3;
            boolean bl3 = false;
            object = WikiDto.Companion.toDto((Wiki)it2.getValue());
            object2.put(collection, object);
        }
        Object wikis = destination$iv$iv5;
        $this$mapValuesTo$iv$iv = wikis.values();
        object2 = this.permissionRequestConnector;
        boolean $i$f$map2 = false;
        void $i$f$mapValuesTo32 = $this$map$iv;
        Iterable destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it3;
            WikiDto it$iv$iv2 = (WikiDto)item$iv$iv;
            collection = destination$iv$iv6;
            boolean bl = false;
            collection.add(it3.getId().toString());
        }
        ImmutableSetMultimap immutableSetMultimap = object2.visibility((Iterable)((List)destination$iv$iv6));
        Intrinsics.checkNotNullExpressionValue((Object)immutableSetMultimap, (String)"visibility(...)");
        ImmutableSetMultimap permissions = immutableSetMultimap;
        $this$map$iv = SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.minus((Set)wikiIds, (Iterable)wikis.keySet()), (Iterable)SetsKt.minus((Set)chapterIds, (Iterable)chapters.keySet())), (Iterable)SetsKt.minus((Set)articleIds, (Iterable)articles.keySet()));
        $i$f$map2 = false;
        $this$mapTo$iv$iv2 = $this$map$iv;
        destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        it = $this$mapTo$iv$iv2.iterator();
        while (it.hasNext()) {
            Object item$iv$iv;
            Object it3 = item$iv$iv = it.next();
            object2 = destination$iv$iv6;
            boolean bl = false;
            object2.add(((AbstractId)it3).toString());
        }
        List idsToDeleted = (List)destination$iv$iv6;
        this.deleteSolrDocuments(idsToDeleted);
        Iterable $this$map$iv3 = wikis.values();
        boolean $i$f$map3 = false;
        destination$iv$iv6 = $this$map$iv3;
        Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it4;
            WikiDto bl = (WikiDto)item$iv$iv;
            object2 = destination$iv$iv7;
            boolean bl4 = false;
            ImmutableSet immutableSet = permissions.get((Object)it4.getId().toString());
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"get(...)");
            object2.add(this.createWikiSolrDocument((WikiDto)it4, (Set)immutableSet));
        }
        $this$map$iv3 = chapters.values();
        object2 = (List)destination$iv$iv7;
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv3;
        destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChapterDto it4 = (ChapterDto)item$iv$iv;
            collection = destination$iv$iv7;
            boolean bl = false;
            ImmutableSet immutableSet = permissions.get((Object)it4.getWikiId().toString());
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"get(...)");
            collection.add(this.createChapterSolrDocument(it4, (Set)immutableSet));
        }
        $this$map$iv3 = articles.values();
        object2 = CollectionsKt.plus((Collection)object2, (Iterable)((List)destination$iv$iv7));
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv3;
        destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ArticleDto it5 = (ArticleDto)item$iv$iv;
            collection = destination$iv$iv7;
            boolean bl = false;
            ImmutableSet immutableSet = permissions.get((Object)it5.getWikiId().toString());
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"get(...)");
            collection.add(this.createArticleSolrDocument(it5, (Set)immutableSet));
        }
        List documents = CollectionsKt.plus((Collection)object2, (Iterable)((List)destination$iv$iv7));
        this.addSolrDocuments(documents);
        if (!this.useSoftCommit) {
            this.solrClient.commit();
        }
    }

    private static final Number _init_$lambda$0(SolrService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getSuccessfulIndexedDocumentCount$wiki_service().get();
    }

    private static final Number _init_$lambda$1(SolrService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getFailedIndexedDocumentCount$wiki_service().get();
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

