/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.graphql.fetchers;

import de.justsoftware.wikiservice.application.SubscriptionApplicationService;
import de.justsoftware.wikiservice.application.model.ArticleDto;
import de.justsoftware.wikiservice.application.model.ArticleWithTitleDto;
import de.justsoftware.wikiservice.application.model.ChapterDto;
import de.justsoftware.wikiservice.application.model.SubscriptionDto;
import de.justsoftware.wikiservice.application.model.WikiDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.graphql.AuthenticatedGraphQLContext;
import de.justsoftware.wikiservice.graphql.dataloader.DataLoaderFactory;
import de.justsoftware.wikiservice.graphql.dataloader.DataLoaderName;
import de.justsoftware.wikiservice.graphql.generated.MutationSetSubscriptionArgs;
import de.justsoftware.wikiservice.model.WikiId;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0017\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\"\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\t0\t0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/wikiservice/graphql/fetchers/SubscriptionFetcher;", "", "subscriptionApplicationService", "Lde/justsoftware/wikiservice/application/SubscriptionApplicationService;", "<init>", "(Lde/justsoftware/wikiservice/application/SubscriptionApplicationService;)V", "subscriptionsByWikiDataLoaderFactory", "Lde/justsoftware/wikiservice/graphql/dataloader/DataLoaderFactory;", "Lde/justsoftware/wikiservice/model/WikiId;", "Lde/justsoftware/wikiservice/application/model/SubscriptionDto;", "byWikiIds", "Lgraphql/schema/DataFetcher;", "Ljava/util/concurrent/CompletableFuture;", "getByWikiIds", "()Lgraphql/schema/DataFetcher;", "byChapterId", "getByChapterId", "byArticleId", "getByArticleId", "byArticleWithTitleId", "getByArticleWithTitleId", "setSubscription", "kotlin.jvm.PlatformType", "getSetSubscription", "wiki-service"})
public class SubscriptionFetcher {
    @NotNull
    private final SubscriptionApplicationService subscriptionApplicationService;
    @NotNull
    private final DataFetcher<CompletableFuture<SubscriptionDto>> byWikiIds;
    @NotNull
    private final DataFetcher<SubscriptionDto> byChapterId;
    @NotNull
    private final DataFetcher<SubscriptionDto> byArticleId;
    @NotNull
    private final DataFetcher<SubscriptionDto> byArticleWithTitleId;
    @NotNull
    private final DataFetcher<SubscriptionDto> setSubscription;

    @Autowired
    public SubscriptionFetcher(@NotNull SubscriptionApplicationService subscriptionApplicationService) {
        Intrinsics.checkNotNullParameter((Object)subscriptionApplicationService, (String)"subscriptionApplicationService");
        this.subscriptionApplicationService = subscriptionApplicationService;
        this.byWikiIds = SubscriptionFetcher::byWikiIds$lambda$1;
        this.byChapterId = arg_0 -> SubscriptionFetcher.byChapterId$lambda$2(this, arg_0);
        this.byArticleId = arg_0 -> SubscriptionFetcher.byArticleId$lambda$3(this, arg_0);
        this.byArticleWithTitleId = arg_0 -> SubscriptionFetcher.byArticleWithTitleId$lambda$4(this, arg_0);
        this.setSubscription = arg_0 -> SubscriptionFetcher.setSubscription$lambda$5(this, arg_0);
    }

    @Bean
    @NotNull
    public DataLoaderFactory<WikiId, SubscriptionDto> subscriptionsByWikiDataLoaderFactory() {
        return new DataLoaderFactory(DataLoaderName.SUBSCRIPTION_LOADER, (arg_0, arg_1) -> SubscriptionFetcher.subscriptionsByWikiDataLoaderFactory$lambda$0(this, arg_0, arg_1));
    }

    @NotNull
    public DataFetcher<CompletableFuture<SubscriptionDto>> getByWikiIds() {
        return this.byWikiIds;
    }

    @NotNull
    public DataFetcher<SubscriptionDto> getByChapterId() {
        return this.byChapterId;
    }

    @NotNull
    public DataFetcher<SubscriptionDto> getByArticleId() {
        return this.byArticleId;
    }

    @NotNull
    public DataFetcher<SubscriptionDto> getByArticleWithTitleId() {
        return this.byArticleWithTitleId;
    }

    @NotNull
    public DataFetcher<SubscriptionDto> getSetSubscription() {
        return this.setSubscription;
    }

    private static final Map subscriptionsByWikiDataLoaderFactory$lambda$0(SubscriptionFetcher this$0, List wikiIds, AuthContext authCtx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        return this$0.subscriptionApplicationService.read(wikiIds, authCtx);
    }

    private static final CompletableFuture byWikiIds$lambda$1(DataFetchingEnvironment env) {
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.SUBSCRIPTION_LOADER);
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getSource(...)");
        WikiDto wiki = (WikiDto)object2;
        return dataLoader.load((Object)wiki.getId());
    }

    private static final SubscriptionDto byChapterId$lambda$2(SubscriptionFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getSource(...)");
        ChapterDto chapter = (ChapterDto)object2;
        return this$0.subscriptionApplicationService.read(chapter.getId(), context.getAuthContext());
    }

    private static final SubscriptionDto byArticleId$lambda$3(SubscriptionFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getSource(...)");
        ArticleDto article = (ArticleDto)object2;
        return this$0.subscriptionApplicationService.read(article.getId(), context.getAuthContext());
    }

    private static final SubscriptionDto byArticleWithTitleId$lambda$4(SubscriptionFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getSource(...)");
        ArticleWithTitleDto article = (ArticleWithTitleDto)object2;
        return this$0.subscriptionApplicationService.read(article.getId(), context.getAuthContext());
    }

    private static final SubscriptionDto setSubscription$lambda$5(SubscriptionFetcher this$0, DataFetchingEnvironment data) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AuthenticatedGraphQLContext ctx = (AuthenticatedGraphQLContext)data.getContext();
        Map map = data.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        MutationSetSubscriptionArgs args = new MutationSetSubscriptionArgs(map);
        return this$0.subscriptionApplicationService.setSubscription(args.getItemId(), args.isSubscribed(), ctx.getAuthContext());
    }
}

