/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.permission.client.model.Role;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.GranteeId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.SubscriptionRepository;
import de.justsoftware.wikiservice.persistence.model.Subscription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016J8\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00070\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0018H\u0016J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/wikiservice/business/SubscriptionService;", "", "subscriptionRepository", "Lde/justsoftware/wikiservice/persistence/SubscriptionRepository;", "<init>", "(Lde/justsoftware/wikiservice/persistence/SubscriptionRepository;)V", "setSubscription", "Lde/justsoftware/wikiservice/persistence/model/Subscription;", "itemId", "Lde/justsoftware/wikiservice/model/ItemId;", "subscriber", "Lde/justsoftware/wikiservice/model/ProfileId;", "isSubscribed", "", "readArticle", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "readChapter", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "readWikis", "", "Lde/justsoftware/wikiservice/model/WikiId;", "wikiIds", "", "subscriberRoles", "Lde/justsoftware/permission/client/model/Role;", "read", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nSubscriptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscriptionService.kt\nde/justsoftware/wikiservice/business/SubscriptionService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1557#2:70\n1628#2,3:71\n1557#2:74\n1628#2,3:75\n1279#2,2:78\n1293#2,4:80\n*S KotlinDebug\n*F\n+ 1 SubscriptionService.kt\nde/justsoftware/wikiservice/business/SubscriptionService\n*L\n44#1:70\n44#1:71,3\n51#1:74\n51#1:75,3\n54#1:78,2\n54#1:80,4\n*E\n"})
public class SubscriptionService {
    @NotNull
    private final SubscriptionRepository subscriptionRepository;

    @Autowired
    public SubscriptionService(@NotNull SubscriptionRepository subscriptionRepository) {
        Intrinsics.checkNotNullParameter((Object)subscriptionRepository, (String)"subscriptionRepository");
        this.subscriptionRepository = subscriptionRepository;
    }

    @NotNull
    public Subscription setSubscription(@NotNull ItemId itemId, @NotNull ProfileId subscriber, boolean isSubscribed) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Subscription subscription = new Subscription(subscriber, itemId, isSubscribed);
        Object object = this.subscriptionRepository.save((Object)subscription);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        return (Subscription)object;
    }

    @NotNull
    public Subscription readArticle(@NotNull ArticleId articleId, @NotNull ProfileId subscriber) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        return this.read((ItemId)articleId, subscriber);
    }

    @NotNull
    public Subscription readChapter(@NotNull ChapterId chapterId, @NotNull ProfileId subscriber) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        return this.read((ItemId)chapterId, subscriber);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, Subscription> readWikis(@NotNull Set<WikiId> wikiIds, @NotNull ProfileId subscriber, @NotNull Set<Role> subscriberRoles) {
        Collection<UUID> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Intrinsics.checkNotNullParameter(subscriberRoles, (String)"subscriberRoles");
        Iterable iterable = subscriberRoles;
        boolean $i$f$map22 = false;
        void var7_7 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void r;
            Role role = (Role)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(GranteeId.Companion.toGranteeId((Role)r));
        }
        Set granteeIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $i$f$map22 = wikiIds;
        Set<WikiId> set = wikiIds;
        Set set2 = granteeIds;
        long l = subscriber.getId();
        object = this.subscriptionRepository;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            WikiId bl = (WikiId)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(p0.getId());
        }
        collection = (List)destination$iv$iv2;
        List subscriptions = object.findAllByWikiPermissionRoles(l, set2, set, CollectionsKt.toSet((Iterable)collection));
        Iterable $this$associateWith$iv = wikiIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Subscription subscription;
            Object v0;
            void wikiId;
            Object t;
            block5: {
                WikiId p0 = (WikiId)element$iv$iv;
                t = element$iv$iv;
                object = result$iv;
                boolean bl = false;
                Iterable iterable2 = subscriptions;
                for (Object t2 : iterable2) {
                    Subscription subscription2 = (Subscription)t2;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)subscription2.getItemId(), (Object)wikiId.getId())) continue;
                    v0 = t2;
                    break block5;
                }
                v0 = null;
            }
            if ((subscription = (Subscription)v0) == null) {
                subscription = new Subscription(subscriber, (ItemId)wikiId, false);
            }
            Subscription subscription3 = subscription;
            object.put(t, subscription3);
        }
        return result$iv;
    }

    private Subscription read(ItemId itemId, ProfileId subscriber) {
        Subscription subscription = this.subscriptionRepository.findBySubscriberAndItemId(subscriber.getId(), itemId.getId());
        if (subscription == null) {
            subscription = new Subscription(subscriber, itemId, false);
        }
        return subscription;
    }
}

