/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.authorization;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.CoreApp;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.authorization.model.PermissionAction;
import de.justsoftware.wikiservice.business.ConfigService;
import de.justsoftware.wikiservice.business.exceptions.NotAllowedException;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.model.UserGroupId;
import de.justsoftware.wikiservice.model.WikiId;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="AuthorizationService")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0017\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J2\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J*\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J<\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u000b0\t\"\b\b\u0000\u0010\u0017*\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012J6\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u001d0\t\"\u0004\b\u0000\u0010\u00172\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u001f0\t2\u0006\u0010 \u001a\u00020\u000fH\u0016J6\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u001d0\t\"\u0004\b\u0000\u0010\u00172\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u001f0\t2\u0006\u0010!\u001a\u00020\u001fH\u0012J\u001e\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010%\u001a\u00020#2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u000fH\u0016J\u0018\u0010*\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u000fH\u0016J\u0018\u0010+\u001a\u00020#2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u001fH\u0012J\u0018\u0010-\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u001fH\u0012J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001f0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0012J\u0018\u00101\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/PermissionRequestConnector;", "configService", "Lde/justsoftware/wikiservice/business/ConfigService;", "<init>", "(Lde/justsoftware/permission/client/rest/PermissionRequestConnector;Lde/justsoftware/wikiservice/business/ConfigService;)V", "mayWriteWikis", "", "Lde/justsoftware/wikiservice/model/WikiId;", "", "wikiIds", "", "user", "Lde/justsoftware/wikiservice/model/ProfileId;", "mayReadArticleVersionHistory", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "mayManageWikis", "mayTenantManageWikis", "tenantIds", "mayPerformAction", "ID", "Lde/justsoftware/wikiservice/model/AbstractId;", "ids", "permissionAction", "Lde/justsoftware/wikiservice/authorization/model/PermissionAction;", "hasRoles", "Lde/justsoftware/permission/client/model/AuthorizationResult;", "rolesToCheck", "Lde/justsoftware/permission/client/model/Role;", "profile", "profileOrUserGroupRole", "checkReadProfiles", "", "profiles", "checkReadUserGroups", "userGroupIds", "Lde/justsoftware/wikiservice/model/UserGroupId;", "checkIfProfileMayReadTenant", "tenant", "mayProfileReadTenant", "checkIfMayReadTenant", "role", "mayReadTenant", "getUserRoles", "permissionRole", "id", "mayCreateWiki", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nAuthorizationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationService.kt\nde/justsoftware/wikiservice/authorization/AuthorizationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,167:1\n1279#2,2:168\n1293#2,4:170\n1246#2,4:176\n1246#2,4:182\n1279#2,2:186\n1293#2,4:188\n1755#2,3:192\n1279#2,2:195\n1293#2,4:197\n1755#2,3:201\n462#3:174\n412#3:175\n462#3:180\n412#3:181\n*S KotlinDebug\n*F\n+ 1 AuthorizationService.kt\nde/justsoftware/wikiservice/authorization/AuthorizationService\n*L\n58#1:168,2\n58#1:170,4\n60#1:176,4\n79#1:182,4\n86#1:186,2\n86#1:188,4\n87#1:192,3\n96#1:195,2\n96#1:197,4\n97#1:201,3\n60#1:174\n60#1:175\n79#1:180\n79#1:181\n*E\n"})
public class AuthorizationService {
    @NotNull
    private final PermissionRequestConnector permissionRequestConnector;
    @NotNull
    private final ConfigService configService;

    @Autowired
    public AuthorizationService(@NotNull PermissionRequestConnector permissionRequestConnector, @NotNull ConfigService configService) {
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        this.permissionRequestConnector = permissionRequestConnector;
        this.configService = configService;
    }

    @NotNull
    public Map<WikiId, Boolean> mayWriteWikis(@NotNull Set<WikiId> wikiIds, @NotNull ProfileId user) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return this.mayPerformAction(wikiIds, PermissionAction.WRITE, user);
    }

    @NotNull
    public Map<WikiId, Boolean> mayReadArticleVersionHistory(@NotNull Set<WikiId> wikiIds, @NotNull ProfileId user, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        PermissionAction permission = switch (WhenMappings.$EnumSwitchMapping$0[this.configService.getMayReadArticleVersionHistoryPermission(tenantId).ordinal()]) {
            case 1 -> PermissionAction.READ;
            case 2 -> PermissionAction.WRITE;
            case 3 -> PermissionAction.MANAGE;
            default -> throw new NoWhenBranchMatchedException();
        };
        return this.mayPerformAction(wikiIds, permission, user);
    }

    @NotNull
    public Map<WikiId, Boolean> mayManageWikis(@NotNull Set<WikiId> wikiIds, @NotNull ProfileId user) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return this.mayPerformAction(wikiIds, PermissionAction.MANAGE, user);
    }

    @NotNull
    public Map<TenantId, Boolean> mayTenantManageWikis(@NotNull Set<TenantId> tenantIds, @NotNull ProfileId user) {
        Intrinsics.checkNotNullParameter(tenantIds, (String)"tenantIds");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return this.mayPerformAction(tenantIds, PermissionAction.MANAGE, user);
    }

    /*
     * WARNING - void declaration
     */
    private <ID extends AbstractId> Map<ID, Boolean> mayPerformAction(Set<? extends ID> ids, PermissionAction permissionAction, ProfileId user) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map map;
        Object object;
        Map $this$associateWith$iv;
        Iterable iterable = ids;
        Object object2 = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateWith$iv), (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void id;
            AbstractId abstractId = (AbstractId)element$iv$iv;
            object = element$iv$iv;
            map = result$iv;
            boolean bl = false;
            Role role = this.permissionRole((AbstractId)id, permissionAction);
            map.put(object, role);
        }
        $this$associateWith$iv = object2.hasRoles((Map)result$iv, user);
        boolean $i$f$mapValues = false;
        result$iv = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            map = it$iv$iv.getKey();
            object2 = map2;
            boolean bl2 = false;
            object = it.getValue() == AuthorizationResult.OK;
            object2.put(map, object);
        }
        return destination$iv$iv;
    }

    @NotNull
    public <ID> Map<ID, AuthorizationResult> hasRoles(@NotNull Map<ID, Role> rolesToCheck, @NotNull ProfileId profile) {
        Intrinsics.checkNotNullParameter(rolesToCheck, (String)"rolesToCheck");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return this.hasRoles(rolesToCheck, profile.toRole());
    }

    /*
     * WARNING - void declaration
     */
    private <ID> Map<ID, AuthorizationResult> hasRoles(Map<ID, Role> rolesToCheck, Role profileOrUserGroupRole) {
        void $this$mapValuesTo$iv$iv;
        if (rolesToCheck.isEmpty()) {
            return MapsKt.emptyMap();
        }
        ImmutableMap immutableMap = this.permissionRequestConnector.hasRoles((Iterable)CollectionsKt.toSet((Iterable)rolesToCheck.values()), (Iterable)SetsKt.setOf((Object)profileOrUserGroupRole));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"hasRoles(...)");
        ImmutableMap authResults = immutableMap;
        Map<ID, Role> $this$mapValues$iv = rolesToCheck;
        boolean $i$f$mapValues = false;
        Map<ID, Role> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void entry;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            AuthorizationResult authorizationResult = (AuthorizationResult)authResults.get(entry.getValue());
            if (authorizationResult == null) {
                authorizationResult = AuthorizationResult.NOT_FOUND;
            }
            AuthorizationResult authorizationResult2 = authorizationResult;
            map3.put(k, authorizationResult2);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public void checkReadProfiles(@NotNull Set<ProfileId> profiles, @NotNull ProfileId user) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(profiles, (String)"profiles");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Iterable $this$associateWith$iv = profiles;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void profileId;
                ProfileId profileId2 = (ProfileId)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl2 = false;
                Role role = Role.read((String)profileId.toString());
                map.put(t, role);
            }
            Map rolesToCheck = result$iv;
            Iterable $this$any$iv = this.hasRoles(rolesToCheck, user).values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AuthorizationResult it = (AuthorizationResult)element$iv;
                    boolean bl3 = false;
                    if (!(it != AuthorizationResult.OK)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new NotAllowedException(user + " is not allowed to read at least one of the profiles " + profiles);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void checkReadUserGroups(@NotNull Set<UserGroupId> userGroupIds, @NotNull ProfileId user) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(userGroupIds, (String)"userGroupIds");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Iterable $this$associateWith$iv = userGroupIds;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                UserGroupId userGroupId = (UserGroupId)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl2 = false;
                Role role = Role.read((String)it.toString());
                map.put(t, role);
            }
            Map rolesToCheck = result$iv;
            Iterable $this$any$iv = this.hasRoles(rolesToCheck, user).values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AuthorizationResult it = (AuthorizationResult)element$iv;
                    boolean bl3 = false;
                    if (!(it != AuthorizationResult.OK)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new NotAllowedException(user + " is not allowed to read at least one of the user groups " + userGroupIds);
        }
    }

    public void checkIfProfileMayReadTenant(@NotNull TenantId tenant, @NotNull ProfileId profile) {
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        this.checkIfMayReadTenant(tenant, profile.toRole());
    }

    public boolean mayProfileReadTenant(@NotNull TenantId tenant, @NotNull ProfileId profile) {
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return this.mayReadTenant(tenant, profile.toRole());
    }

    private void checkIfMayReadTenant(TenantId tenant, Role role) {
        if (!this.mayReadTenant(tenant, role)) {
            throw new NotAllowedException(role.asString() + " has not the right READ@" + tenant);
        }
    }

    private boolean mayReadTenant(TenantId tenant, Role role) {
        Map result = this.hasRoles(MapsKt.mapOf((Pair)TuplesKt.to((Object)tenant, (Object)Role.tenantRead((UUID)tenant.getId()))), role);
        return result.get(tenant) == AuthorizationResult.OK;
    }

    @NotNull
    public Set<Role> getUserRoles(@NotNull ProfileId user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        ImmutableSet immutableSet = this.permissionRequestConnector.searchRoles(user.toRole());
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"searchRoles(...)");
        return (Set)immutableSet;
    }

    private Role permissionRole(AbstractId id, PermissionAction permissionAction) {
        Role role = Role.itemRole((String)permissionAction.name(), (String)id.toString());
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"itemRole(...)");
        return role;
    }

    public boolean mayCreateWiki(@NotNull ProfileId profile, @NotNull TenantId tenant) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Map roles = MapsKt.mapOf((Pair)TuplesKt.to((Object)tenant, (Object)Role.writeApp((CoreApp)CoreApp.WIKI, (UUID)tenant.getId())));
        Map result = this.hasRoles(roles, profile);
        return result.get(tenant) == AuthorizationResult.OK;
    }
}

