/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.application.model.ChapterDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.DeletionService;
import de.justsoftware.wikiservice.graphql.generated.CreateChapterInput;
import de.justsoftware.wikiservice.graphql.generated.UpdateChapterInput;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.model.Chapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B+\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J0\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00130\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J*\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\t0\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/justsoftware/wikiservice/application/ChapterApplicationService;", "", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "deletionService", "Lde/justsoftware/wikiservice/business/DeletionService;", "maxPageSize", "", "<init>", "(Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/AncestorService;Lde/justsoftware/wikiservice/business/DeletionService;I)V", "read", "Lde/justsoftware/wikiservice/application/model/ChapterDto;", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "readSubscribedChapters", "", "page", "size", "update", "input", "Lde/justsoftware/wikiservice/graphql/generated/UpdateChapterInput;", "delete", "getAllChildChapters", "", "Lde/justsoftware/wikiservice/model/ParentId;", "parentIds", "countChaptersForWikis", "Lde/justsoftware/wikiservice/model/WikiId;", "wikiIds", "create", "chapterInput", "Lde/justsoftware/wikiservice/graphql/generated/CreateChapterInput;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nChapterApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChapterApplicationService.kt\nde/justsoftware/wikiservice/application/ChapterApplicationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,127:1\n1#2:128\n1557#3:129\n1628#3,3:130\n1557#3:133\n1628#3,3:134\n1246#3,2:139\n1557#3:141\n1628#3,3:142\n1249#3:145\n774#3:146\n865#3,2:147\n1557#3:149\n1628#3,3:150\n462#4:137\n412#4:138\n*S KotlinDebug\n*F\n+ 1 ChapterApplicationService.kt\nde/justsoftware/wikiservice/application/ChapterApplicationService\n*L\n45#1:129\n45#1:130,3\n47#1:133\n47#1:134,3\n88#1:139,2\n88#1:141\n88#1:142,3\n88#1:145\n92#1:146\n92#1:147,2\n93#1:149\n93#1:150,3\n88#1:137\n88#1:138\n*E\n"})
public class ChapterApplicationService {
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final DeletionService deletionService;
    private final int maxPageSize;

    @Autowired
    public ChapterApplicationService(@NotNull ChapterService chapterService, @NotNull AncestorService ancestorService, @NotNull DeletionService deletionService, @Value(value="${service.maxPageSize:200}") int maxPageSize) {
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)deletionService, (String)"deletionService");
        this.chapterService = chapterService;
        this.ancestorService = ancestorService;
        this.deletionService = deletionService;
        this.maxPageSize = maxPageSize;
    }

    @NotNull
    public ChapterDto read(@NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        ChapterDto chapterDto;
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChapterDto it = chapterDto = ChapterDto.Companion.toDto(this.chapterService.read(chapterId));
        boolean bl = false;
        authContext.checkReadWiki(it.getWikiId());
        return chapterDto;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ChapterDto> readSubscribedChapters(int page, int size, @NotNull AuthContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!(page >= 0)) {
            boolean $i$a$-require-ChapterApplicationService$readSubscribedChapters$32 = false;
            String $i$a$-require-ChapterApplicationService$readSubscribedChapters$32 = "Page must not be < 0";
            throw new IllegalArgumentException($i$a$-require-ChapterApplicationService$readSubscribedChapters$32.toString());
        }
        if (!(1 <= size ? size <= this.maxPageSize : false)) {
            boolean $i$a$-require-ChapterApplicationService$readSubscribedChapters$42 = false;
            String $i$a$-require-ChapterApplicationService$readSubscribedChapters$42 = "PageSize must be between 1 and " + this.maxPageSize;
            throw new IllegalArgumentException($i$a$-require-ChapterApplicationService$readSubscribedChapters$42.toString());
        }
        Iterable iterable = this.chapterService.readBySubscriber(authContext.getUser(), page, size);
        boolean $i$f$map = false;
        void var6_11 = $this$map$iv2;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            Chapter chapter = (Chapter)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ChapterDto.Companion.toDto((Chapter)it));
        }
        Iterable it = iterable = (List)destination$iv$iv;
        boolean bl = false;
        destination$iv$iv = it;
        AuthContext authContext2 = authContext;
        boolean $i$f$map2 = false;
        item$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void c;
            ChapterDto chapterDto = (ChapterDto)item$iv$iv3;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(c.getWikiId());
        }
        authContext2.checkReadWikis(CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)));
        return iterable;
    }

    @Transactional
    @NotNull
    public ChapterDto update(@NotNull ChapterId chapterId, @NotNull UpdateChapterInput input, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.ancestorService.getAncestorWikiId((ParentId)chapterId);
        if (input.getParentId() != null) {
            WikiId toWikiId = this.ancestorService.getAncestorWikiId(input.getParentId());
            authContext.checkMoveWikiContent(wikiId, toWikiId);
        } else {
            authContext.checkWriteWiki(wikiId);
        }
        boolean chapterWasMoved = this.ancestorService.moveChapter(chapterId, input.getParentId(), authContext.getUser());
        return ChapterDto.Companion.toDto(this.chapterService.update(chapterId, input.getTitle(), authContext.getUser(), chapterWasMoved));
    }

    @Transactional
    @NotNull
    public ChapterDto delete(@NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        ChapterDto chapterDto;
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChapterDto chapterDto2 = chapterDto = ChapterDto.Companion.toDto(this.chapterService.read(chapterId));
        boolean bl = false;
        authContext.checkWriteWiki(chapterDto2.getWikiId());
        DeletionId deletionId = DeletionService.create$default((DeletionService)this.deletionService, (ItemId)((ItemId)chapterId), (ProfileId)authContext.getUser(), null, (int)4, null);
        this.chapterService.delete(chapterId, deletionId, authContext.getUser());
        return chapterDto;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, List<ChapterDto>> getAllChildChapters(@NotNull List<? extends ParentId> parentIds, @NotNull AuthContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List chapters;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Map map;
        Object object;
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Map $this$mapValues$iv = this.chapterService.readByParentIds(CollectionsKt.toSet((Iterable)parentIds));
        boolean $i$f$mapValues = false;
        Map map2 = $this$mapValues$iv;
        Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv2;
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            object = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Iterable $this$map$iv2 = (Iterable)it.getValue();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void chapter;
                Chapter chapter2 = (Chapter)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(ChapterDto.Companion.toDto((Chapter)chapter));
            }
            List list = (List)destination$iv$iv2;
            map4.put(k, list);
        }
        Map parentIdsToChildChapters = map = destination$iv$iv;
        boolean bl = false;
        destination$iv$iv = parentIdsToChildChapters.values();
        boolean $i$f$filter = false;
        $this$associateByTo$iv$iv$iv = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            chapters = (List)element$iv$iv;
            boolean bl4 = false;
            boolean bl5 = !((Collection)chapters).isEmpty();
            if (!bl5) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv3;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            chapters = (List)item$iv$iv;
            object = destination$iv$iv3;
            boolean bl6 = false;
            object.add(((ChapterDto)CollectionsKt.first((List)chapters)).getWikiId());
        }
        Set parentWikiIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        authContext.checkReadWikis(parentWikiIds);
        return map;
    }

    @NotNull
    public Map<WikiId, Integer> countChaptersForWikis(@NotNull List<WikiId> wikiIds, @NotNull AuthContext authContext) {
        Map map;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (wikiIds.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            authContext.checkReadWikis(CollectionsKt.toSet((Iterable)wikiIds));
            map = this.chapterService.countByWikiIds(CollectionsKt.toSet((Iterable)wikiIds));
        }
        return map;
    }

    @NotNull
    public ChapterDto create(@NotNull CreateChapterInput chapterInput, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterInput, (String)"chapterInput");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ParentId parentId = chapterInput.getParentId();
        WikiId wikiId = this.ancestorService.getAncestorWikiId(parentId);
        int position = this.ancestorService.getNextPositionForParent(parentId);
        authContext.checkWriteWiki(wikiId);
        this.ancestorService.checkMaxNestingDepthOfNewChapter(parentId);
        return ChapterDto.Companion.toDto(this.chapterService.create(wikiId, parentId, chapterInput.getTitle(), authContext.getUser(), position));
    }
}

