/**
 * This is a fork of the following JQuery plugin:
 *
 *
 * highlight v4
 *
 * Highlights arbitrary terms.
 *
 * <http://johannburkard.de/blog/programming/javascript/highlight-javascript-text-higlighting-jquery-plugin.html>
 *
 * MIT license.
 *
 * vJohann Burkard
 * <http://johannburkard.de>
 * <mailto:jb@eaio.com>
 *
 *
 * with some ideas taken from
 *
 *
 * http://bartaz.github.io/sandbox.js/jquery.highlight.html
 *
 * jQuery Highlight plugin
 *
 * Copyright (c) 2009 Bartek Szopka
 *
 * Licensed under MIT license.
 */

jQuery.extend({
    highlight: function (node, re) {
        if (node.nodeType === 3) { // handle text node
            var newText = node.data.replace(re, "<span class=\"highlight\">$&</span>");
            jQuery(node).replaceWith(newText);
        } else if (node.nodeType === 1 && node.childNodes // only element nodes that have children
                && !/(script|style)/i.test(node.tagName) // ignore script and style nodes
                && !(/span/i.test(node.tagName) && ( node.className === "highlight" || node.className === "highlight-current" ))) { // skip if already highlighted
            for (var i = 0; i < node.childNodes.length; i++) {
                jQuery.highlight(node.childNodes[i], re);
            }
        }
    }
});

jQuery.fn.highlight = function(searchString) {
    if (!this.length || !searchString || !searchString.length) {
        return this;
    }

    // quote special regexp characters
    searchString = searchString.replace(/[\-\[\]{}()*+?.,\\\^\$|#\s]/g, "\\$&");
    // search for all occurences (g) and case-insensitive (i)
    var re = new RegExp("(" + searchString + ")", "gi");

    return this.each(function () {
        jQuery.highlight(this, re);
    });
};

jQuery.fn.removeHighlight = function () {

    function newNormalize(node) {
        for (var i = 0, children = node.childNodes, nodeCount = children.length; i < nodeCount; i++) {
            var child = children[i];
            if (child.nodeType === 1) { // element node
                newNormalize(child);
            } else if (child.nodeType === 3) { // text node
                var next = child.nextSibling;
                if ( next !== null && next.nodeType === 3) {
                    var combined_text = child.nodeValue + next.nodeValue;
                    new_node = node.ownerDocument.createTextNode(combined_text);
                    node.insertBefore(new_node, child);
                    node.removeChild(child);
                    node.removeChild(next);
                    i--;
                    nodeCount--;
                }
            }
        }
    }
    // added removing of the new CSS class highlight-current
    return this.find("span.highlight, span.highlight-current").each(function () {
        var parent = this.parentNode;
        if (this.firstChild) {
            parent.replaceChild(this.firstChild, this);
        } else {
            // remove empty span element, happens in IE sometimes for some reason
            parent.removeChild(this);
        }
        newNormalize(parent);
    }).end();
};

// new function to navigate to next highlighted element
jQuery.fn.nextHighlight = function () {
    var first = null, lastHc = null, newHc = null;
    this.find("span.highlight, span.highlight-current").each(function () {
        if (first === null) {
            first = this;
        }
        if (this.className === "highlight-current") {
            lastHc = this;
            lastHc.className = "highlight";
        } else if (lastHc !== null && newHc === null) {
            newHc = this;
            return false;
        }
    });

    if (newHc === null && first !== null) {
        newHc = first;
    }

    if (newHc !== null) {
        newHc.className = "highlight-current";
        newHc.scrollIntoView(true);
    }

    return newHc;
};

// new function to navigate to previous highlighted element
jQuery.fn.previousHighlight = function () {
    var lastH = null, newHc = null;
    this.find("span.highlight, span.highlight-current").each(function () {
        if (this.className === "highlight-current") {
            this.className = "highlight";
            if (lastH !== null) {
                newHc = lastH;
            }
        }

        lastH = this;
    });

    if (newHc === null && lastH !== null) {
        newHc = lastH;
    }

    if (newHc !== null) {
        newHc.className = "highlight-current";
        newHc.scrollIntoView(true);
    }

    return newHc;
};
