/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wikieditor.presentation.client.ui;

import com.freiheit.toro.account.presentation.ui.LoginManagerImpl;
import com.freiheit.toro.client.event.GlobalEventManager;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.freiheit.toro.util.client.WidgetUtil;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ClientRelativeDateUtil;
import de.justsoftware.onx.common.presentation.client.ui.InfoBoxWidget;
import de.justsoftware.onx.common.presentation.client.ui.PopupHelper;
import de.justsoftware.onx.common.presentation.client.ui.browsersearch.BrowserSearchWidget;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.wikieditor.presentation.client.WikiEditorMediator;
import de.justsoftware.onx.wikieditor.presentation.client.WikiEditorMediatorInterface;
import de.justsoftware.onx.wikieditor.presentation.client.WikiVersionsHandler;
import de.justsoftware.onx.wikieditor.presentation.client.ui.AutomaticBackupSaver;
import de.justsoftware.onx.wikieditor.presentation.client.ui.WikiEditorComponent;
import de.justsoftware.onx.wikieditor.presentation.client.ui.WikiEditorComponentPresenter;
import de.justsoftware.onx.wikieditor.presentation.client.ui.WikiEditorPresenter;
import de.justsoftware.onx.wikieditor.shared.i18n.WikiEditorConstants;
import de.justsoftware.onx.wikieditor.shared.i18n.WikiEditorMessages;
import de.justsoftware.onx.wikieditor.shared.model.WikiBackupTeaser;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditor;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditorId;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersion;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionTeaser;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class WikiEditorComponent
extends Composite
implements WikiEditorComponentPresenter {
    private static final long FOUR_WEEKS = 2419200000L;
    private static final WikiEditorMessages WIKI_EDITOR_MSG = I18nMediator.WIKI_EDITOR_MSG;
    private static final WikiEditorConstants WIKI_EDITOR_CONSTANTS = I18nMediator.WIKI_EDITOR;
    private static final WikiEditorComponentUIBinder UI_BINDER = (WikiEditorComponentUIBinder)GWT.create(WikiEditorComponentUIBinder.class);
    @UiField
    InfoBoxWidget _infoBoxWidget;
    @UiField
    HTMLPanel _pageLockedPanel;
    @UiField
    Panel _pageLockedByPanel;
    @UiField
    HTMLPanel _pageRestoreBackupPanel;
    @UiField
    InlineLabel _restoreTimeLabel;
    @UiField
    HTMLPanel _viewPanel;
    @UiField
    SimplePanel _inlineEditorContainer;
    @UiField
    Panel _versionInfoPanel;
    @UiField
    IconAnchor _showHistoryLink;
    @UiField
    Panel _currentVersionPanel;
    @UiField
    Panel _auhtorInfoPanel;
    @UiField
    SimplePanel _browserSearch;
    @UiField
    HTMLPanel _wikiEditorInfoPanel;
    private final ClientFactory _clientFactory;
    private final PopupHelper _popupHelper;
    private final WikiEditorMediatorInterface _mediator;
    private WikiEditorPresenter _presenter;
    private boolean _mayEdit;
    private WikiEditor _wikiEditor;

    public WikiEditorComponent(@Nonnull ClientFactory clientFactory, @Nonnull WikiEditor wikiEditor, @Nonnull EntityType entityType) {
        this._wikiEditor = wikiEditor;
        this._clientFactory = clientFactory;
        this._mayEdit = this._wikiEditor.getMay().contains((Object)StaticAction.WIKI_SAVE);
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this._popupHelper = clientFactory.popupHelper();
        this._showHistoryLink.setTargetHistoryToken(WikiVersionsHandler.token((WikiEditorId)this._wikiEditor.getId()));
        this._mediator = WikiEditorMediator.getInstance();
        this._presenter = new WikiEditorPresenter((WikiEditorComponentPresenter)this, this._clientFactory.editorClientFactory(), this._wikiEditor, this._mediator, this._mayEdit, clientFactory.getHostPropertiesBean().getEditorToolbar(), (WikiEditorPresenter.BackupTimer)new AutomaticBackupSaver(wikiEditor, this._mediator), this._clientFactory.eventManager(), this._clientFactory.popupHelper(), this._clientFactory.clientLogger(), this._clientFactory.historyManager(), GlobalEventManager.getInstance(), WIKI_EDITOR_CONSTANTS);
        this._presenter.showIn((AcceptsOneWidget)this._inlineEditorContainer);
        this._presenter.addSaveHandler((WikiEditorPresenter.SaveHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.setCurrentVersion(this._wikiEditor.getCurrentVersion());
        boolean locked = this.setBackup(this._wikiEditor.getBackup());
        this._presenter.setLocked(locked);
        this.applyBrowserSearchEntityConfig(entityType);
    }

    private void reloadData() {
        this._mediator.getWikiEditorById(this._wikiEditor.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void fillAuthorInfoPanel(WikiVersion currentVersion) {
        String authorKey = "author";
        Date now = new Date();
        Date d = currentVersion.getCreateDate();
        String msg = now.getTime() - d.getTime() < 2419200000L ? WIKI_EDITOR_MSG.lastSavedByBefore("\uffffauthor\uffff", ClientRelativeDateUtil.INSTANCE.getRelativeTime(d, now)) : WIKI_EDITOR_MSG.lastSavedByAt("\uffffauthor\uffff", this._clientFactory.dateFormatter().formatDateTime(d));
        HashMap<String, Object> m = new HashMap<String, Object>();
        PersonTeaserModel author = currentVersion.getAuthor();
        if (author != null) {
            m.put("author", PersonUtil.profileLink((PersonTeaserModel)author, (ClientFactory)this._clientFactory, (PersonUtil.PopupOption)PersonUtil.PopupOption.WITH_POPUP));
        } else {
            m.put("author", new InlineLabel(I18nMediator.WIKI_EDITOR.unknownAuthor()));
        }
        this._auhtorInfoPanel.clear();
        WidgetUtil.i18nLinkedText((String[])msg.split("\uffff"), m, (HasWidgets.ForIsWidget)this._auhtorInfoPanel);
    }

    private void applyBrowserSearchEntityConfig(@Nonnull EntityType entityType) {
        boolean enabled = HostPropertiesMediator.getClientEntityConfig((EntityType)entityType).isEnableBrowserSearch();
        this._browserSearch.clear();
        if (enabled) {
            this._browserSearch.add((Widget)new BrowserSearchWidget());
        }
        this._browserSearch.setVisible(enabled);
    }

    private boolean setBackup(@Nullable WikiBackupTeaser backup) {
        if (backup == null || !this._wikiEditor.getMay().contains((Object)StaticAction.WIKI_SAVE)) {
            this._pageLockedPanel.setVisible(false);
            this._pageRestoreBackupPanel.setVisible(false);
            return false;
        }
        if (((PersonId)backup.getAuthor().getId()).equals((Object)LoginManagerImpl.getInstance().getPersonId())) {
            this._pageLockedPanel.setVisible(false);
            this._pageRestoreBackupPanel.setVisible(true);
            this._restoreTimeLabel.setText(WIKI_EDITOR_MSG.backupRestoreMessage(this._clientFactory.dateFormatter().formatDate(backup.getCreateDate()), this._clientFactory.dateFormatter().formatTime(backup.getCreateDate())));
            return true;
        }
        this._pageLockedPanel.setVisible(true);
        this._pageRestoreBackupPanel.setVisible(false);
        this._pageLockedByPanel.clear();
        WidgetUtil.i18nLinkedText((String)WIKI_EDITOR_MSG.wikiIsLocked(WidgetUtil.getWrappedKey((int)0)), (HasWidgets.ForIsWidget)this._pageLockedByPanel, (IsWidget[])new IsWidget[]{PersonUtil.profileLink((PersonTeaserModel)backup.getAuthor(), (ClientFactory)this._clientFactory, (PersonUtil.PopupOption)PersonUtil.PopupOption.WITH_POPUP)});
        return true;
    }

    private void setCurrentVersion(@Nonnull WikiVersion currentVersion) {
        this._infoBoxWidget.clearActions();
        IconAnchor fullscreenLink = new IconAnchor();
        fullscreenLink.addStyleName("wikiFullscreenLink");
        fullscreenLink.setIcon(IconType.FULLSCREEN);
        fullscreenLink.setTitle(I18nMediator.BASIC_CONSTANTS.fullscreen());
        fullscreenLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._infoBoxWidget.addAction((Widget)fullscreenLink);
        this._viewPanel.setVisible(true);
        boolean showVersionInfo = currentVersion.getVersion() > 0 && this._wikiEditor.getMay().contains((Object)StaticAction.WIKI_READ_VERSIONS);
        this._versionInfoPanel.setVisible(showVersionInfo);
        this._auhtorInfoPanel.setVisible(showVersionInfo);
        this._currentVersionPanel.clear();
        if (showVersionInfo) {
            this._currentVersionPanel.add(WikiVersionsHandler.linkToVersion((WikiEditorId)this._wikiEditor.getId(), (WikiVersionTeaser)currentVersion));
            this.fillAuthorInfoPanel(currentVersion);
        }
        this._wikiEditorInfoPanel.setVisible(showVersionInfo);
    }

    private void deleteWikiBackup() {
        WikiEditorMediator.getInstance().deleteWikiBackup(this._wikiEditor.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @UiHandler(value={"_deleteBackup"})
    void deleteBackupHandler(@Nonnull ClickEvent ev) {
        this.deleteWikiBackup();
    }

    @UiHandler(value={"_resoreBackup"})
    void restoreBackup(@Nonnull ClickEvent ev) {
        this._presenter.restoreBackup();
        this.setBackup(null);
        this._presenter.setLocked(false);
    }

    @UiHandler(value={"_editIgnoreLock"})
    void ignoreLock(@Nonnull ClickEvent ev) {
        this._presenter.onEdit(false);
        this.setBackup(null);
        this._presenter.setLocked(false);
    }

    public void onSaveError(Throwable cause) {
        this._popupHelper.showErrorPopup(cause);
    }

    public void pageLocked() {
        this.reloadData();
    }

    public void flashLockedMessage() {
        HTMLPanel message = this._pageLockedPanel.isVisible() ? this._pageLockedPanel : this._pageRestoreBackupPanel;
        Element element = message.getElement();
        element.scrollIntoView();
        GlobalEventManager.getInstance().fireAdjustEntityScrollPosition(10);
        message.addStyleName("highlight-error");
        new /* Unavailable Anonymous Inner Class!! */.schedule(1000);
    }
}

