/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.i18n;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.server.CachingUtil;
import com.freiheit.toro.server.business.event.FlushCacheEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Supplier;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.configfile.ConfigFileChangeEvent;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.cache.SingleValueCache;
import de.justsoftware.onx.common.cache.SingleValueWarmedUpCacheFactory;
import de.justsoftware.onx.common.presentation.server.JucoLocaleResolver;
import de.justsoftware.onx.server.i18n.I18nServlet;
import de.justsoftware.onx.server.i18n.I18nServletImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

@Service(value="i18nServlet")
public class I18nServletImpl
implements ServerEventHandler,
I18nServlet,
Controller {
    private static final long TIME_TO_WAIT = 1000L;
    private final I18nService _i18nService;
    private final Settings _settings;
    private final JucoLocaleResolver _localeResolver;
    private final SingleValueCache<I18nServletState> _stateCache;

    @Autowired
    @ParametersAreNonnullByDefault
    public I18nServletImpl(I18nService i18nService, SingleValueWarmedUpCacheFactory singleValueWarmedUpCacheFactory, Settings settings, JucoLocaleResolver localeResolver) {
        this._i18nService = i18nService;
        this._settings = settings;
        this._localeResolver = localeResolver;
        this._stateCache = singleValueWarmedUpCacheFactory.create("i18nservlet", 1000L, (Supplier)new I18nServletStateSupplier(this));
    }

    @Nonnull
    @VisibleForTesting
    static byte[] xor(@Nonnull byte[] a, @Nonnull byte[] b) {
        byte[] result = new byte[Math.max(a.length, b.length)];
        for (int i = 0; i < result.length; ++i) {
            byte av = i < a.length ? a[i] : (byte)0;
            byte bv = i < b.length ? b[i] : (byte)0;
            int rv = av ^ bv;
            result[i] = (byte)rv;
        }
        return result;
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String locale = this._localeResolver.resolveLanguage(request);
        String hash = StringUtils.trimToNull((String)request.getParameter("hash"));
        if (!StringUtils.isBlank((String)request.getParameter("displayPropertyKeys"))) {
            this.handleRequest(((I18nServletState)this._stateCache.get())._displayPropertiesTranslations, request, response, locale, hash);
        } else {
            this.handleRequest(((I18nServletState)this._stateCache.get())._translations, request, response, locale, hash);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(@Nonnull I18nServletTranslations state, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull String locale, @Nonnull String hash) throws IOException {
        String realLocale;
        String content;
        String contentFromMap = (String)state._contentByLocaleMap.get((Object)locale);
        if (contentFromMap != null) {
            response.setLocale(new Locale(locale));
            content = contentFromMap;
            realLocale = locale;
        } else {
            content = state._fallbackContent;
            realLocale = null;
        }
        if (!state._hash.equalsIgnoreCase(hash)) {
            response.setStatus(302);
            StringBuffer redirect = request.getRequestURL().append("?");
            if (realLocale != null) {
                redirect.append("locale=").append(realLocale).append('&');
            }
            redirect.append("hash=").append(state._hash);
            if (state._displayProperties) {
                redirect.append("&displayPropertyKeys");
            }
            response.setHeader("Location", redirect.toString());
        } else {
            response.setStatus(200);
        }
        response.setContentType("text/javascript");
        response.setCharacterEncoding(Charsets.UTF_8.displayName());
        CachingUtil.setCache((HttpServletRequest)request, (HttpServletResponse)response, (long)CachingUtil.CACHING_DURATION_ONE_YEAR);
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            writer.append(content);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public String getCurrentHash() {
        return ((I18nServletState)this._stateCache.get())._translations._hash;
    }

    @Subscribe
    public void onConfigFileChanged(@Nonnull ConfigFileChangeEvent event) {
        this._stateCache.invalidate();
    }

    @Subscribe
    public void onFlushCacheEvent(@Nonnull FlushCacheEvent event) {
        this._stateCache.invalidate();
    }
}

