/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.HTMLUtil;
import com.google.common.collect.ImmutableList;
import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.InlineHyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.FieldNameResolver;
import de.justsoftware.onx.common.shared.model.BadgeField;
import de.justsoftware.onx.searchnew.presentation.client.SearchClientFactory;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchBadgeOverlayView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultBadgeView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultBadgeViewImpl;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SearchResultBadgeViewImpl
extends Composite
implements SearchResultBadgeView {
    private static final SearchResultBadgeViewImplUIBinder UI_BINDER = (SearchResultBadgeViewImplUIBinder)GWT.create(SearchResultBadgeViewImplUIBinder.class);
    @UiField
    Panel _container;
    @UiField
    SimplePanel _iconPanel;
    @UiField
    SimplePanel _title;
    @UiField
    SimplePanel _parent;
    @UiField
    SimplePanel _lastChange;
    @UiField
    SimplePanel _foundIn;
    @UiField
    SimplePanel _optionPanel;
    @UiField
    SimplePanel _contextSwitchPanel;
    private final SearchBadgeOverlayView _foundInOverlay;
    private final SearchBadgeOverlayView _detailsOverlay;
    private final SearchResultBadgeView.Presenter _presenter;
    private HandlerRegistration _iconSelectHandlerRegistration;
    private HandlerRegistration _titleSelectHandlerRegistration;

    public SearchResultBadgeViewImpl(ClientFactory clientFactory, SearchResultBadgeView.Presenter presenter, boolean hasContextSwitch, @Nullable String additionalOverlayStyleName) {
        this._presenter = presenter;
        SearchClientFactory searchClientFactory = clientFactory.searchFactory();
        this._foundInOverlay = searchClientFactory.createSearchBadgeOverlayView(additionalOverlayStyleName);
        this._detailsOverlay = searchClientFactory.createSearchBadgeOverlayView(additionalOverlayStyleName);
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        Roles.getMainRole().set((Element)this._container.getElement());
        this._contextSwitchPanel.setVisible(hasContextSwitch);
    }

    public Widget asWidget() {
        return this;
    }

    public void setIconWidget(Widget icon) {
        if (this._iconSelectHandlerRegistration != null) {
            this._iconSelectHandlerRegistration.removeHandler();
        }
        this._iconSelectHandlerRegistration = this.addOnSelectHandler(icon);
        this._iconPanel.setWidget(icon);
    }

    public void setTitleWidget(InlineHyperlink title) {
        this.setTitleWidget((Widget)title, (Widget)title);
    }

    private HandlerRegistration addOnSelectHandler(Widget widget) {
        return this.addClickEvent(widget, e -> this._presenter.onSelectResult());
    }

    private HandlerRegistration addClickEvent(Widget widget, ClickHandler handler) {
        if (widget instanceof HasClickHandlers) {
            return ((HasClickHandlers)widget).addClickHandler(handler);
        }
        widget.sinkEvents(1);
        return widget.addHandler((EventHandler)handler, (GwtEvent.Type)ClickEvent.getType());
    }

    public void setTitleWidget(Widget title, Widget overlayAndTrackingTarget) {
        if (this._titleSelectHandlerRegistration != null) {
            this._titleSelectHandlerRegistration.removeHandler();
        }
        this._titleSelectHandlerRegistration = this.addOnSelectHandler(overlayAndTrackingTarget);
        this._title.setWidget(title);
        this._detailsOverlay.applyDelayedOpenHandler(overlayAndTrackingTarget, (Widget)this._title);
    }

    public void setParentWidget(Widget subtitle) {
        this._parent.setWidget(subtitle);
    }

    public void setOptionIcon(Widget option) {
        this._optionPanel.setWidget(option);
    }

    public void setLastChangeWidget(Widget lastChange) {
        this._lastChange.setWidget(lastChange);
    }

    public void addDetails(String fieldname, String text) {
        this._detailsOverlay.add(fieldname, SafeHtmlUtils.fromTrustedString((String)HTMLUtil.htmlEscape((String)text)));
    }

    public void addFoundInAndDetails(String fieldname, String originText, BadgeField highlightedField) {
        this._detailsOverlay.add(fieldname, HTMLUtil.highlightedHtmlEscape((String)originText));
        if (highlightedField != null) {
            this.setHasFoundInData(true);
            this._foundInOverlay.add(fieldname, HTMLUtil.mergeHighlighting((String)originText, (Collection)ImmutableList.of((Object)highlightedField.getContent())));
        }
    }

    public void addDetails(String fieldname, Widget widget) {
        this._detailsOverlay.add(fieldname, widget);
    }

    public void addDetails(Collection<BadgeField> badgeFields, FieldNameResolver fieldNameResolver) {
        if (badgeFields != null && !badgeFields.isEmpty()) {
            for (BadgeField field : badgeFields) {
                this._detailsOverlay.add(fieldNameResolver.resolveFieldName(field), HTMLUtil.highlightedHtmlEscape((String)field.getContent()));
            }
        }
    }

    public void addFoundIn(Collection<BadgeField> badgeFields, FieldNameResolver fieldNameResolver) {
        if (badgeFields != null && !badgeFields.isEmpty()) {
            this.setHasFoundInData(true);
            for (BadgeField field : badgeFields) {
                this._foundInOverlay.add(fieldNameResolver.resolveFieldName(field), HTMLUtil.highlightedHtmlEscape((String)field.getContent()));
            }
        }
    }

    private void setHasFoundInData(boolean hasFoundInData) {
        if (hasFoundInData) {
            Label label = new Label(I18nMediator.SEARCH.foundIn());
            this._foundIn.setWidget((Widget)label);
            this._foundInOverlay.applyDelayedOpenHandler((Widget)label, (Widget)this._foundIn);
        } else {
            this._foundIn.clear();
        }
    }

    public void setContextSwitchWidget(Widget contextSwitch) {
        this._contextSwitchPanel.add(contextSwitch);
    }

    public void setParentEnabled(boolean enabled) {
        this._parent.setVisible(enabled);
    }
}

