/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.searchnew.presentation.client.ui.AbstractSearchSelectionFilterPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.ExpansionState;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchSelectionFilterPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SelectionFilterView;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class AbstractSearchSelectionFilterPresenter
implements SearchSelectionFilterPresenter {
    private SearchParameters _searchParameters;
    private final FilterLinkDataProvider _dataProvider;
    private boolean _expanded;
    private boolean _applicable;

    protected AbstractSearchSelectionFilterPresenter(FilterLinkDataProvider dataProvider, SearchParameters searchParameters) {
        this._dataProvider = dataProvider;
        this._searchParameters = searchParameters;
    }

    public final void onSearchParametersChanged(SearchParameters searchParameters) {
        this._searchParameters = searchParameters;
        boolean applicable = this._dataProvider.isFilterApplicable(searchParameters);
        this.setApplicable(applicable);
        if (applicable) {
            this.onSearchParametersChanged();
        }
    }

    protected abstract void onSearchParametersChanged();

    @Nonnull
    protected abstract SelectionFilterView getView();

    public void addToParent(HasWidgets.ForIsWidget parent) {
        parent.add((IsWidget)this.getView());
    }

    @Nonnull
    protected SearchParameters getSearchParameters() {
        return this._searchParameters;
    }

    protected final void setApplicable(boolean applicable) {
        this.getView().setVisible(applicable);
        this._applicable = applicable;
    }

    public final void onToggleExpansion(ExpansionState newState, boolean collapseToRestrictingFilters) {
        this._expanded = (Boolean)newState.accept((ExpansionState.Visitor)new /* Unavailable Anonymous Inner Class!! */);
        this.getView().showByToggler(this._expanded);
    }

    public final boolean isApplicable() {
        return this._applicable;
    }

    public final boolean isCollapsable(boolean collapseToRestrictingFilters) {
        return this._expanded && (!collapseToRestrictingFilters || !this._dataProvider.isRestrictionSelected(this._searchParameters));
    }

    public final boolean isExpandable() {
        return !this._expanded;
    }
}

