/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client;

import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.JustPageExpanded;
import de.justsoftware.onx.common.presentation.client.ui.SmallHeaderView;
import de.justsoftware.onx.common.presentation.client.ui.SmallHeaderViewPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterCallback;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterTabsPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchHeaderView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchHeadlineView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchInputView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultPageView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultWidget;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SearchResultPage
extends JustPageExpanded
implements SearchResultPageView,
SearchResultPageView.Presenter {
    private final ClientFactory _clientFactory;
    private SearchResultWidget _searchresultWidget = null;
    private final SearchHeadlineView.Presenter _searchHeadlinePresenter;
    private final SearchFilterTabsPresenter _searchFilterPresenter;
    private final SearchInputView.Presenter _searchInputPresenter;
    private final SearchHeaderView _searchHeaderView;

    public SearchResultPage(SearchParameters searchParams, ClientFactory clientFactory, String entryToken) {
        this.addStyleName("search-result-page");
        this._clientFactory = clientFactory;
        this._searchHeaderView = (SearchHeaderView)new SmallHeaderViewPresenter(clientFactory, (SmallHeaderView)clientFactory.searchFactory().createSearchHeaderView(entryToken)).getView();
        this._searchHeadlinePresenter = this.createMyContentSwitcher((SmallHeaderView)this._searchHeaderView, searchParams);
        this._searchInputPresenter = this.createSearchInputField(this._searchHeaderView, searchParams);
        this._searchFilterPresenter = this.createFilterTabs(this._searchHeaderView, searchParams);
        this.setHeader((IsWidget)this._searchHeaderView);
        this._searchresultWidget = this._clientFactory.searchFactory().createSearchResultWidget(searchParams, (SearchFilterCallback)this._searchFilterPresenter, null);
        this.setContent((IsWidget)this._searchresultWidget);
    }

    @Nonnull
    private SearchHeadlineView.Presenter createMyContentSwitcher(SmallHeaderView header, SearchParameters searchParams) {
        SearchHeadlineView.Presenter searchHeadlinePresenter = this._clientFactory.searchFactory().createSearchHeadlinePresenter();
        header.addBreadcrumbIcon((IsWidget)searchHeadlinePresenter.getView());
        searchHeadlinePresenter.update(searchParams);
        return searchHeadlinePresenter;
    }

    @Nonnull
    private SearchInputView.Presenter createSearchInputField(SearchHeaderView header, SearchParameters searchParams) {
        boolean showSaveSearchFilterMenu = this._clientFactory.getLoginInfo().isLoggedIn();
        SearchInputView.Presenter searchInputPresenter = this._clientFactory.searchFactory().createSearchInputPresenter(showSaveSearchFilterMenu, "search_page");
        searchInputPresenter.update(searchParams);
        header.getSearchInputWidget().add((IsWidget)searchInputPresenter.getView());
        return searchInputPresenter;
    }

    @Nonnull
    private SearchFilterTabsPresenter createFilterTabs(SearchHeaderView header, SearchParameters searchParams) {
        SearchFilterTabsPresenter searchFilterPresenter = new SearchFilterTabsPresenter(this._clientFactory, searchParams);
        searchFilterPresenter.addToParent(header.getSearchFilterWidget());
        return searchFilterPresenter;
    }

    public void setSearchParameters(SearchParameters searchParameters) {
        if (!searchParameters.hasSameContextIdAs(this._searchresultWidget.getSearchParameters())) {
            this._searchresultWidget = this._clientFactory.searchFactory().createSearchResultWidget(searchParameters, (SearchFilterCallback)this._searchFilterPresenter, null);
        } else {
            this._searchresultWidget.setSearchParameters(searchParameters);
        }
        this.setContent((IsWidget)this._searchresultWidget);
        this._searchHeadlinePresenter.update(searchParameters);
        this._searchInputPresenter.update(searchParameters);
        this._searchFilterPresenter.onSearchParametersChanged(searchParameters);
    }

    public void setBackLinkToken(String token) {
        this._searchHeaderView.setBackLinkToken(token);
    }

    public SearchResultPageView getView() {
        return this;
    }
}

