/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.client.ui;

import com.freiheit.toro.client.mediator.Callback;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.common.presentation.client.LinkUtil;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.shared.model.Link;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.presentation.client.EntityMemberClientService;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.presentation.client.ui.ReactProfileComponent;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.person.presentation.client.PersonMediator;
import de.justsoftware.onx.person.presentation.client.ui.DeletePersonClickHandler;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class DeletePersonClickHandler
implements ClickHandler,
Callback {
    private final ProfileConstants _profileI18nConstants;
    private final PersonId _personId;
    private final EventManager _eventManager;

    public DeletePersonClickHandler(@Nullable PersonId personId, @Nonnull EventManager eventManager, @Nonnull ProfileConstants profileI18nConstants) {
        this._personId = personId;
        this._eventManager = eventManager;
        this._profileI18nConstants = profileI18nConstants;
    }

    public void onClick(ClickEvent event) {
        this.call();
    }

    public void call() {
        String password = this.getPassword();
        TransferEntityAdminRightsCallback callback = new TransferEntityAdminRightsCallback(this, password);
        EntityMemberClientService entityMemberClientService = ClientFactoryImpl.INSTANCE.entityMemberClientFactory().clientService();
        if (this._personId != null) {
            entityMemberClientService.getEntityAdminTransferModel(this._personId, (AsyncCallback)callback);
        } else {
            entityMemberClientService.getEntityAdminTransferModel(password, (AsyncCallback)callback);
        }
    }

    protected abstract String getPassword();

    private void deleteAccount(String password) {
        if (this._personId != null) {
            PersonMediator.getInstance().deleteAccountAsSuperadmin(this._personId, (AsyncCallback)new DeleteAccountCallback(this));
        } else {
            PersonMediator.getInstance().deleteAccount(password, (AsyncCallback)new DeleteAccountCallback(this));
        }
    }

    private FlowPanel createMessageForAdminEntites(Collection<EntityInfo> entities, Collection<EntityId> entityIds, PersonTeaserModel personForAdminRights) {
        FlowPanel linkPanel;
        FlowPanel messagePanel = new FlowPanel();
        messagePanel.add((Widget)new Label(I18nMediator.EXCEPTION.stillAdminInEntites()));
        for (EntityInfo entity : entities) {
            linkPanel = new FlowPanel();
            linkPanel.add((Widget)new Hyperlink(entity.getName(), EntityOverviewHandler.token((EntityId)((EntityId)entity.getId()))));
            messagePanel.add((Widget)linkPanel);
        }
        for (EntityId id : entityIds) {
            linkPanel = new FlowPanel();
            linkPanel.add((Widget)new Label(id.asString()));
            messagePanel.add((Widget)linkPanel);
        }
        if (personForAdminRights == null) {
            messagePanel.add((Widget)new Label(I18nMediator.EXCEPTION.stillAdminInEntitiesHint()));
        } else {
            Link profileLink = new Link(SafeHtmlUtils.htmlEscape((String)personForAdminRights.getFullName()), ReactProfileComponent.token((PersonId)((PersonId)personForAdminRights.getId())));
            messagePanel.add((Widget)new HTML(I18nMediator.PROFILE_MSG.adminRightsWillBeTransferredTo(LinkUtil.getLinkString((Link)profileLink, (boolean)true, (boolean)false))));
        }
        return messagePanel;
    }
}

