/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.client;

import com.freiheit.toro.account.presentation.client.LoginControllerAsync;
import com.freiheit.toro.client.mediator.PageTitleCallback;
import com.freiheit.toro.client.ui.ConfirmPopup;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.TabBar;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.HostPropertiesBean;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.person.presentation.client.AccountSettingsPresenter;
import de.justsoftware.onx.person.presentation.client.DeleteAccountSettingsPresenter;
import de.justsoftware.onx.person.presentation.client.LogoutFromMobileDevicesPresenter;
import de.justsoftware.onx.person.presentation.client.MailNotificationSettingsPresenter;
import de.justsoftware.onx.person.presentation.client.PersonalSettingsPresenter;
import de.justsoftware.onx.person.presentation.client.UserDataSettingsPresenter;
import de.justsoftware.onx.person.presentation.client.ui.AccountSettingsSection;
import de.justsoftware.onx.person.presentation.shared.PersonControllerAsync;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import de.justsoftware.onx.person.shared.util.PersonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AccountSettingsPresenter {
    private final PersonId _personId;
    private final ProfileConstants _profileConstants;
    private final BasicConstants _basicConstants;
    private final PersonControllerAsync _personController;
    private final LoginControllerAsync _loginController;
    private final AccountSettingsView _accountSettingsView;
    private final List<SettingsPresenter> _presenters = new ArrayList();
    private final EventManager _eventManager;
    private final ClientFactory _clientFactory;

    public AccountSettingsPresenter(PersonId personId, AccountSettingsView accountSettingsWidget, ClientFactory clientFactory, PageTitleCallback titleCallback) {
        this._personId = personId;
        this._clientFactory = clientFactory;
        this._personController = clientFactory.personClientFactory().personController();
        this._loginController = clientFactory.personClientFactory().loginController();
        this._eventManager = clientFactory.eventManager();
        this._profileConstants = clientFactory.personClientFactory().profileConstants();
        this._basicConstants = clientFactory.localizedMessages().basicConstants();
        this._accountSettingsView = accountSettingsWidget;
        this._accountSettingsView.clearBreadCrumb();
        this._accountSettingsView.addToBreadCrumb((GlobalId)personId.asProfileId());
        this._accountSettingsView.addToBreadCrumb(this._profileConstants.editAccountSettings());
        titleCallback.setPageTitle(this._profileConstants.editAccountSettings());
        this._accountSettingsView.setBeforeSelectionHandler(event -> {
            ArrayList sections = new ArrayList();
            for (SettingsPresenter presenter : this._presenters) {
                sections.addAll(presenter.getSections());
            }
            for (AccountSettingsSection section : sections) {
                if (!section.hasChanges()) continue;
                ConfirmPopup pop = ConfirmPopup.makeConfirmPopup((String)this._basicConstants.unsavedChanges(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                pop.setButtonTexts(this._basicConstants.looseChanges(), this._basicConstants.back());
                pop.show();
                event.cancel();
                break;
            }
        });
        this._accountSettingsView.setSelectionHandler(event -> {
            TabBar.Tab tab = this._accountSettingsView.getTab(((Integer)event.getSelectedItem()).intValue());
            if (tab != null) {
                tab.fireEvent((GwtEvent)event);
            }
        });
    }

    @Nonnull
    public IsWidget getView() {
        this.createTabs(this._personId);
        return this._accountSettingsView;
    }

    private void createTabs(PersonId personId) {
        this._personController.getProfileSettings(personId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Nonnull
    private MailNotificationSettingsPresenter setUpMailNotifications(PersonId personId) {
        return new MailNotificationSettingsPresenter(personId, (HasWidgets)this._accountSettingsView.addTab(this._basicConstants.emailNotifications()));
    }

    @Nonnull
    private UserDataSettingsPresenter setUpUserData(PersonId personId) {
        return new UserDataSettingsPresenter(personId, (HasWidgets)this._accountSettingsView.addTab(this._basicConstants.userData()));
    }

    @Nonnull
    private LogoutFromMobileDevicesPresenter setUpLogoutFromMobileDevices(PersonId personId, long mobileDevicesCount) {
        return new LogoutFromMobileDevicesPresenter((HasWidgets)this._accountSettingsView.addTab(this._basicConstants.logoutFromMobileDevices()), this._loginController, this._basicConstants, personId, mobileDevicesCount);
    }

    protected void setupPersonalSettingsTab() {
        PersonalSettingsPresenter presenter = new PersonalSettingsPresenter(this._clientFactory.personClientFactory(), this._clientFactory.localizedMessages().basicConstants());
        if (presenter.hasContent()) {
            presenter.addToParent((HasWidgets)this._accountSettingsView.addTab(this._profileConstants.accountSettingsPersonalSettings()));
            this._presenters.add(presenter);
        }
    }

    @Nonnull
    private DeleteAccountSettingsPresenter setUpDeleteAccount() {
        return new DeleteAccountSettingsPresenter((HasWidgets)this._accountSettingsView.addTab(this._basicConstants.deleteAccount()), this._eventManager);
    }

    public static boolean isPasswordSectionVisible() {
        HostPropertiesBean properties = HostPropertiesMediator.getHostPropertiesBean();
        ImmutableSet hiddenFields = properties.getHiddenPersonFields();
        String[] additionalWildcards = new String[]{"person.*"};
        return !PersonUtil.isHidden((String)"person.password", (Set)hiddenFields, (String[])additionalWildcards);
    }

    public static boolean isEmailSectionVisible() {
        HostPropertiesBean properties = HostPropertiesMediator.getHostPropertiesBean();
        ImmutableSet hiddenFields = properties.getHiddenPersonFields();
        String[] additionalWildcards = new String[]{"person.*"};
        return !PersonUtil.isHidden((String)"person.email", (Set)hiddenFields, (String[])additionalWildcards);
    }
}

