/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.heartbeat.business;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.cache.ehcache.EhCacheHeartbeatService;
import com.freiheit.toro.cache.memcached.MemcachedClientCache;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.heartbeat.business.AuthenticationInternalApiConnector;
import de.justsoftware.onx.heartbeat.business.HeartbeatController;
import de.justsoftware.onx.heartbeat.integration.persistence.HeartbeatDAO;
import de.justsoftware.onx.migration.business.JustImportApiConnector;
import de.justsoftware.onx.monitoring.business.LdapMonitoringService;
import de.justsoftware.onx.monitoring.business.model.LdapNotConfiguredException;
import de.justsoftware.onx.server.business.JucoServerVersionService;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import de.justsoftware.session.RedisHealthService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@ParametersAreNonnullByDefault
public class HeartbeatController {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatController.class);
    private final HeartbeatDAO _heartbeatDao;
    private final MemcachedClientCache _memcachedClient;
    private final EhCacheHeartbeatService _ehCacheHeartbeatService;
    private final SolrClient _readSolrServer;
    private final SolrClient _writeSolrServer;
    private final Settings _settings;
    private final PermissionRequestConnector _permissionRequestConnector;
    private final Optional<JustImportApiConnector> _justImportApiConnector;
    private final StorageServerHelper _storageServerHelper;
    private final AuthenticationInternalApiConnector _authenticationApiConnector;
    private final RedisHealthService _redisHealthService;
    private final JucoServerVersionService _jucoServerVersionService;
    private final LdapMonitoringService _ldapMonitoringService;

    @Autowired
    public HeartbeatController(HeartbeatDAO heartbeatDao, MemcachedClientCache memcachedClient, EhCacheHeartbeatService ehCacheHeartbeatService, @Qualifier(value="readSolrServer") SolrClient readSolrServer, @Qualifier(value="writeSolrServer") SolrClient writeSolrServer, Settings settings, PermissionRequestConnector permissionRequestConnector, Optional<JustImportApiConnector> justImportApiConnector, StorageServerHelper storageServerHelper, AuthenticationInternalApiConnector authenticationApiConnector, Optional<RedisHealthService> redisHealthService, JucoServerVersionService jucoServerVersionService, @Nullable LdapMonitoringService ldapMonitoringService) {
        this._heartbeatDao = heartbeatDao;
        this._memcachedClient = memcachedClient;
        this._ehCacheHeartbeatService = ehCacheHeartbeatService;
        this._readSolrServer = readSolrServer;
        this._writeSolrServer = writeSolrServer;
        this._settings = settings;
        this._permissionRequestConnector = permissionRequestConnector;
        this._justImportApiConnector = justImportApiConnector;
        this._storageServerHelper = storageServerHelper;
        this._authenticationApiConnector = authenticationApiConnector;
        this._jucoServerVersionService = jucoServerVersionService;
        this._redisHealthService = redisHealthService.orElse(null);
        this._ldapMonitoringService = ldapMonitoringService;
    }

    @RequestMapping(value={"/rest/heartbeat"}, method={RequestMethod.GET, RequestMethod.HEAD})
    public void getHeartBeat(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/plain");
        response.addHeader("Allow", "GET, HEAD");
        if (!"GET".equals(request.getMethod()) && !"HEAD".equals(request.getMethod())) {
            response.getOutputStream().print("Method not allowed");
            response.setStatus(405);
            return;
        }
        StatusBuilder result = this.getHealthStatus();
        response.getOutputStream().print(result._resultBuilder.toString());
        response.setStatus(result._ok ? 200 : 500);
    }

    private StatusBuilder getHealthStatus() {
        StatusBuilder result = new StatusBuilder().addStatus("database", this.testDatabase()).addStatus("cache", this.testMemcached()).addStatus("ehcache", this.testEhcache()).addStatus("solr", this.testSolr()).addStatus("storage", this.testStorage()).addStatus("redis", this.testRedis()).addStatus("permission", this.testPermission()).addStatus("updateProcesses", this.testUpdateProcesses());
        if (this._ldapMonitoringService != null) {
            result.addStatus("ldapConnection", this.testLDAPConnection());
        }
        if (this._settings.isImportUserGroupsEnabled()) {
            result.addStatus("just-import", this.testJustImport());
        }
        if (this._settings.isAdfsEnabled()) {
            result.addStatus("authentication", this.testAuthentication());
        }
        return result;
    }

    @RequestMapping(value={"/rest/heartbeat/json"}, method={RequestMethod.GET, RequestMethod.HEAD}, produces={"application/json"})
    public ResponseEntity<Map<String, Object>> health() {
        StatusBuilder healthStatus = this.getHealthStatus();
        Map resultMap = Map.of("status", healthStatus._httpStatus == HttpStatus.OK ? "UP" : "DOWN", "components", Map.copyOf(healthStatus._statusMap));
        return ResponseEntity.status((HttpStatus)healthStatus._httpStatus).body(resultMap);
    }

    @Nonnull
    private Status testStorage() {
        try {
            this._storageServerHelper.checkHealth();
            return Status.OK;
        }
        catch (RuntimeException e) {
            return this.handleException("error checking storage", (Exception)e);
        }
    }

    @Nonnull
    private Status testEhcache() {
        try {
            return this._ehCacheHeartbeatService.isAlive() ? Status.OK : Status.ERROR;
        }
        catch (RuntimeException e) {
            return this.handleException("error checking ehcache", (Exception)e);
        }
    }

    @Nonnull
    private Status testDatabase() {
        try {
            this._heartbeatDao.selectNow();
            return Status.OK;
        }
        catch (SQLException e) {
            return this.handleException("Heartbeat DAO request failed on SQL level", (Exception)e);
        }
        catch (DAOException e) {
            return this.handleException("Heartbeat DAO request failed on DAO level", (Exception)((Object)e));
        }
    }

    @Nonnull
    private Status testUpdateProcesses() {
        try {
            return this._jucoServerVersionService.getAllUpdateProcessesFinished() ? Status.OK : Status.ERROR;
        }
        catch (Exception e) {
            return this.handleException("Heartbeat update processes failed", e);
        }
    }

    @Nonnull
    private Status testMemcached() {
        try {
            this._memcachedClient.testCache();
            return Status.OK;
        }
        catch (InterruptedException e) {
            return this.handleException("Heartbeat cache request failed due to thread interruption", (Exception)e);
        }
        catch (ExecutionException e) {
            return this.handleException("Heartbeat cache request failed due to execution", (Exception)e);
        }
        catch (TimeoutException e) {
            return this.handleException("Heartbeat cache request failed due to timeout", (Exception)e);
        }
    }

    @Nonnull
    private Status testSolr() {
        try {
            this._readSolrServer.ping();
            this._writeSolrServer.ping();
            return Status.OK;
        }
        catch (IOException | SolrServerException e) {
            return this.handleException("Heartbeat Solr request failed", (Exception)e);
        }
    }

    @Nonnull
    private Status handleException(String message, Exception e) {
        LOG.error(message, (Throwable)e);
        return Status.ERROR;
    }

    @Nonnull
    private Status testPermission() {
        return this._permissionRequestConnector.heartbeat() ? Status.OK : Status.ERROR;
    }

    @Nonnull
    private Status testAuthentication() {
        try {
            this._authenticationApiConnector.checkHealth();
            return Status.OK;
        }
        catch (RuntimeException e) {
            return this.handleException("Health check for just-authentication failed", (Exception)e);
        }
    }

    @Nonnull
    private Status testJustImport() {
        try {
            ((JustImportApiConnector)this._justImportApiConnector.orElseThrow(() -> new ServiceException("Import api connector not configured"))).checkHealth();
            return Status.OK;
        }
        catch (RuntimeException e) {
            return this.handleException("Health check for just-import failed", (Exception)e);
        }
    }

    @Nonnull
    private Status testRedis() {
        try {
            this._redisHealthService.checkHealth();
            return Status.OK;
        }
        catch (RedisHealthService.RedisHealthException | DataAccessException e) {
            return this.handleException("Health check for Redis failed", (Exception)e);
        }
    }

    @Nonnull
    private Status testLDAPConnection() {
        try {
            ImmutableList errors = this._ldapMonitoringService.checkLdapConnection();
            if (errors.isEmpty()) {
                return Status.OK;
            }
        }
        catch (LdapNotConfiguredException e) {
            return Status.OK;
        }
        return Status.ERROR;
    }
}

