/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.common.presentation.client.ui.InlineActionFeedbackLabel;
import de.justsoftware.onx.common.shared.i18n.DateFormatter;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.presentation.client.ui.JoinChildEntityItem;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMembershipInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;

public class JoinChildEntityItem
extends Composite {
    private static final JoinChildEntityUIBinder UI_BINDER = (JoinChildEntityUIBinder)GWT.create(JoinChildEntityUIBinder.class);
    @UiField
    Label _statusText;
    @UiField
    Hyperlink _title;
    @UiField
    InlineActionFeedbackLabel _feedbackLabel;
    @UiField
    CheckBox _wantParticipant;
    @UiField
    Label _duration;
    private EntityMembershipInfo _membershipInfo;
    private EntityConstants _entityConstants;

    public JoinChildEntityItem(@Nonnull EntityMembershipInfo membershipInfo) {
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this._wantParticipant.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.setEntityMembershipInfo(membershipInfo);
    }

    private void joinOrLeave() {
        this._feedbackLabel.showWaiting();
        ClientFactoryImpl.INSTANCE.entityMemberClientFactory().clientService().joinOrDisjoinEntityAndReturnEntityMembershipInfo((EntityId)this._membershipInfo.getEntityInfo().getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setEntityMembershipInfo(@Nonnull EntityMembershipInfo membershipInfo) {
        this._membershipInfo = membershipInfo;
        this._entityConstants = I18nMediator.getEntityConstantsByEntityType((EntityType)((EntityType)this._membershipInfo.getEntityInfo().getType()));
        this._feedbackLabel.setText(this._entityConstants.statusSaved());
        if (this._membershipInfo.isClosed() || this._membershipInfo.isInThePast()) {
            this._wantParticipant.setEnabled(!this._membershipInfo.isClosed() && !this._membershipInfo.isInThePast());
        }
        this._wantParticipant.setValue(Boolean.valueOf(EntityMemberRoles.isMember((Set)this._membershipInfo.getMemberRoles())));
        ClientEntityConfig config = HostPropertiesMediator.getClientEntityConfig((EntityType)((EntityType)this._membershipInfo.getEntityInfo().getType()));
        this._title.setText(this._membershipInfo.getEntityInfo().getName());
        this._title.setTargetHistoryToken(EntityOverviewHandler.token((EntityId)((EntityId)this._membershipInfo.getEntityInfo().getId())));
        Date startAt = this._membershipInfo.getStartAt();
        Date endAt = this._membershipInfo.getEndAt();
        if (config.getDurationTimeOption() != EntityDurationTimeOption.OFF && startAt != null && endAt != null) {
            this._duration.setVisible(true);
            this._duration.setText(Dates.formatDuration((DateFormatter)ClientFactoryImpl.INSTANCE.dateFormatter(), (Date)startAt, (Date)endAt, (TimeZone)this._membershipInfo.getEntityInfo().getTimeZone()));
        } else {
            this._duration.setVisible(false);
        }
        this._statusText.setText(this.getStatusText());
    }

    @Nonnull
    private String getStatusText() {
        if (this._membershipInfo == null) {
            return "";
        }
        ImmutableSet memberRoles = this._membershipInfo.getMemberRoles();
        if (EntityMemberRoles.hasSentJoinRequest((Set)memberRoles)) {
            return this._entityConstants.youHaveRequestToAttend();
        }
        if (!EntityMemberRoles.isMember((Set)memberRoles)) {
            return "";
        }
        if (this._membershipInfo.isInThePast()) {
            return this._entityConstants.youHadAttended();
        }
        return this._entityConstants.participantStatusText();
    }

    public void setEnabled(boolean enabled) {
        this._wantParticipant.setEnabled(enabled);
    }
}

