/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineHyperlink;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.album.presentation.client.ui.AlbumsOverviewWidget;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.events.ClientEvent;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.container.presentation.client.EntityChangedEvent;
import de.justsoftware.onx.container.presentation.client.presenter.InformationTabPresenter;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.presentation.client.ui.navigator.EntityNavigatorPresenter;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.i18n.EntityMessages;
import de.justsoftware.onx.container.shared.model.ChildEntityTab;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityDetailsPublicData;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.EntityTabVisitor;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.StaticEntityTab;
import de.justsoftware.onx.drive.presentation.client.JustDriveFolderApp;
import de.justsoftware.onx.searchnew.presentation.client.SearchHandler;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultWidget;
import de.justsoftware.onx.searchnew.shared.model.DateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import de.justsoftware.onx.survey.presentation.client.ui.presenters.SurveyListPresenter;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityTabContentCreator
implements EntityTabVisitor<IsWidget> {
    private EntityDetails _entity;
    private final ClientFactory _clientFactory;
    private SearchParameters _searchParameters;
    private JustDriveFolderApp _driveApp;
    private SearchParameters.SearchParametersChangedListener _currentSearchParametersChangedListener;

    public EntityTabContentCreator(EntityDetails entity, ClientFactory clientFactory, @Nullable SearchParameters searchParameters) {
        this._entity = entity;
        this._clientFactory = clientFactory;
        this._searchParameters = searchParameters;
    }

    public IsWidget visitChildEntities(EntityType entityType) {
        ClientEntityConfig entityConfig = this._clientFactory.entityFactory().entityConfig(entityType);
        return EntityDurationTimeOption.OFF.equals((Object)entityConfig.getDurationTimeOption()) ? this.getSearchTabContent((EntityTab)new ChildEntityTab(entityType), FilterTypes.getByEntityType((EntityType)entityType)) : this.getSearchTabContent((EntityTab)new ChildEntityTab(entityType), FilterTypes.getByEntityType((EntityType)entityType), this.getNoResultViewEvents(entityType));
    }

    public IsWidget visitPictures() {
        this._searchParameters = null;
        return new AlbumsOverviewWidget((GlobalId)this._entity.getId(), false, this._clientFactory);
    }

    public IsWidget visitSurveys() {
        this._searchParameters = null;
        SurveyListPresenter presenter = new SurveyListPresenter(this._entity.getId(), this._clientFactory.surveyClientFactory(), this._clientFactory.surveyClientFactory().i18nConstants());
        return presenter.getView();
    }

    public IsWidget visitMember() {
        return this.getSearchTabContent((EntityTab)StaticEntityTab.MEMBER, (FilterType)StaticFilterType.PROFILES);
    }

    @Nonnull
    private EntityConstants entityConstants() {
        return I18nMediator.getEntityConstantsByEntityType((EntityType)this._entity.getType());
    }

    @Nonnull
    private IsWidget getSearchTabContent(EntityTab tab, FilterType filterType) {
        return this.getSearchTabContent(tab, filterType, null);
    }

    @Nonnull
    private IsWidget getSearchTabContent(EntityTab tab, FilterType filterType, @Nullable IsWidget customNoResultView) {
        if (this._searchParameters == null || !filterType.equals(this._searchParameters.getFilterType())) {
            this._searchParameters = SearchHandler.entitySpecificParameters((EntityDetailsPublicData)this._entity, (FilterType)filterType);
        }
        SearchResultWidget searchTabContent = this._clientFactory.entityFactory().getEntitySearchTabWidget(this._entity.getId(), tab, this._searchParameters, customNoResultView);
        this._currentSearchParametersChangedListener = new /* Unavailable Anonymous Inner Class!! */;
        return searchTabContent;
    }

    @Nonnull
    private IsWidget getNoResultViewEvents(EntityType entityType) {
        EntityMessages messages = I18nMediator.getEntityMessagesByEntityType((EntityType)entityType);
        boolean isFuture = DateSubFilter.FUTURE.equals((Object)this._searchParameters.getDateSubfilter());
        FlowPanel messagePanel = new FlowPanel();
        if (isFuture) {
            SearchParameters pastEventsParameters = this._searchParameters.withSubfilters((Set)ImmutableSet.of((Object)DateSubFilter.PAST)).withSortType(SortType.TIME_DESCENDING);
            messagePanel.add((Widget)new Label(messages.noFutureEvents()));
            messagePanel.add((Widget)new InlineHyperlink(messages.showPastEvents(), SearchHandler.tokenFor((SearchParameters)pastEventsParameters)));
        } else {
            SearchParameters futureEventsParameters = this._searchParameters.withSubfilters((Set)ImmutableSet.of((Object)DateSubFilter.FUTURE)).withSortType(SortType.TIME_ASCENDING);
            messagePanel.add((Widget)new Label(messages.noPastEvents()));
            messagePanel.add((Widget)new InlineHyperlink(messages.showFutureEvents(), SearchHandler.tokenFor((SearchParameters)futureEventsParameters)));
        }
        return messagePanel;
    }

    public IsWidget visitDashboard() {
        return new FlowPanel();
    }

    public IsWidget visitInformation() {
        return new InformationTabPresenter(this._clientFactory, this._entity).getView();
    }

    public IsWidget visitHierarchy() {
        EntityNavigatorPresenter navigatorPresenter = new EntityNavigatorPresenter(this._clientFactory, (EntityInfo)this._entity, this._searchParameters);
        this._currentSearchParametersChangedListener = navigatorPresenter;
        return navigatorPresenter.getView();
    }

    public IsWidget visitDocuments() {
        EntityId entityId = this._entity.getId();
        if (this._driveApp == null || !this._driveApp.getRootItemId().equals((Object)entityId)) {
            CoreApp app = this._entity.getApp();
            String historyBaseName = EntityOverviewHandler.token((EntityId)entityId, (EntityTab)StaticEntityTab.DOCUMENTS);
            this._driveApp = new JustDriveFolderApp(app, (GlobalId)entityId, historyBaseName, () -> this._clientFactory.eventManager().handleEvent((ClientEvent)new EntityChangedEvent(this._entity.getId(), this._entity.getType())));
        }
        return this._driveApp;
    }

    public IsWidget visitSeparator() {
        throw new UnsupportedOperationException();
    }

    public IsWidget visitPrintPreview() {
        throw new UnsupportedOperationException();
    }

    public IsWidget visitArchivedContent() {
        throw new UnsupportedOperationException();
    }

    public void onSearchParametersChanged(SearchParameters parameters) {
        this._searchParameters = parameters;
        if (this._currentSearchParametersChangedListener != null) {
            this._currentSearchParametersChangedListener.onSearchParametersChanged(parameters);
        }
    }

    public void setEntity(EntityDetails entity) {
        this._entity = entity;
    }
}

