/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.github.gwtbootstrap.client.ui.ButtonGroup;
import com.github.gwtbootstrap.client.ui.NavHeader;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiFactory;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasVisibility;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.jsinterop.Callback;
import de.justsoftware.gwt.user.client.ui.JucoDropdownButton;
import de.justsoftware.onx.administration.presentation.client.AdministrationClientFactory;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.PersonRoleListItem;
import de.justsoftware.onx.common.presentation.client.ui.WaitSpinner;
import de.justsoftware.onx.common.presentation.client.ui.components.AuthorityListPresenter;
import de.justsoftware.onx.common.presentation.client.ui.form.impl.Section;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.container.presentation.client.EntityMediator;
import de.justsoftware.onx.container.presentation.client.presenter.EditEntityLinkCreator;
import de.justsoftware.onx.container.presentation.client.ui.EntityEditView;
import de.justsoftware.onx.container.presentation.client.ui.EntityPrivacyConfiguratorWidget;
import de.justsoftware.onx.container.presentation.shared.model.entityedit.PrivacyEntityEditModel;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EditEntityHistoryTokenTabName;
import de.justsoftware.onx.container.shared.model.EntityExtendedData;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.db.DBEntityLinkedEntityPrivacy;
import de.justsoftware.onx.container.shared.model.db.DBPrivacyType;
import de.justsoftware.onx.design.client.util.CssClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityPrivacyConfiguratorWidget
extends Composite
implements EntityEditView {
    private static final EntityPrivacyConfiguratorWidgetUIBinder UI_BINDER = (EntityPrivacyConfiguratorWidgetUIBinder)GWT.create(EntityPrivacyConfiguratorWidgetUIBinder.class);
    @UiField
    Section _invitingRuleSection;
    @UiField
    Section _newsletterRuleSection;
    @UiField
    Section _subordinationSection;
    @UiField
    FlowPanel _invitingRulePanel;
    @UiField
    FlowPanel _newsletterRulePanel;
    @UiField
    JCButton _finishButton;
    @UiField
    ButtonGroup _submitButtons;
    @UiField
    JCButton _cancelLink;
    @UiField
    FlowPanel _linkedEntityPrivacySettingsPanel;
    @UiField
    WaitSpinner _waitIcon;
    @UiField
    InlineFeedbackWidget _feedbackWidget;
    private final EntityId _entityId;
    private final PrivacyEntityEditModel _entityEditModel;
    private final EntityConstants _entityConstants;
    private final ClientEntityConfig _entityTypeConfig;
    private final ClientFactory _clientFactory;
    private final AdministrationClientFactory _administrationClientFactory;
    private final Callback<EditEntityHistoryTokenTabName> _submitCallback;
    private final Callback<String> _cancelCallback;
    private final JucoDropdownButton _continueButton = new JucoDropdownButton();
    @CheckForNull
    private AuthorityListPresenter _inviting;
    @CheckForNull
    private AuthorityListPresenter _newsletter;
    private Map<EntityType, AuthorityListPresenter> _listItemPanelsForEntityLinking = Maps.newHashMap();

    @ParametersAreNonnullByDefault
    public EntityPrivacyConfiguratorWidget(ClientFactory clientFactory, EntityId entityId, PrivacyEntityEditModel entityEditModel, Callback<EditEntityHistoryTokenTabName> submitCallback, Callback<String> cancelCallback) {
        this._entityId = entityId;
        this._entityEditModel = entityEditModel;
        this._clientFactory = clientFactory;
        this._administrationClientFactory = clientFactory.administrationClientFactory();
        this._entityTypeConfig = HostPropertiesMediator.getClientEntityConfig((EntityType)entityEditModel.getEntityType());
        this._entityConstants = I18nMediator.getEntityConstantsByEntityType((EntityType)entityEditModel.getEntityType());
        this._submitCallback = submitCallback;
        this._cancelCallback = cancelCallback;
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this._cancelLink.addClickHandler(event -> this._cancelCallback.call(null));
        this.initEntityPrivacyOption(this._entityEditModel.getPrivacySelections());
        this.initEntityLinkedEntityPrivacyOption(this._entityEditModel.getEntityLinkedPrivacies());
        this.configureContinueButton(entityEditModel);
    }

    private void configureContinueButton(PrivacyEntityEditModel editModel) {
        this._continueButton.setDropup(true);
        this._continueButton.add((Widget)new NavHeader(this._entityConstants.finishAndContinueTo()));
        ImmutableMap visibleTabs = FluentIterable.from((Iterable)editModel.getVisibleTabs()).filter(tab -> EditEntityHistoryTokenTabName.PRIVACY != tab).toMap(tab -> e -> this.save(tab));
        if (!visibleTabs.isEmpty()) {
            this.addSaveAndContinueButton(visibleTabs);
        }
    }

    public void addSaveAndContinueButton(ImmutableMap<EditEntityHistoryTokenTabName, ClickHandler> visibleTabs) {
        this._submitButtons.add((Widget)this._continueButton);
        visibleTabs.forEach((tab, clickHandler) -> this._continueButton.add((Widget)EditEntityLinkCreator.createLink((EditEntityHistoryTokenTabName)tab, (ClickHandler)clickHandler, (EntityConstants)this._entityConstants)));
    }

    private void enableSubmit(boolean enabled) {
        this._finishButton.setEnabled(enabled);
        this._continueButton.setEnabled(enabled);
        this._waitIcon.setVisible(!enabled);
    }

    private void addRow(@Nonnull HasWidgets parentWidget, @Nonnull String labelText, @Nonnull AuthorityListPresenter presenter) {
        FlowPanel wrapper = new FlowPanel();
        wrapper.addStyleName(CssClassUtil.asWellFormedAndNamespaced((String[])new String[]{"control-group", "full-width"}));
        wrapper.add((Widget)new Label(labelText));
        presenter.show((HasWidgets.ForIsWidget)wrapper);
        parentWidget.add((Widget)wrapper);
    }

    private void initEntityLinkedEntityPrivacyOption(@Nonnull ImmutableMap<EntityType, DBEntityLinkedEntityPrivacy> entityLinkedPrivacies) {
        if (entityLinkedPrivacies.isEmpty()) {
            this._subordinationSection.removeFromParent();
        }
        this._linkedEntityPrivacySettingsPanel.clear();
        this._listItemPanelsForEntityLinking = this.addOptionsToListItemPanelForEntityLinking(entityLinkedPrivacies);
    }

    @Nonnull
    private Map<EntityType, AuthorityListPresenter> addOptionsToListItemPanelForEntityLinking(@Nonnull Map<EntityType, DBEntityLinkedEntityPrivacy> displayPrivacyData) {
        HashMap listItemPanelsForEntityLinking = Maps.newHashMap();
        for (Map.Entry<EntityType, DBEntityLinkedEntityPrivacy> entry : displayPrivacyData.entrySet()) {
            DBEntityLinkedEntityPrivacy privacy = entry.getValue();
            EntityType type = entry.getKey();
            AuthorityListPresenter presenter = new AuthorityListPresenter(this._administrationClientFactory, PersonRoleListItem.fromAuthorityModelList((Collection)privacy.getAvailableAuthories()), privacy.getSelectedAuthorityNames());
            if (!presenter.isContainsVisibleAuthorities()) continue;
            EntityConstants constantsByEntityType = I18nMediator.getEntityConstantsByEntityType((EntityType)type);
            this.addRow((HasWidgets)this._linkedEntityPrivacySettingsPanel, constantsByEntityType.entity(type), presenter);
            listItemPanelsForEntityLinking.put(type, presenter);
        }
        return listItemPanelsForEntityLinking;
    }

    private void initEntityPrivacyOption(@Nonnull ImmutableSetMultimap<DBPrivacyType, String> privacySelection) {
        this.renderInvitingSection(privacySelection);
        this.renderNewsletterSection(privacySelection);
    }

    private void renderInvitingSection(@Nonnull ImmutableSetMultimap<DBPrivacyType, String> privacySelection) {
        this._inviting = new AuthorityListPresenter(this._administrationClientFactory, PersonRoleListItem.fromAuthorityModelList((Collection)this._entityTypeConfig.getAvailableRuleAuthNames().get((Object)DBPrivacyType.INVITING)), privacySelection.get((Object)DBPrivacyType.INVITING)).show((HasWidgets.ForIsWidget)this._invitingRulePanel, (HasVisibility)this._invitingRuleSection);
    }

    private void renderNewsletterSection(@Nonnull ImmutableSetMultimap<DBPrivacyType, String> privacySelection) {
        this._newsletter = new AuthorityListPresenter(this._administrationClientFactory, PersonRoleListItem.fromAuthorityModelList((Collection)this._entityTypeConfig.getAvailableRuleAuthNames().get((Object)DBPrivacyType.NEWSLETTER)), privacySelection.get((Object)DBPrivacyType.NEWSLETTER)).show((HasWidgets.ForIsWidget)this._newsletterRulePanel, (HasVisibility)this._newsletterRuleSection);
    }

    @UiFactory
    public EntityConstants getEntityConstants() {
        return this._entityConstants;
    }

    @UiHandler(value={"_finishButton"})
    void handleCreateAndFinishButton(ClickEvent event) {
        this.save(null);
    }

    private void save(@Nullable EditEntityHistoryTokenTabName nextTab) {
        this.enableSubmit(false);
        ArrayList<DBEntityLinkedEntityPrivacy> toSave = new ArrayList<DBEntityLinkedEntityPrivacy>();
        for (EntityType entityType : HostPropertiesMediator.getHostPropertiesBean().getActiveOrderedEntityTypes()) {
            AuthorityListPresenter presenter = (AuthorityListPresenter)this._listItemPanelsForEntityLinking.get(entityType);
            if (presenter == null) continue;
            DBEntityLinkedEntityPrivacy privacy = new DBEntityLinkedEntityPrivacy();
            privacy.setSelectedAuthorityNames(presenter.getSelected());
            privacy.setEntityId(this._entityId);
            privacy.setEntityType(entityType);
            toSave.add(privacy);
        }
        EntityExtendedData settings = new EntityExtendedData(this._entityId, toSave, EntityPrivacyConfiguratorWidget.getSelectedUniqueKeys((AuthorityListPresenter)this._inviting), EntityPrivacyConfiguratorWidget.getSelectedUniqueKeys((AuthorityListPresenter)this._newsletter));
        EntityMediator.getInstance().saveEntityPrivacy(settings, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @CheckForNull
    private static List<String> getSelectedUniqueKeys(@Nullable AuthorityListPresenter presenter) {
        return presenter != null ? presenter.getSelected().asList() : null;
    }
}

