/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.account.presentation.ui.SuperAdminFunctionsWidget;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.github.gwtbootstrap.client.ui.ButtonGroup;
import com.github.gwtbootstrap.client.ui.Form;
import com.github.gwtbootstrap.client.ui.NavHeader;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.jsinterop.Callback;
import de.justsoftware.gwt.user.client.ui.JucoDropdownButton;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.container.presentation.client.EntityDeletedOrMemberRoleChangedEvent;
import de.justsoftware.onx.container.presentation.client.presenter.EditEntityLinkCreator;
import de.justsoftware.onx.container.presentation.client.ui.EntityEditView;
import de.justsoftware.onx.container.presentation.client.ui.EntityMemberConfiguratorPagingWidget;
import de.justsoftware.onx.container.presentation.shared.model.entityedit.MemberEntityEditModel;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EditEntityHistoryTokenTabName;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberConfiguratorInfo;
import de.justsoftware.onx.container.shared.model.EntityMemberPagerParams;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberWorkflow;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.InheritsRole;
import de.justsoftware.onx.container.shared.model.RoleOrInheritedRole;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityMemberConfiguratorWidget
extends Composite
implements EntityEditView {
    private final EntityId _entityId;
    private final EntityConstants _entityConstants;
    private final ClientEntityConfig _currentEntityTypeConfig;
    private final ClientFactory _clientFactory;
    private final EventManager.EventManagerHelper _eventManagerHelper;
    private final List<EntityMemberConfiguratorPagingWidget> _memberConfiguratorWidgets = Lists.newArrayList();
    private final Callback<EditEntityHistoryTokenTabName> _submitCallback;
    private final Callback<String> _cancelCallback;
    private final FlowPanel _bottomPanel = new FlowPanel();
    private final ButtonGroup _submitButtons = new ButtonGroup();
    private IconAnchor _exportLink = null;
    private MemberEntityEditModel _entityEditModel;

    public EntityMemberConfiguratorWidget(@Nonnull EntityId entityId, @Nonnull MemberEntityEditModel entityEditModel, @Nonnull ClientFactory clientFactory, @Nonnull Callback<EditEntityHistoryTokenTabName> submitCallback, @Nonnull Callback<String> cancelCallback) {
        this._entityId = entityId;
        this._entityEditModel = entityEditModel;
        this._clientFactory = clientFactory;
        this._submitCallback = submitCallback;
        this._cancelCallback = cancelCallback;
        this._eventManagerHelper = new EventManager.EventManagerHelper(this._clientFactory.eventManager());
        this._entityConstants = I18nMediator.getEntityConstantsByEntityType((EntityType)entityEditModel.getEntityType());
        this._currentEntityTypeConfig = HostPropertiesMediator.getClientEntityConfig((EntityType)entityEditModel.getEntityType());
        this.createEntityMemberConfiguratorPagingWidget((RoleOrInheritedRole)EntityMemberRole.ADMIN, this._entityConstants.admin(), "", EntityMemberConfiguratorPagingWidget.EntityMemberConfiguratorListType.ADMINISTRATION_LIST);
        this.createEntityMemberConfiguratorPagingWidget((RoleOrInheritedRole)EntityMemberRole.CO_ADMIN, this._entityConstants.coAdmins(), "", EntityMemberConfiguratorPagingWidget.EntityMemberConfiguratorListType.ADMINISTRATION_LIST);
        this.createEntityMemberConfiguratorPagingWidget((RoleOrInheritedRole)InheritsRole.INHERIT_ADMINS, this._entityConstants.inheritedAdmins(), this._entityConstants.inheritedAdminsTooltip(), EntityMemberConfiguratorPagingWidget.EntityMemberConfiguratorListType.ADMINISTRATION_LIST);
        this._currentEntityTypeConfig.getEntityMemberWorkflow().accept((EntityMemberWorkflow.Visitor)new /* Unavailable Anonymous Inner Class!! */);
        FlowPanel panel = new FlowPanel();
        Form form = this.createContent();
        panel.add((Widget)form);
        this.createFinishButtons();
        this._bottomPanel.addStyleName("form-actions");
        this._bottomPanel.add((Widget)this._submitButtons);
        form.add((Widget)this._bottomPanel);
        this.initWidget((Widget)panel);
        this.updateInternal();
    }

    protected void onLoad() {
        super.onLoad();
        this._eventManagerHelper.registerListener(EntityDeletedOrMemberRoleChangedEvent.class, event -> {
            if (event.getEntityId().equals((Object)this._entityId) && !event.isEntityDeleted()) {
                this.updateInternal();
            }
        });
    }

    protected void onUnload() {
        this._eventManagerHelper.onUnloadRemoveHandlersFromManager();
        super.onUnload();
    }

    public void setEntityEditModel(MemberEntityEditModel entityEditModel) {
        this._entityEditModel = entityEditModel;
        this.updateInternal();
    }

    @Nonnull
    private IconAnchor getOrCreateExportLink() {
        if (this._exportLink == null) {
            this._exportLink = new IconAnchor();
            this._exportLink.setText(this._entityConstants.exportEntityMemberToCSV());
            this._exportLink.setIcon(IconType.TABLE);
            this._exportLink.addStyleName("btn btn-link");
            this._exportLink.addClickHandler(clickEvent -> SuperAdminFunctionsWidget.downloadFile((String)("/toro/export/entity/members?entityId=" + this._entityId.getId())));
        }
        return this._exportLink;
    }

    @ParametersAreNonnullByDefault
    private void createEntityMemberConfiguratorPagingWidget(RoleOrInheritedRole role, String title, String tooltipText, EntityMemberConfiguratorPagingWidget.EntityMemberConfiguratorListType listType) {
        this._memberConfiguratorWidgets.add(new EntityMemberConfiguratorPagingWidget(this._clientFactory, this._entityId, this._entityEditModel, role, title, tooltipText, listType));
    }

    @Nonnull
    private EntityMemberConfiguratorWidget createMemberLists() {
        this.createEntityMemberConfiguratorPagingWidget((RoleOrInheritedRole)EntityMemberRole.MEMBER, this._entityConstants.members(), "", EntityMemberConfiguratorPagingWidget.EntityMemberConfiguratorListType.MEMBERSHIP_LIST);
        this.createEntityMemberConfiguratorPagingWidget((RoleOrInheritedRole)InheritsRole.INHERIT_MEMBERS, this._entityConstants.inheritedMembers(), this._entityConstants.inheritedMembersTooltip(), EntityMemberConfiguratorPagingWidget.EntityMemberConfiguratorListType.MEMBERSHIP_LIST);
        this.createEntityMemberConfiguratorPagingWidget((RoleOrInheritedRole)EntityMemberRole.HAS_SENT_JOINREQUEST, this._entityConstants.requests(), "", EntityMemberConfiguratorPagingWidget.EntityMemberConfiguratorListType.MEMBERSHIP_LIST);
        this.createEntityMemberConfiguratorPagingWidget((RoleOrInheritedRole)EntityMemberRole.HAS_INVITATION, this._entityConstants.invited(), "", EntityMemberConfiguratorPagingWidget.EntityMemberConfiguratorListType.MEMBERSHIP_LIST);
        this.createEntityMemberConfiguratorPagingWidget((RoleOrInheritedRole)EntityMemberRole.HAS_REJECTED, this._entityConstants.rejection(), "", EntityMemberConfiguratorPagingWidget.EntityMemberConfiguratorListType.MEMBERSHIP_LIST);
        return this;
    }

    @Nonnull
    private EntityMemberConfiguratorWidget createEventLists() {
        this.createEntityMemberConfiguratorPagingWidget((RoleOrInheritedRole)EntityMemberRole.EVENT_IS_ATTENDING, this._entityConstants.attending(), "", EntityMemberConfiguratorPagingWidget.EntityMemberConfiguratorListType.EVENT_LIST);
        this.createEntityMemberConfiguratorPagingWidget((RoleOrInheritedRole)EntityMemberRole.EVENT_IS_MAYBE_ATTENDING, this._entityConstants.maybeAttendEvent(), "", EntityMemberConfiguratorPagingWidget.EntityMemberConfiguratorListType.EVENT_LIST);
        this.createEntityMemberConfiguratorPagingWidget((RoleOrInheritedRole)EntityMemberRole.EVENT_IS_NOT_ATTENDING, this._entityConstants.notAttending(), "", EntityMemberConfiguratorPagingWidget.EntityMemberConfiguratorListType.EVENT_LIST);
        this.createEntityMemberConfiguratorPagingWidget((RoleOrInheritedRole)EntityMemberRole.EVENT_IS_ON_WAITINGLIST, this._entityConstants.onWaitinglistOfEvent(), "", EntityMemberConfiguratorPagingWidget.EntityMemberConfiguratorListType.EVENT_LIST);
        this.createEntityMemberConfiguratorPagingWidget((RoleOrInheritedRole)InheritsRole.INHERIT_MEMBERS, this._entityConstants.inheritedMembers(), this._entityConstants.inheritedMembersTooltip(), EntityMemberConfiguratorPagingWidget.EntityMemberConfiguratorListType.EVENT_LIST);
        this.createEntityMemberConfiguratorPagingWidget((RoleOrInheritedRole)EntityMemberRole.EVENT_IS_INVITED, this._entityConstants.invited(), "", EntityMemberConfiguratorPagingWidget.EntityMemberConfiguratorListType.EVENT_LIST);
        this.createEntityMemberConfiguratorPagingWidget((RoleOrInheritedRole)EntityMemberRole.EVENT_HAS_REJECTED_INVITATION, this._entityConstants.rejectedEventInvitation(), "", EntityMemberConfiguratorPagingWidget.EntityMemberConfiguratorListType.EVENT_LIST);
        return this;
    }

    @Nonnull
    private Form createContent() {
        Form result = new Form();
        result.addStyleName("administrateMembers");
        for (EntityMemberConfiguratorPagingWidget widget : this._memberConfiguratorWidgets) {
            result.add((Widget)widget);
        }
        return result;
    }

    private void createFinishButtons() {
        JCButton finishButton = new JCButton(this._entityConstants.finish());
        finishButton.setIcon(IconType.OK);
        finishButton.addClickHandler(event -> this._submitCallback.call(null));
        this._submitButtons.add((Widget)finishButton);
        ImmutableMap visibleTabs = FluentIterable.from((Iterable)this._entityEditModel.getVisibleTabs()).filter(tab -> EditEntityHistoryTokenTabName.MEMBERS != tab).toMap(tab -> e -> this._submitCallback.call(tab));
        if (!visibleTabs.isEmpty()) {
            this.addSaveAndContinueButton(visibleTabs);
        }
    }

    public void addSaveAndContinueButton(ImmutableMap<EditEntityHistoryTokenTabName, ClickHandler> visibleTabs) {
        JucoDropdownButton continueButton = new JucoDropdownButton();
        continueButton.setDropup(true);
        continueButton.add((Widget)new NavHeader(this._entityConstants.finishAndContinueTo()));
        visibleTabs.forEach((tab, clickHandler) -> continueButton.add((Widget)EditEntityLinkCreator.createLink((EditEntityHistoryTokenTabName)tab, (ClickHandler)clickHandler, (EntityConstants)this._entityConstants)));
        this._submitButtons.add((Widget)continueButton);
    }

    private void updateInternal() {
        ImmutableMap.Builder filters = ImmutableMap.builder();
        for (EntityMemberConfiguratorPagingWidget w : this._memberConfiguratorWidgets) {
            EntityMemberConfiguratorWidget.collectParams((ImmutableMap.Builder)filters, (EntityMemberConfiguratorPagingWidget)w);
        }
        this._clientFactory.entityMemberClientFactory().clientService().getEntityMemberConfiguratorInfo(this._entityId, filters.build(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static void collectParams(@Nonnull ImmutableMap.Builder<RoleOrInheritedRole, EntityMemberPagerParams> filters, @Nonnull EntityMemberConfiguratorPagingWidget pager) {
        filters.put((Object)pager.getRole(), (Object)pager.getFilter());
    }

    private void setCurrentPageData(EntityMemberConfiguratorPagingWidget pagingWidget, EntityMemberConfiguratorInfo data) {
        ListAndCount listAndCount = (ListAndCount)data.getEntityMembers().get((Object)pagingWidget.getRole());
        pagingWidget.setAllowedActions(data.getMay());
        pagingWidget.setCurrentPageData(pagingWidget.getFilter().getOffset(), pagingWidget.getFilter().getLimit(), listAndCount);
    }

    private void setPageDataInAllLists(EntityMemberConfiguratorInfo result) {
        for (EntityMemberConfiguratorPagingWidget w : this._memberConfiguratorWidgets) {
            this.setCurrentPageData(w, result);
        }
    }
}

