/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.presenter.recommendastask;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.common.presentation.client.ui.input.ValueInput;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.presentation.client.EntityRecommendationClientFactory;
import de.justsoftware.onx.container.presentation.client.ui.recommendastask.RecommendEntityAsTaskView;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import java.util.Collection;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class RecommendationSubmitHandler
implements RecommendEntityAsTaskView.SubmitHandler {
    private final EntityConstants _i18n;
    private final EntityRecommendationClientFactory _clientFactory;
    private final RecommendEntityAsTaskView _view;
    private final ValueInput<String> _title;
    private final ValueInput<String> _description;
    private final ValueInput<Integer> _receiverInput;
    private final List<PersonId> _receivers;
    private final EntityId _entityId;

    RecommendationSubmitHandler(RecommendEntityAsTaskView view, List<PersonId> receivers, ValueInput<Integer> receiverInput, EntityId entityId, ValueInput<String> title, ValueInput<String> description, EntityConstants i18n, EntityRecommendationClientFactory clientFactory) {
        this._entityId = entityId;
        this._i18n = i18n;
        this._clientFactory = clientFactory;
        this._view = view;
        this._title = title;
        this._description = description;
        this._receiverInput = receiverInput;
        this._receivers = receivers;
    }

    public void onSubmit() {
        String string;
        this._view.clearErrors();
        boolean isInvalid = false;
        String title = Strings.nullToEmpty((String)((String)this._title.get())).trim();
        if (title.isEmpty()) {
            this._title.error(this._i18n.recommendationTitleMustNotBeEmpty());
            isInvalid = true;
        }
        if ((string = Strings.nullToEmpty((String)((String)this._description.get())).trim()).isEmpty()) {
            this._description.error(this._i18n.recommendationDescriptionMustNotBeEmpty());
            isInvalid = true;
        }
        if (this._receivers.isEmpty()) {
            this._receiverInput.error(this._i18n.recommendationReceiverListMustNotBeEmty());
            isInvalid = true;
        }
        if (isInvalid) {
            return;
        }
        this._view.showProgressIndicator();
        this._clientFactory.controller().recommendEntityAsTask(this._entityId, title, string, ImmutableSet.copyOf((Collection)this._receivers), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

