/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.HTMLUtil;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.InlineHyperlink;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.common.presentation.client.ui.IconAndTooltip;
import de.justsoftware.onx.common.presentation.client.ui.JucoSafeHtmlTemplates;
import de.justsoftware.onx.common.shared.i18n.DateFormatter;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.components.presentation.client.ui.AnchorPanel;
import de.justsoftware.onx.container.presentation.client.EntityUtils;
import de.justsoftware.onx.container.presentation.client.PreviewPopupUtil;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.shared.model.EntityBadge;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.MyMemberStatus;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityUtils {
    private static final String BLANK = " ";
    private static final String START_AT_NAME_SEPARATOR = " - ";

    @Nonnull
    public static SafeHtml createEntityNameOrLabelHtml(@Nonnull EntityInfo e) {
        if (e.isVisible()) {
            return JucoSafeHtmlTemplates.INSTANCE.inlineHyperlink(StringUtil.breakWord((String)e.getName()), UriUtils.fromSafeConstant((String)("#" + EntityOverviewHandler.token((EntityId)((EntityId)e.getId())))));
        }
        return JucoSafeHtmlTemplates.INSTANCE.inlineLabel(StringUtil.breakWord((String)e.getName()));
    }

    @Nonnull
    public static Collection<SafeHtml> createEntityNamesOrLabelsHtml(@Nullable Collection<EntityInfo> entities) {
        if (CollectionUtil.isEmpty(entities)) {
            return ImmutableList.of();
        }
        return FluentIterable.from(entities).transform((Function)new /* Unavailable Anonymous Inner Class!! */).filter(Predicates.notNull()).toList();
    }

    @Nonnull
    public static IconAndTooltip createArchivedIconAndTooltip(@Nonnull Date expirationDate) {
        return new IconAndTooltip(IconType.HDD, EntityUtils.createArchivedTooltip((Date)expirationDate));
    }

    @Nonnull
    public static String createArchivedTooltip(@Nonnull Date expirationDate) {
        return I18nMediator.ENTITY_VERSION_CONSTANTS.archivedSince() + ": " + ClientFactoryImpl.INSTANCE.dateFormatter().formatDateTime(expirationDate);
    }

    @Nonnull
    public static Widget createBadgeEntityNameLinkOrLabel(@Nonnull EntityBadge e, @Nullable ClickHandler clinkClickHandler, boolean highlightTeaserName) {
        ImmutableList icons;
        DateWithoutTimezone expirationDate;
        ImmutableList.Builder iconBuilder = ImmutableList.builder();
        EntityVersionClientModel lastPublicVersion = e.getLastPublicVersion();
        if (lastPublicVersion != null && lastPublicVersion.getStatus().isArchived() && (expirationDate = lastPublicVersion.getExpirationDate()) != null) {
            iconBuilder.add((Object)EntityUtils.createArchivedIconAndTooltip((Date)expirationDate));
        }
        if ((icons = iconBuilder.build()).isEmpty()) {
            return EntityUtils.createEntityNameLinkOrLabel((EntityInfo)e, (EntityLinkOptions)EntityLinkOptions.create().withClickHandler(clinkClickHandler).highlightName(highlightTeaserName).inlineElement(true));
        }
        return EntityUtils.createEntityNameLinkOrLabelWithIcons((EntityInfo)e, (Iterable)icons, (ClickHandler)clinkClickHandler, (boolean)highlightTeaserName);
    }

    @Nonnull
    public static Widget createEntityNameLinkOrLabel(@Nonnull EntityInfo e, @Nonnull EntityLinkOptions options) {
        String startAtPrefix = EntityUtils.getStartAtNamePrefix((EntityInfo)e);
        if (e.isVisible()) {
            InlineHyperlink entityLink = options.isInline() ? new InlineHyperlink() : new Hyperlink();
            entityLink.setText(startAtPrefix + e.getName());
            entityLink.setTargetHistoryToken(EntityOverviewHandler.token((EntityId)((EntityId)e.getId())));
            if (options._clickHandler != null) {
                entityLink.addClickHandler(options._clickHandler);
            }
            if (options.highlightTeaserName()) {
                entityLink.setHTML(SafeHtmlUtils.fromTrustedString((String)(startAtPrefix + HTMLUtil.highlightedHtmlEscape((String)e.getName()).asString())));
                entityLink.setTitle(startAtPrefix + HTMLUtil.removeHighlightTag((String)e.getName()));
            } else {
                entityLink.setTitle(startAtPrefix + e.getName());
            }
            if (options.showPreview()) {
                PreviewPopupUtil.attachEntityPreviewPopup((IsWidget)entityLink, (EntityId)((EntityId)e.getId()));
            }
            return entityLink;
        }
        InlineLabel l = options.isInline() ? new InlineLabel() : new Label();
        l.setText(startAtPrefix + e.getName());
        l.setTitle(startAtPrefix + e.getName());
        return l;
    }

    @Nonnull
    public static Widget createEntityNameLinkOrLabelWithIcon(@Nonnull EntityInfo e, @Nonnull IconType iconType, @Nullable String iconTooltip, @Nullable ClickHandler linkClickHandler) {
        return EntityUtils.createEntityNameLinkOrLabelWithIcon((EntityInfo)e, (IconType)iconType, (String)iconTooltip, (ClickHandler)linkClickHandler, (boolean)false);
    }

    @Nonnull
    public static String getStartAtNamePrefix(@Nonnull EntityType type, @Nullable Date startAt, @Nullable Date endAt) {
        ClientEntityConfig config = HostPropertiesMediator.getClientEntityConfig((EntityType)type);
        if (config.getDurationTimeOption() == EntityDurationTimeOption.OFF || startAt == null) {
            return "";
        }
        boolean isWholeDay = Dates.isWholeDay((Date)startAt, (Date)endAt);
        DateFormatter dateFormatter = ClientFactoryImpl.INSTANCE.dateFormatter();
        return (isWholeDay ? dateFormatter.formatDate(startAt) : dateFormatter.formatDateTime(startAt)) + " - ";
    }

    @Nonnull
    public static String getStartAtNamePrefix(@Nonnull EntityInfo e) {
        return EntityUtils.getStartAtNamePrefix((EntityType)((EntityType)e.getType()), (Date)e.getStartAt(), (Date)e.getEndAt());
    }

    @Nonnull
    public static Widget createEntityNameLinkOrLabelWithIcons(@Nonnull EntityInfo e, @Nonnull Iterable<IconAndTooltip> icons, @Nullable ClickHandler linkClickHandler, boolean highlightTeaserName) {
        AnchorPanel result = new AnchorPanel();
        if (e.isVisible()) {
            String targetHistoryToken = EntityOverviewHandler.token((EntityId)((EntityId)e.getId()));
            result.setTargetHistoryToken(targetHistoryToken);
            for (IconAndTooltip iconAndTooltip : icons) {
                IconAnchor icon = iconAndTooltip.createIconAnchor(targetHistoryToken, linkClickHandler);
                icon.addStyleName("entity-label-icon");
                result.add((Widget)icon);
            }
            String startAtPrefix = EntityUtils.getStartAtNamePrefix((EntityInfo)e);
            InlineHTML label = new InlineHTML(startAtPrefix + e.getName());
            if (linkClickHandler != null) {
                result.addClickHandler(linkClickHandler);
            }
            if (highlightTeaserName) {
                label.setHTML(SafeHtmlUtils.fromTrustedString((String)(startAtPrefix + HTMLUtil.highlightedHtmlEscape((String)e.getName()).asString())));
                result.setTitle(startAtPrefix + HTMLUtil.removeHighlightTag((String)e.getName()));
            } else {
                result.setTitle(startAtPrefix + e.getName());
            }
            result.add((Widget)label);
        } else {
            for (IconAndTooltip iconAndTooltip : icons) {
                Icon icon = iconAndTooltip.createIcon();
                icon.setIconSize(IconSize.LARGE);
                icon.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
                result.add((Widget)icon);
                result.add((Widget)new InlineLabel(" "));
            }
            InlineLabel inlineLabel = new InlineLabel(e.getName());
            inlineLabel.setTitle(e.getName());
            result.add((Widget)inlineLabel);
        }
        return result;
    }

    @Nonnull
    public static Widget createEntityNameLinkOrLabelWithIcon(@Nonnull EntityInfo e, @Nonnull IconType iconType, @Nullable String iconTooltip, @Nullable ClickHandler linkClickHandler, boolean highlightTeaserName) {
        return EntityUtils.createEntityNameLinkOrLabelWithIcons((EntityInfo)e, (Iterable)ImmutableList.of((Object)new IconAndTooltip(iconType, iconTooltip)), (ClickHandler)linkClickHandler, (boolean)highlightTeaserName);
    }

    @Nonnull
    public static Panel createEntityNameLinksOrLabels(@Nullable Iterable<? extends EntityInfo> es, @Nullable ClickHandler linkClickHandler) {
        FlowPanel p = new FlowPanel();
        p.addStyleName("inlinePanel");
        EntityUtils.addEntityNameLinksOrLabels((HasWidgets)p, es, (ClickHandler)linkClickHandler);
        return p;
    }

    public static void addEntityNameLinksOrLabels(@Nonnull HasWidgets p, @Nullable Iterable<? extends EntityInfo> es) {
        EntityUtils.addEntityNameLinksOrLabels((HasWidgets)p, es, null);
    }

    public static void addEntityNameLinksOrLabels(@Nonnull HasWidgets p, @Nullable Iterable<? extends EntityInfo> es, @Nullable ClickHandler linkClickHandler) {
        if (es == null) {
            return;
        }
        boolean first = true;
        for (EntityInfo entityInfo : es) {
            if (!first) {
                p.add((Widget)new InlineLabel(", "));
            }
            Widget linkToEntity = EntityUtils.createEntityNameLinkOrLabel((EntityInfo)entityInfo, (EntityLinkOptions)EntityLinkOptions.create().withClickHandler(linkClickHandler).inlineElement(true));
            p.add(linkToEntity);
            first = false;
        }
    }

    @Nonnull
    public static String getI18nMemberStatus(@Nonnull EntityType type, @Nullable MyMemberStatus status) {
        return (String)MyMemberStatus.PublicEventStatus.valueOf((MyMemberStatus)status).visit((MyMemberStatus.PublicEventStatusVisitor)new PublicEventStatusEntityConstantsVisitor(I18nMediator.getEntityConstantsByEntityType((EntityType)type)));
    }
}

