/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.shared.model;

import de.justsoftware.onx.common.shared.model.JCMediaContent;
import de.justsoftware.onx.common.shared.model.JCMediaContentId;
import java.io.Serializable;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ContentOverlayObject<T extends JCMediaContent<?>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int _totalCount;
    private int _position;
    private JCMediaContentId _prev;
    private JCMediaContentId _next;
    private T _object;

    @Deprecated
    public ContentOverlayObject() {
    }

    public ContentOverlayObject(@Nonnull T obj) {
        this(obj, 0, 1, null, null);
    }

    public ContentOverlayObject(@Nonnull T obj, int position, int totalCount, @Nullable JCMediaContentId prev, @Nullable JCMediaContentId next) {
        this._object = obj;
        this._position = position;
        this._totalCount = totalCount;
        this._prev = prev;
        this._next = next;
    }

    public ContentOverlayObject(@Nonnull T obj, @Nonnull List<? extends JCMediaContentId> allIds) {
        int index;
        this._object = obj;
        JCMediaContentId id = (JCMediaContentId)obj.getId();
        int n = index = id != null ? allIds.indexOf(id) : -1;
        if (index < 0 || allIds.size() <= 1) {
            this._position = 0;
            this._totalCount = 1;
            this._prev = null;
            this._next = null;
        } else {
            this._position = index;
            this._totalCount = allIds.size();
            int lastValidPosition = this._totalCount - 1;
            this._prev = allIds.get(this._position > 0 ? this._position - 1 : lastValidPosition);
            this._next = allIds.get(this._position < lastValidPosition ? this._position + 1 : 0);
        }
    }

    public int getTotalCount() {
        return this._totalCount;
    }

    public int getPosition() {
        return this._position;
    }

    @CheckForNull
    public JCMediaContentId getPrev() {
        return this._prev;
    }

    @CheckForNull
    public JCMediaContentId getNext() {
        return this._next;
    }

    @Nonnull
    public T getObject() {
        return (T)this._object;
    }
}

