/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.History;
import de.justsoftware.onx.common.presentation.client.ui.PopupCloseHelper;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PopupCloseHelperImpl
implements PopupCloseHelper {
    private final List<Element> _ignoredElements = Lists.newLinkedList();
    @Nonnull
    private ImmutableList<HandlerRegistration> _handlerRegistragions = ImmutableList.of();
    @Nonnull
    private PopupCloseHelper.HistoyMode _historyMode = PopupCloseHelper.HistoyMode.CONSIDER_HISTORY_CHANGE;
    @CheckForNull
    private PopupCloseHelper.ClosePopupClickHandler _handler;

    private static boolean eventTargetsElements(Iterable<Element> elements, NativeEvent event) {
        EventTarget target = event.getEventTarget();
        if (Element.is((JavaScriptObject)target)) {
            Element element = Element.as((JavaScriptObject)target);
            for (Element elem : elements) {
                if (!elem.isOrHasChild((Node)element)) continue;
                return true;
            }
        }
        return false;
    }

    public void ignoreElement(Element element) {
        this._ignoredElements.add(element);
    }

    public void considerElement(Element element) {
        this._ignoredElements.remove(element);
    }

    public void setHandler(PopupCloseHelper.ClosePopupClickHandler handler) {
        this._handler = handler;
    }

    public void setHistoryMode(PopupCloseHelper.HistoyMode historyMode) {
        this._historyMode = historyMode;
    }

    public void registerHandler() {
        this.unregisterHandler();
        HandlerRegistration historyHandler = History.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        HandlerRegistration nativeHandler = Event.addNativePreviewHandler((Event.NativePreviewHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._handlerRegistragions = ImmutableList.of((Object)historyHandler, (Object)nativeHandler);
    }

    private void handleClick() {
        if (this._handler != null) {
            this._handler.onClick();
        }
    }

    public void unregisterHandler() {
        for (HandlerRegistration r : this._handlerRegistragions) {
            r.removeHandler();
        }
        this._handlerRegistragions = ImmutableList.of();
    }
}

