/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.common.presentation.client.ui.BadgeWidget;
import de.justsoftware.onx.common.shared.model.BadgeField;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.components.presentation.client.ui.AnchorPanel;
import de.justsoftware.onx.container.presentation.client.ui.ReactProfileComponent;
import de.justsoftware.onx.person.presentation.client.ProfileFieldNameTranslator;
import de.justsoftware.onx.person.shared.model.PersonBadgeModel;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PersonBadgeWidget<T extends PersonBadgeModel>
extends BadgeWidget<T> {
    public PersonBadgeWidget(T person, boolean first, boolean last) {
        super(person, first, last);
        this.addPicture();
        this.addDetails();
    }

    private void addDetails() {
        this.addTypeAndName();
        this.addVisibleProfileFields(((PersonBadgeModel)this._badge).getVisibleFields(), ":");
    }

    protected final String getNameByType(Type type) {
        return BASIC_CONSTANTS.profile();
    }

    protected final Widget getLinkOrLabelWidget() {
        return PersonUtil.profileLink((PersonTeaserModel)((PersonTeaserModel)this._badge), (ClientFactory)ClientFactoryImpl.INSTANCE, (PersonUtil.PopupOption)PersonUtil.PopupOption.WITH_POPUP);
    }

    protected final void addPicture() {
        AnchorPanel ap = new AnchorPanel();
        Image icon = new Image(ImageUrlUtil.getFullSmallUserImageUrl((String)((PersonBadgeModel)this._badge).getLogo()));
        icon.addStyleName("userimage");
        ap.add((Widget)icon);
        ap.setTargetHistoryToken(ReactProfileComponent.token((PersonId)((PersonId)((PersonBadgeModel)this._badge).getId())));
        this.setImage((Widget)ap);
    }

    protected final void addVisibleProfileFields(@Nullable List<BadgeField> visibleFields, @Nonnull String separator) {
        if (!CollectionUtil.isEmpty(visibleFields)) {
            for (BadgeField field : visibleFields) {
                BadgeField translatedField = ProfileFieldNameTranslator.INSTANCE.translate(field);
                FlowPanel contentPanel = new FlowPanel();
                for (String content : translatedField.getContentList()) {
                    if (StringUtil.isBlank((String)content)) continue;
                    contentPanel.add((Widget)new Label(content));
                }
                if (contentPanel.getWidgetCount() <= 0) continue;
                this.addDetailsRow(translatedField.getName() + separator, (Widget)contentPanel);
            }
        }
    }
}

