/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.util.client.LoggingUtil;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.EntityComponentHandler;
import de.justsoftware.onx.common.presentation.client.ui.PlaceHolder;
import de.justsoftware.onx.common.presentation.client.ui.ProfileComponentHandler;
import de.justsoftware.onx.common.shared.model.ComponentModel;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.ComponentTypeVisitor;
import de.justsoftware.onx.common.shared.model.component.CssClassComponentTypeVisitor;
import de.justsoftware.onx.common.shared.util.ValueOfMap;
import de.justsoftware.onx.container.presentation.client.ui.ComponentConfiguratorWidget;
import de.justsoftware.onx.container.presentation.shared.model.entityedit.ComponentConfigurationEntityEditModel;
import de.justsoftware.onx.container.shared.model.ComponentPositionConfig;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.person.shared.model.PersonDetailsModel;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/*
 * Exception performing whole class analysis ignored.
 */
public class ComponentClientFactory {
    private final ClientFactory _clientFactory;
    private final ValueOfMap<EntityType, EntityComponentHandler> _childEntitiesHandler = new /* Unavailable Anonymous Inner Class!! */;
    private final ComponentTypeVisitor<Optional<? extends EntityComponentHandler>> _entityComponentHandlers = new /* Unavailable Anonymous Inner Class!! */;
    private final ComponentTypeVisitor<Optional<? extends ProfileComponentHandler>> _profileComponentHandlers = new /* Unavailable Anonymous Inner Class!! */;

    public ComponentClientFactory(@Nonnull ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
    }

    @CheckForNull
    private EntityComponentHandler getEntityComponentHandler(@Nonnull ComponentType type) {
        return ((Optional)type.accept(this._entityComponentHandlers)).orElse(null);
    }

    @CheckForNull
    private ProfileComponentHandler getProfileComponentHandler(@Nonnull ComponentType type) {
        return ((Optional)type.accept(this._profileComponentHandlers)).orElse(null);
    }

    public void replacePlaceHolderWithProfileComponentWidget(@Nonnull PlaceHolder placeHolder, @Nonnull ComponentModel component, @Nonnull PersonDetailsModel personViewModel) {
        try {
            ProfileComponentHandler handler = this.getProfileComponentHandler(component.getType());
            this.addComponentCssClass(placeHolder, component);
            if (handler == null) {
                placeHolder.replace((IsWidget)new Label(component.getType() + " is not implemented"));
            } else {
                handler.createProfileComponentPresenter(placeHolder, component, personViewModel, this._clientFactory);
            }
        }
        catch (RuntimeException e) {
            LoggingUtil.error(ComponentClientFactory.class, (String)("Can not create profile component widget for " + component.getType().name() + ": " + e));
            placeHolder.replace((IsWidget)new Label(""));
        }
    }

    private void addComponentCssClass(@Nonnull PlaceHolder placeHolder, @Nonnull ComponentModel component) {
        placeHolder.addReplacementStyle(new String[]{"component", ComponentClientFactory.getComponentCssClass((ComponentType)component.getType())});
    }

    public void replacePlaceHolderWithEntityComponentWidget(@Nonnull PlaceHolder placeHolder, @Nonnull ComponentModel component, @Nonnull EntityDetails entity) {
        try {
            this.addComponentCssClass(placeHolder, component);
            EntityComponentHandler handler = this.getEntityComponentHandler(component.getType());
            if (handler == null) {
                placeHolder.replace((IsWidget)new Label(component.getType() + " is not implemented"));
            } else {
                handler.getEntityComponentWidget(this._clientFactory, placeHolder, component, entity);
            }
        }
        catch (RuntimeException e) {
            LoggingUtil.error(ComponentClientFactory.class, (String)("Can not create widget for " + entity.getType().name() + ": " + e));
            placeHolder.replace((IsWidget)new Label(""));
        }
    }

    @Nonnull
    public ComponentConfiguratorWidget getEntityComponentConfigWidget(@Nonnull ComponentPositionConfig component, @Nonnull EntityId entityId, @Nonnull ComponentConfigurationEntityEditModel entity) {
        try {
            EntityComponentHandler handler = this.getEntityComponentHandler(component.getType());
            return handler == null ? ComponentConfiguratorWidget.withoutRoleConfig((String)component.getType().name(), (ComponentPositionConfig)component, (ComponentConfigurationEntityEditModel)entity, (boolean)false) : handler.getEntityComponentConfigWidget(component, entityId, entity);
        }
        catch (RuntimeException e) {
            LoggingUtil.error(ComponentClientFactory.class, (String)("Can not create widget for " + entity.getEntityType() + ": " + e));
            return ComponentConfiguratorWidget.withoutRoleConfig((String)component.getType().name(), (ComponentPositionConfig)component, (ComponentConfigurationEntityEditModel)entity, (boolean)false);
        }
    }

    @Nonnull
    private static String getComponentCssClass(@Nonnull ComponentType componentType) {
        return (String)componentType.accept((ComponentTypeVisitor)CssClassComponentTypeVisitor.INSTANCE);
    }
}

