/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.github.gwtbootstrap.client.ui.base.ListItem;
import com.github.gwtbootstrap.client.ui.base.UnorderedList;
import com.google.common.collect.Iterables;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.LinkUtil;
import de.justsoftware.onx.common.shared.model.EntityLink;
import de.justsoftware.onx.common.shared.model.Link;
import de.justsoftware.onx.container.presentation.client.EntityMediator;
import de.justsoftware.onx.container.presentation.client.PreviewPopupUtil;
import de.justsoftware.onx.container.shared.model.BreadCrumbLink;
import de.justsoftware.onx.container.shared.model.BreadCrumbViewData;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import java.util.Iterator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class BreadCrumbWidget
extends Composite {
    private final UnorderedList _breadCrumbPanel = new UnorderedList();

    public BreadCrumbWidget() {
        this.initWidget((Widget)this._breadCrumbPanel);
        this.addStyleName("just-breadcrumb clearfix");
        this.setVisible(false);
    }

    public void add(Widget w) {
        this.setVisible(true);
        this.insert(w, this._breadCrumbPanel.getWidgetCount() > 0, this.getCurrentIndex());
    }

    public void add(String s) {
        Label label = new Label(s);
        label.setTitle(s);
        this.add((Widget)label);
    }

    public void add(GlobalId itemId) {
        this.add(itemId, false);
    }

    public void set(GlobalId itemId, boolean lastLinkIsLabel) {
        this.add(itemId, lastLinkIsLabel, true);
    }

    public void add(GlobalId itemId, boolean lastLinkIsLabel) {
        this.add(itemId, lastLinkIsLabel, false);
    }

    public void add(GlobalId itemId, boolean lastLinkIsLabel, boolean clearBeforeInsert) {
        EntityMediator.getInstance().breadcrumb(itemId, EntityMediator.getInstance().getLastChangedEntityId(), EntityMediator.getInstance().getCurrentLayoutEntityId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void add(BreadCrumbViewData breadcrumb, boolean lastLinkIsLabel) {
        this.addInternal(breadcrumb, lastLinkIsLabel, false);
    }

    private void addInternal(BreadCrumbViewData breadcrumb, boolean lastLinkIsLabel, boolean clearBeforeInsert) {
        List parents = breadcrumb.getParents();
        if (clearBeforeInsert) {
            this.clear();
        }
        this.add(Iterables.concat((Iterable)parents, (Iterable)breadcrumb.getChildren()), lastLinkIsLabel);
    }

    private int getCurrentIndex() {
        return this._breadCrumbPanel.getWidgetCount();
    }

    private void insert(Widget w, boolean insertSeparator, int insertBefore) {
        int insertIndex = insertBefore;
        if (insertSeparator) {
            ListItem divider = new ListItem(new Widget[]{new Label(" / ")});
            divider.addStyleName("breadcrumb-divider");
            this._breadCrumbPanel.insert((Widget)divider, insertIndex);
            ++insertIndex;
        }
        ListItem breadcrumbItem = new ListItem(new Widget[]{w});
        breadcrumbItem.addStyleName("breadcrumb-item");
        this._breadCrumbPanel.insert((Widget)breadcrumbItem, insertIndex);
    }

    private void add(Iterable<BreadCrumbLink> links, boolean lastLinkIsLabel) {
        Iterator<BreadCrumbLink> it = links.iterator();
        while (it.hasNext()) {
            Link link = it.next().getLink();
            if (lastLinkIsLabel && !it.hasNext()) {
                link.setHref(null);
            }
            if (link.getHref() != null && link instanceof EntityLink) {
                this.add((Widget)PreviewPopupUtil.attachEntityPreviewPopup((IsWidget)LinkUtil.getLinkWidget((Link)link, (boolean)true, (boolean)true), (EntityId)((EntityLink)link).getEntityId()));
                continue;
            }
            this.add(LinkUtil.getLinkWidget((Link)link, (boolean)true, (boolean)true));
        }
        this.setVisible(true);
    }

    public void clear() {
        this._breadCrumbPanel.clear();
        this.setVisible(true);
    }
}

