/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.calendar.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.calendar.presentation.client.CalendarViewHandler;
import de.justsoftware.onx.calendar.presentation.client.ui.CalendarViewInfoPopupPanel;
import de.justsoftware.onx.calendar.presentation.client.ui.MonthViewDayDetailedPopupContent;
import de.justsoftware.onx.calendar.presentation.client.ui.TimedAppointmentWidget;
import de.justsoftware.onx.calendar.presentation.client.ui.WholeDayAppointmentWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.JCDateTimeFormat;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.EntityBadge;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

public class MonthViewDayDetailedPopupContent
extends Composite {
    private static final MonthViewDayDetailedPopupContentUIBinder BINDER = (MonthViewDayDetailedPopupContentUIBinder)GWT.create(MonthViewDayDetailedPopupContentUIBinder.class);
    private static final JCDateTimeFormat DATE_FORMAT = JCDateTimeFormat.forPattern((String)I18nMediator.BASIC_CONSTANTS.dateFormatFullMonth());
    @UiField
    FlowPanel _contentPanel;
    @UiField
    FlowPanel _header;
    @UiField
    Label _title;
    private final ClientFactory _clientFactory;

    @ParametersAreNonnullByDefault
    public MonthViewDayDetailedPopupContent(Date day, Set<EntityBadge> timedAppointments, Set<EntityBadge> multiDayAppointments, @Nullable CalendarViewHandler calendarViewHandler, int width, boolean mayCreateAppointment, EntityType type, ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this.initWidget((Widget)BINDER.createAndBindUi((Object)this));
        this.initHeader(day);
        int count = 0;
        if (!CollectionUtil.isEmpty(multiDayAppointments)) {
            count += multiDayAppointments.size();
            this.addWholeDayAppointmentWidgets(day, multiDayAppointments, calendarViewHandler, width);
        }
        if (!CollectionUtil.isEmpty(timedAppointments)) {
            count += timedAppointments.size();
            this.addTimedAppointmentWidgets(timedAppointments, calendarViewHandler, width);
        }
        if (count == 0) {
            FlowPanel panel = new FlowPanel();
            panel.addStyleName("month-view-day-detailed-popup-content-no-entries");
            this._contentPanel.add((Widget)panel);
            Label noEventsLabel = new Label(I18nMediator.BASIC_CONSTANTS.noEntries());
            panel.add((Widget)noEventsLabel);
        }
        if (mayCreateAppointment) {
            this.addCreateButton((Panel)this._contentPanel, day, calendarViewHandler, type, width);
        }
    }

    private void addTimedAppointmentWidgets(@Nonnull Set<EntityBadge> timedAppointments, @Nullable CalendarViewHandler calendarViewHandler, int width) {
        for (EntityBadge app : timedAppointments) {
            TimedAppointmentWidget widget = new TimedAppointmentWidget(app, calendarViewHandler, CalendarViewInfoPopupPanel.PopupPriority.SECONDARY, width);
            widget.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this._contentPanel.add((Widget)widget);
        }
    }

    @Nonnull
    private Date getEndOfDay(@Nonnull Date day) {
        Date endOfDay = (Date)day.clone();
        endOfDay.setHours(23);
        endOfDay.setMinutes(59);
        return endOfDay;
    }

    private void addWholeDayAppointmentWidgets(@Nonnull Date day, @Nonnull Set<EntityBadge> multiDayAppointments, @Nullable CalendarViewHandler calendarViewHandler, int width) {
        for (EntityBadge app : multiDayAppointments) {
            DateWithoutTimezone startAt = app.getStartAt();
            DateWithoutTimezone endAt = app.getEndAt();
            if (startAt == null || endAt == null) continue;
            boolean displayTime = Dates.areOnTheSameDay((Date)day, (Date)startAt) && !Dates.isWholeDay((Date)startAt, (Date)app.getEndAt());
            WholeDayAppointmentWidget w = new WholeDayAppointmentWidget(app, calendarViewHandler, width, width, displayTime, false, CalendarViewInfoPopupPanel.PopupPriority.SECONDARY, day.after((Date)startAt), this.getEndOfDay(day).before((Date)endAt));
            w.addStyleName("cursorPointer");
            w.addMouseOverHandler((MouseOverHandler)new /* Unavailable Anonymous Inner Class!! */);
            w.addMouseOutHandler((MouseOutHandler)new /* Unavailable Anonymous Inner Class!! */);
            w.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this._contentPanel.add((Widget)w);
        }
    }

    private void initHeader(@Nonnull Date day) {
        String dayAsString = DATE_FORMAT.format(day);
        this._title.setText(dayAsString);
        this._title.setTitle(dayAsString);
    }

    private void addCreateButton(@Nonnull Panel panel, @Nonnull Date day, @Nullable CalendarViewHandler calendarViewHandler, @Nonnull EntityType type, int width) {
        Date defaultDate = (Date)day.clone();
        Dates.resetTime((Date)defaultDate);
        FlowPanel btnGroup = new FlowPanel();
        btnGroup.addStyleName("calendar-create-actions");
        btnGroup.getElement().getStyle().setProperty("min-width", width + "px");
        panel.add((Widget)btnGroup);
        JCButton createButton = new JCButton();
        createButton.setTitle(this._clientFactory.localizedMessages().entityConstants(type).createEntity());
        createButton.setIcon(IconType.PLUS);
        createButton.addStyleName("calendar-create-button");
        createButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        btnGroup.add((Widget)createButton);
    }
}

